/*
 *  rofftex.y from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%{
#include "rofftex.h"
%}
%union {
	const char * Name ;
	int Int ;
	const char * String ;
	int Terminal ;
	enum TableOptionSelect TabOptSel ;
	} 
%token <String> QUOTED_STRING TEXT_LINE TABLE_FORMAT
%token <String> TABLE_ENTRY TS_OPTION_PARAMETER VERBATIM_LINE
%token <String> CAPTION_STRING VERBATIM_REPLACE_LINE VERBATIM_LINE_SKIP
%token ROFF_H ROFF_AL ROFF_ALA ROFF_LI ROFF_TS ROFF_TE ROFF_P
%token ROFF_NF ROFF_FI EMPTY_VERBATIM
%token END_OF_TABLE_LINE ROFF_LE TAB
%token <Int> INTEGER_VAL CAPTION 
%token <TabOptSel> TABLE_OPTIONS
%token SHIFT_R SHIFT_L LEQ GEQ EQU NEQ AND OR
%type <Int> CaptionHead
%%

File : RoffEntity | File RoffEntity

RoffEntity : SectionHeader | Command | TextLine | List | Table

SectionHeader : ROFF_H INTEGER_VAL QUOTED_STRING 	{Section($2,$3);}

Command : ROFF_P				{NewParagraph();}

	| ROFF_NF				{Verbatim(1);}

	| ROFF_FI				{Verbatim(0);}

List : ListBegin ListItems ROFF_LE		{EndList();}

ListBegin : ROFF_AL 				{BeginNumberedList();}

	| ROFF_ALA 				{BeginLetteredList();}

ListItems : ListItem | ListItems ListItem

ListItem : ItemMarker ListLines

ItemMarker : ROFF_LI				{BeginListItem();}

ListLines : ListLine | ListLines ListLine

ListLine : TEXT_LINE				{ListTextLine($1);}

Table : TableBody

	| Caption TableBody

CaptionHead : CAPTION IndexColumnList

	| CAPTION

IndexColumnList : IndexColumnValue

	| IndexColumnList IndexColumnValue

IndexColumnValue : INTEGER_VAL				{IndexColumn($1);}

	| '-' INTEGER_VAL				{IndexColumn(-$2);}

Caption : CaptionHead CAPTION_STRING			{Caption($2);}

	|  CaptionHead CAPTION_STRING CAPTION_STRING	{Caption($2,$3);}

TableBody : ROFF_TS OptionalOptions Format Data ROFF_TE	{TableEnd();}

OptionalOptions : Options

	|

Options : Option

	| Options Option

Option : TABLE_OPTIONS TS_OPTION_PARAMETER	{TableOptions($1,$2);}

	| TABLE_OPTIONS				{TableOptions($1);}

Format : TABLE_FORMAT END_OF_TABLE_LINE		{TableFormat($1);}

Data : TableEntryList

TableEntryList : TableLine | TableEntryList TableLine

TableLine : AllLineElements END_OF_TABLE_LINE 	{TableNewLine();}

AllLineElements : LineElements

	| LineElements TableEntry

	| TableEntry 

LineElements : LineElement

	| LineElements LineElement

LineElement : TableEntry Tab

	| Tab

Tab : TAB					{FoundTab();}

TableEntry : TABLE_ENTRY 			{TableEntry($1);}

	| VERBATIM_LINE TABLE_ENTRY	{TableEntry($2);}


TextLine : TEXT_LINE				{TextLine($1);}

	| VERBATIM_LINE				{VerbatimLine($1);}

	| EMPTY_VERBATIM			{EmptyVerbatim();}

	| VERBATIM_LINE_SKIP 		{FlushTextLine($1);}

	| VERBATIM_REPLACE_LINE		{FlushTextLine($1);}

