/*
 *  toc_depth.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProGen/cpyrght_exe.h"
#include <stream.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

int check_depth(const char * str)
{
	static int length = -1 ;
	static const char * start = "\\numberline {" ;
	if (length < 0) length = strlen(start);
	if (strncmp(str,start,length)) return 0 ;
	// cerr << "found numberline\n" ;

	str += length ;
	int in_int = 0 ;
	int depth = 0 ;
	for (const char * pt = str+1; *pt;pt++) {
		if (*pt == '.') if (!in_int) return 0 ;
		else {
			in_int = 0 ;
			depth++ ;
		} else if (isdigit(*pt)) in_int = 1 ;
		else if (*pt == '}') {
			if (!in_int) return 0 ;
			depth++ ;
			// cerr << "depth = " << depth << "\n" ;
			return depth > 2 ;
		} else return 0 ;
	}
	return 0 ;
}

main()
{
	const buf_size = 4096 ;
	char buf[buf_size] ;
	int do_skip = 0 ;
	static int length = -1 ;
	char * start = "MENUS REFERENCE" ;
	if (length < 0) length = strlen(start);
	while(fgets(buf,buf_size,stdin)) {
		if (!do_skip) {
			for (const char * pt = buf; *pt;pt++)
			  if(!strncmp(pt,start,length)) {
				// cerr << "Found menus\n" ;
				do_skip = 1 ;
				break ;
			}
		} else {
			for (const char * pt = buf; *pt;pt++) if(check_depth(pt)) break;
			if (*pt) continue;
		}
		fputs(buf,stdout);
	}
		

}
