/*
 *  gen_dpp_code.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <stream.h>
#include <stdlib.h>
#include <unistd.h>
#include "ObjProGen/mkstr.h"
#define MAKE_STRING(str)#str
#define TOT OUT_TOT(TOTAL)
#define TOTAL 32
#define TOT_STR(a,b) MAKE_STRING(a##32##b)

void usage(const char *pgm)
{
	cerr << "Usages is: " << pgm << " [ -i] [-f file_prefix]\n" ;
	cerr <<
		"The default is to write generator code, `-i' writes reader code.\n";
	exit(1);
}


main(int argc, char ** argv)
{
	int do_generator = 1 ;
	int ltr ;
	const char * file_prefix = "io" ;
	while ((ltr = getopt(argc, argv, "if:")) != EOF) switch (ltr) {
case 'f' :
		file_prefix = optarg ;
		break ;
case 'i' :
		do_generator = 0 ;
		break ;
default:
		usage(argv[0]);
		break ;
	}
	
	int lim = TOTAL + 1 ;
	//name of output network must be alphabetically before input node becaus
	// test cases are executed in alphabetical `sort' order.
	const char * in_net_name = TOT_STR(B_InputNode_with_,_outputs) ;
	const char * out_net_name = TOT_STR(A_OutputNode_with_,_inputs);
	const char * net_name = do_generator ?out_net_name : in_net_name ;
	const char * file_name = Concatenate(file_prefix,TOT_STR(_,_chan.dat));

	cout << "Network " << net_name << " ;\n" ;
	if (do_generator) {
		const char* sig_name = "Cos_sig_" ;
		const char* out_node_name = TOT_STR(OutputNode_with_,_inputs) ;
	
		for (int i = 1 ; i < lim; i++) {
			cout << "Cos " << sig_name << i << "(" << (i / 12.) <<
				", 0.4, 1.024e+03);\n" ;
		}
		cout << "OutputNode " << out_node_name <<
			"(\"" << file_name << "\", 1, " << TOTAL << ", 128, 0, 1);\n" ;
	
		for (i = 1 ; i < lim; i++) {
			cout << net_name << " + " << sig_name << i << " >> " << out_node_name
			<< ";\n" ;
		}
	} else {
		const char * plot_name = "Plot_dsk_" ;
		const char * in_node_name = TOT_STR(InputNode_with_,_outputs) ;
		for (int i = 1 ; i < lim; i++) {
			cout << "Plot " << plot_name << i << ";\n" ;
		}
		cout << "InputNode " << in_node_name << "(\"" << file_name <<
			"\", 0, 1);\n" ;

		for (i = 1 ; i < lim; i++) {
			if (i == 1) cout << net_name << " + " << in_node_name << " >> "
			<< plot_name << i << ";\n" ;
		else cout << net_name << ".Link(" <<  in_node_name << "," << i - 1 <<
			") >> " << plot_name << i << ";\n" ;
		}
	}
	cout << net_name << ".GraphDisplay();\n" ;

}
