/*
 *  filedes.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <iostream.h>

#include "portable.h"
#include "arthtyp.h"

class PackageDesc ;
class OutTokens ;

class FileDesc {
public:
	const char * Name ;
	uint32 ArithFlags ;
	uint32 * Dependencies ;
	void SetFileDesc(const char * name) {Name=name; Dependencies = 0;
		ArithFlags=0;}
	const char * GetName() {return Name;}
	void SetDepend(uint32 * Dep) {Dependencies = Dep;}
	void SetDependencies(PackageDesc * pkg) ;
	uint32 * GetDepend() { return Dependencies ;}
	void GetDependencies(const char * DirName, PackageDesc *) ;
	void SetBit(int Bit) ;
	void WriteCDepen (ostream * MakeOut, PackageDesc * pkg,
		const char * dir) ;
	void WriteCDependant(OutTokens& TokOut, const char * Name) ;
	void CC_Out(int OutCC,ostream& MakeOut,const char * Sub,
		const char * ArithDir=0);
} ;

class HeaderFile:public FileDesc {
	const char * DirName ;
	const char * inc_dir_name;
	int DirIndex ;
	int inc_dir_index ;
	int HeaderWords ;
public:
	const char * GetName() {return Name;}
	Init(const char * name)
		{
			Name = name ;
			Dependencies = new uint32 [HeaderWords] ;
        	for (int i = 0 ; i < HeaderWords;i++) Dependencies[i] = 0 ;
		}
	HeaderFile (const char *file, const char *dir, int headerwords,
		int dirix):
		DirName(dir),
		inc_dir_name(0),
		DirIndex(dirix),
		inc_dir_index(dirix),
		HeaderWords(headerwords)	
		{Init(file);}
	HeaderFile(HeaderFile *f,int ix, const char * i_dir,int headerwords):
		DirName(f->GetDir()),
		inc_dir_name(i_dir),
		DirIndex(f->GetDirIndex()),
		inc_dir_index(ix),
		HeaderWords(headerwords)
		{Name=f->GetName();Dependencies=f->Dependencies;}
		
	const char * GetDir() {return DirName;}
	void Display();
	void SetBit(int Bit){FileDesc::SetBit(Bit);}
	int GetNoHeaderWords() {return HeaderWords; }
	uint32 * GetHeaderWords() {return Dependencies ; }
	void GetDependencies(PackageDesc * pkg)
		{FileDesc::GetDependencies(DirName,pkg) ; }
	int GetDirIndex() const { return DirIndex ; }
	int get_inc_dir_index() const {return inc_dir_index;}
	void set_inc_dir_name(const char * name) ;
	void set_inc_dir_index(int ix) {inc_dir_index = ix;}
	const char * inc_dir() const {return inc_dir_name;}
} ;

