/*
 *  basic.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// This file contains the base class on which
// all interactive accessible objects is based

#ifndef BASIC_DOT_H
#define BASIC_DOT_H

#include "ObjProDSP/arthtyp.h"
#include "ObjProGui/yachead.h"

#include "ObjProDSP/entenm.h"
class OutTokens ;
extern int UserState ;



class UserEntity {
public:
	enum TargetType {NormalTarget,DebugTarget};
	enum Flag {FlagClear=0, FlagCppListed = 1, FlagUnusedDefault = 2,
		FlagCppStateEmitted = 4, FlagCppTargetStateEmitted = 8,
		FlagDoNotDelete = 16} ;
private:
	TargetType TheTargetType ;
	ArithType::ArithCapabilities ObjArithType ;
	const char * Name ;
	ValueType ThisType ;
	Flag Flags ;
	int DoEmitState(OutTokens& Out) ;
	int DoEmitTargetState(OutTokens& Out) ;
protected:
	void DoSetTargetType(TargetType type) ;
	virtual void SetTargetType() {DoSetTargetType(NormalTarget);}
	void SetArithType(ArithType::ArithCapabilities type)
		{ObjArithType=type;}
	void SetArithType(ArithType::ArithTypes type)
		{ObjArithType=(ArithType::ArithCapabilities)type;}
	ArithType::ArithCapabilities GetEntityArithType() const
		{return ObjArithType;}
public:
	UserEntity (const char * Nm) ;
	virtual ~UserEntity();
	virtual void Describe(class OutTokens&, ListEntity) ;
	virtual int CheckSafeDelete() ;
	virtual int check_safe_delete(); // always called used for base class check
	int SaveState(OutTokens&, CppListCmds) ;
	virtual int CppList(OutTokens&, CppListCmds) ;
	virtual void Dump(OutTokens&,ValueTypeList * Lst) ;

	virtual const char * EmitTargetState(OutTokens&) ;
	virtual const char * EmitState(OutTokens&) ;
		// Must be called repeatedly until a null pointer is returned.
		// Values returned are names of entities that must have
		// their state emitted prior to the emition of this entity's
		// state.

	void SetClass(ValueType * Set) ;
	void SetUnusedDefault() {Flags = (Flag) (Flags | FlagUnusedDefault);}
	void SetDoNotDelete() ;
	ValueType * GetValue() {return &ThisType;} 
	IsDeleteable() {return !(Flags & FlagDoNotDelete);}
	int IsUnusedDefault() {return Flags & FlagUnusedDefault;}
	void ClearUnusedDefault() {Flags =(Flag) (Flags & ~FlagUnusedDefault);}
	const char * GetName() const ;
	int Delete();
	TargetType GetTargetType() const {return TheTargetType;}
	const char * GetClassName() const ;
	Flag GetFlags() const {return Flags;}
	InteractiveEntity * interactive_entity() const;
	virtual void parameter_changed() {}
};

UserEntity * MakeDeclaredEntity(UserEntity *,class InteractiveEntity *) ;
	// Call before adding an entity to any of the lists
	// of declared objects 

#endif /* #ifdef BASIC_DOT_H */
