/*
 *  help.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef HELP_DOT_H
#define HELP_DOT_H
/*  help.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

#include "ObjProDSP/helplev.h"
#include "ObjProGen/outtok.h"


class HelpControl {
	HelpLevel Level ;
	class TextWindow * TheHelpWindow ; // set by MakeOutToken
	class OutTokens * MakeOutToken(
		OutTokens::ReturnOption Opt = OutTokens::ReturnQuitOption) ;
public :
	HelpControl() {Level = HelpLevelAll;TheHelpWindow=0;}
	void EchoCommand(const char * Cmd) ;
	void ConfirmAction(const char * Confirmation, const char * a=0,
		const char * b=0, const char *c=0);
	void DescribeMenuAction(const char ** Description);
	void AutoDescribeMenuAction(const char ** Description);
	HelpLevel GetLevel() {return Level;}
	void SetHelpLevel(HelpLevel level); 
	void DisplayHelpFile(const char * FileName);
	void HelpServer(struct PacketHeader& Head, const char * Data); 
	int No() {return Level <= HelpLevelNone;}
	int Confirm() {return Level >= HelpLevelConfirm;}
	int All() {return Level >= HelpLevelAll;}
	int ConfirmVisible() ; // not defined for DSP
	int AllVisible() ; // not defined for DSP
	int AtLevel(HelpLevel level) {return Level >= level;}
	HelpLevel GetHelpLevel() {return Level;}
} ;

extern HelpControl HelpDo ;


#endif /* #ifdef HELP_DOT_H */
