/*
 *  textfrag.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TEXTFRAG_DOT_H
#define TEXTFRAG_DOT_H
#include "ObjProGen/slist.h"

class OutTokens ;

struct TextFragment {
	int Line ;
	const char * Text ;
	const char * TeXText ;
	const char * SpellText ;
	TextFragment(int line,const char * text) ;
	~TextFragment() ;
} ;

class TextFragmentList: public SingleList {
public:
	ErrCode Insert(TextFragment *nt) {return SingleList::Insert(nt);}
	ErrCode Append(TextFragment *nt) {return SingleList::Append(nt);}
	TextFragment * Get()   {return (TextFragment *) SingleList::Get();}
	TextFragment * Pop() {return (TextFragment *) SingleList::Pop();}
	TextFragment * GetNFromTop(int N) ;
	TextFragment * GetNthEntry(int N) ;
	TextFragmentList(){;}
	~TextFragmentList();
	int Size(){return SingleList::Size();}
	const char * OutTeX(OutTokens& Out) ;
	void OutTeXEndDot(OutTokens& Out);
} ;

class TextFragmentListIterator: public SingleListIterator {
public:
	TextFragmentListIterator(TextFragmentList& df):
		SingleListIterator((SingleList&) df){}
	TextFragment * operator()()
		{return (TextFragment *) Next();}
};


const char * ClearDoubleDollar(const char * text) ;


#endif /* #ifdef TEXTFRAG_DOT_H */
