/*
 *  gain.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GAIN_DOT_H
#define GAIN_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class Gain: public ProcessNodeStr {
	int32  NumberOfOverflows;
	double  Scale_1;
public:
	Gain (const char * Name, double Scale);
	virtual ~Gain();
	double GetScale() const {return Scale_1;}
	virtual int CheckSafeDelete() ;
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetScale(double  Scale) { Scale_1 = Scale; parameter_changed(); }
};

extern Gain * GainDef;


#endif /* #ifdef GAIN_DOT_H */
