/*
 *  txtfls.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include "txtenm.h"
#include "textdefs.h"

const ReadBufSize = 1024 ;

class TextFile {
friend class FileStatus ;
	FileStatus * CurrentFile ;
	int32 CurrentLine ;
		// index of first line in Window CurrentLines array
		// relative to file lines. (This can be negative
		// for inserts at the beginning of the file
	class TextWindow * TheWindow ;


	// Pointers and buffer used in reading file
	int BytesLeft ;
	char * BasePtr ; 
	char Buffer[ReadBufSize] ;
	
	// Following is window state information set by NewWindow
	int CharY ;
	int CharX ;

	// Used only for write when window is not visible
	int NextXCharacter ;
	char * LineBuf ;
	unsigned LineBufSize ;

	// Name used temporarily when saving to a disk file
	const char * SaveFileName ; 
	char * InitSaveFileName ; 

	double SampleRate ;	// used by text files that print data

	void UpdateFile(int CopyFile = 0) ;
	void UpdateLine(int32 LineIndex,char * Line) ;
	void ReadScrolledLines(int Number,int32 LineToRead); 
	int UpdateScrolledLines(int Number) ;
	void ReadLines(int32 LineToRead, char ** Destination,
		LineStateOptions *State, int NumberLines) ;
	int ReadLine(int32 LineToRead = -1) ;
	void ReadUpdatedLines(int LineToRead,char ** Lines,int Number) ;
	void Page(int Lines) ;
	void Init() ;
	void NewCheck() ;
public :
	TextFile(TextWindow * window) ;
	~TextFile() ;
	int ScrollLines(int Number);
		// Number is negative for scrolling up
		// This routine updates file and fills in new text
	void PageUp() ;
	void PageDown() ;
	void PageStart();
	int PageEnd();
	void NewWindow(TextWindow * Win) ;
	void RemoveWindow() ;
	int GetCurrentLine() { return CurrentLine;}
	TextWindowWrite Write(const char * str) ;
	TextWindowWrite Write(char ch) ;
	void DoSaveFile(const char * Name) ;
	void SaveFile() ;
	void DoSaveFileCompletion() ;
	void SaveAborted() ;
	void GoToAddress(double Address);
	int GetNumberLines();
	void DisplayAddress(const char * Name, int CursorLine);
	int GetCharY() {return CharY;}
	int IsEndOfFileInDisplay() ;
	void AppendTextEnd(const char * Str);
	void UpdateFileFromDisplay() ;
	double GetSampleRate();
	void SetSampleRate(double rate) {SampleRate = rate;}
	void NewSampleRate(double rate) {SetSampleRate(rate);}
	double GetCurrentAddress();
	double GetEndTime();
};

void DeleteTrailingSpaces(char * Str);

