/*
 *  iv_plot.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef IV_PLOT_DOT_H
#define IV_PLOT_DOT_H

#include "portable.h"
/*
 * Plot - simple graph glyph
 */


#include <InterViews/geometry.h>
#include <InterViews/glyph.h>
#include "iv_graph.h"

#include "rel_pos.h"

class Brush;
class Color;
class Plot ;
class PlotChan ;
class Canvas ;
class Allocation ;
class Requisition ;
class Extension;
class Hit ;

struct PlotChanElt {
    int32 max_size ;
    int32 limit ;
    int32 count ;
	int element ;
	RelativePosition * position ;
	const Color * color ;
	const Brush * brush ;
	PlotChan * plot_chan ;
	Plot * plot() const;

    void init(int element, PlotChan * plc);
    void clear();
    void draw_eye(RelativePosition * p =0);
    void draw_eye(int32 start);

    void draw(RelativePosition * p=0);
    void draw(int32 start);

    int32 new_points(RelativePosition *);
         // return index to start plotting
    void new_plot();
    void new_plot_size(double size);
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
    int x_scaling() const ;
    int y_scaling() const ;

    float x_scale(float x) const ;
    float y_scale(float y) const ;
	void reset();
	RelativePosition& get_sample(int sample);
	inline Graph * graph() const ;
};


struct PlotChan {
	int elements ;
	int channel ;
	PlotChanElt * plot_chan_elts ;
	Plot * plot ;
	
	void init(int chan, Plot * plot, int ele);
	void clear();
	void draw_eye(int elt, RelativePosition * p =0);
	void draw_eye(int elt, int32 start);

	void draw(int elt, RelativePosition * p=0);
	void draw(int elt, int32 start);

	int32 new_points(int elt, RelativePosition *);
		 // return index to start plotting
	void new_plot();
	void new_plot_size(double size);
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
	int x_scaling() const ;
	int y_scaling() const ;

	float x_scale(float x) const ;
	float y_scale(float y) const ;
	void reset();
	RelativePosition& get_sample(int elt, int sample);
	inline Graph * graph() const ;
};


class Plot : public Glyph {
	Coord last_height;
	Coord last_width;
public:
	double x_sum ;
    double y_sum ;
    int hit_count ;
    static const out_limit ;
    static const diff_limit ;
    Plot(Graph *gr);


    virtual void request (Requisition& r) const;
    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const ;
    virtual void draw_axis(Canvas*, const Allocation&) const ;
	void draw();
    virtual void pick(Canvas*, const Allocation&, int depth, Hit&);
private:
	Graph * the_graph ;
	int send_complete ;
	Canvas * last_canvas ;
	Allocation * last_allocation ;
public:
    void send_complete_after_draw(){send_complete=1;}
	void complete() {send_complete=0;}
	void mark(RelativePosition& pos);
	int new_sample_width();
	const Allocation * allocation() const {return last_allocation;}
	Canvas * canvas() const {return last_canvas;}
	void add_points(int chan, int elt, RelativePosition * pos);
	Graph * graph() const {return the_graph;}
	void reset();
	double sample_width() const ;
	void do_damage();
protected:
    virtual ~Plot();

	int channels ;

	PlotChan * the_channels ;
};

inline Graph * PlotChan::graph() const {return plot->graph();}
inline Graph * PlotChanElt::graph() const {return plot()->graph();}

#endif /* #ifdef IV_PLOT_DOT_H */
