/*
 *  elinlist.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "elinlist.h"
#include "linlist.h"
#include "debug.h"

LinearList::LinearList(const void ** init_list):
	objects(0),
	count(0),
	size(0),
	next_count(0)
{
	add(init_list);
}

LinearList::~LinearList()
{
	delete objects ;
}

void LinearList::Remove(long index)
{
	if (index < 0 || index >= count) DbgError("LinearList::Remove","bad index");
	for (long i = index ; i < count -1; i++) objects[i] = objects[i+1] ;
	objects[--count] = 0 ;
}

void LinearList::insert(long after, const void * obj)
{
	if (after < -1 || after >= count)
		DbgError("LinearList::Remove","bad index");
	add_check_size();
	for (long i = count ; i > after+1 ; i--) objects[i] = objects[i-1] ;
	objects[after+1] = obj ;
	count++;
}

void LinearList::clear(long lim)
{
	if (lim < 0 || size > lim) {
		count = size = 0 ;
		delete objects ;
		objects = 0 ;
	}
	count = size = 0 ;
}

void LinearList::replace(const void *obj, long index)
{
	objects[index] = obj ;
}

void LinearList::replace(const void *obj)
{
	// if (next_count >= count) DbgError("LinearList::replace","bad count");
	objects[next_count-1] = obj ;
}

void LinearList::add_check_size()
{
	if (size <= count) {
		long new_size = (long) (size *1.25) + 8;
		const void ** new_objs = new void *[new_size] ;
		for (long i = 0 ; i < count ; i++) new_objs[i] =  objects[i] ;
		size = new_size ;
		delete objects ;
		objects = new_objs ;
	}
}

void LinearList::add(void * obj)
{
	if (!obj) return ;
	add_check_size();
	objects[count++] = obj ;
}

void LinearList::add(void ** objs)
{
	if (!objs) return ;
	for (void ** x = objs;*objs;objs++) add(*x);
}

const void * LinearList::get(long index) const
{
	if (index >= count) return 0 ;
	return objects[index] ;
}

const void * LinearList::next(long init_index)
{
	if (init_index > -1) {
		next_count=init_index;
		return 0 ;
	}
	if (next_count < count) return get(next_count++);
	return 0 ;
}

Int_LinearList::Int_LinearList():
	objects(0),
	count(0),
	size(0),
	next_count(0)
{
}

Int_LinearList::~Int_LinearList()
{
	delete objects ;
}

void Int_LinearList::add(int obj)
{
	if (size <= count) {
		long new_size = (long) (size *1.25) + 8;
		int * new_objs = new int[new_size] ;
		for (long i = 0 ; i < count ; i++) new_objs[i] = objects[i] ;
		size = new_size ;
		delete objects ;
		objects = new_objs ;
	}
	objects[count++] = obj ;
}

int Int_LinearList::get(long index)const
{
	if (index >= count) return -1 ;
	return objects[index];
}


int Int_LinearList::next(long init_index)
{
	if (init_index > -1) {
		next_count=init_index;
		return -1 ;
	}
	if (next_count < count) return get(next_count++);
	return -1 ;
}

void Int_LinearList::clear(long lim)
{
	if (lim < 0 || size > lim) {
		count = size = 0 ;
		delete objects ;
		objects = 0 ;
	}
	count = size = 0 ;

}



