/*
 *  text2.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include "stdyac.h"
#include "textfrag.h"
#include "texutil.h"
#include "text.h"
#include "spellfil.h"
#include "cgidbg.h"

void EmbeddedTextOut(TextFragmentList * Text, ostream * Out,
	ConstStringList * EmittedOnce)
{
	TextFragmentListIterator Next(*Text);
	TextFragment * Fragment ;
	int LastLine = -1 ;
	while (Fragment = Next()) {
		const char * String = Fragment->Text ;
		if (IsWhiteSpace(String)) {
			// LogOut<<"White space at " << Fragment->Line << "\n";
			LastLine = -1 ;
			continue ;
		}
		int CheckLine = Fragment->Line ;
/*
 *		LogOut << "CheckLine = " << CheckLine << ", LastLine = " <<
 *			LastLine << "\n" ;
 *		LogOut << "`" << String << "'\n" ;
 */
		if (Fragment->Line < 0) {
			if (EmittedOnce) {
				int AlreadyEmitted = EmittedOnce->
					IsInList(String);
				if (!AlreadyEmitted) EmittedOnce->Append(String);
				EmitEmbeddedReference(String,AlreadyEmitted);
			}
			CheckLine = - CheckLine ;
			if (!EmittedOnce) if (CheckLine!= LastLine) LitQuoteOut(String,Out);
			else LitFillQuoteConcat(String,Out);
		} else {
			AddToSpellFile(Fragment->SpellText);
			// if (IsWhiteSpace(String)) continue ;
			if (CheckLine!= LastLine) LitFillOut(String,Out);
			else LitFillConcat(String,Out) ;
		}
		LastLine = CheckLine ;
	}
}

