/*
 *  guistate.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include "arthtyp.h"

class GuiCommandState {
	const char * ReadFileName ;
	const char * action_file_name ;
	int FileSetFlag ;
	int Interactive ;
	ArithType::ArithTypes the_arith_type ;
public:
	GuiCommandState();
	int SaveInit(const char * FileName = 0);
	void ActionInit(const char * name);
	const char * GetFileName();
	void ReadyForInitReadState(int ReturnId) ;
	int IsInteractive() const {return Interactive;}
	void SetInteractive() {Interactive=1;}
	void ClearInteractive() {Interactive=0;}
	ArithType::ArithTypes arith_type() const {return the_arith_type;}
	void set_arith_type(ArithType::ArithTypes typ) {the_arith_type=typ;}
	const char * action_file() const {return action_file_name;}
};

extern GuiCommandState State;
