/*
 *  dynmnug.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include "cgidbg.h"
#include "newaloc.h"
#include "shared.h"
#include "menu.h"
#include "dynmen.h"
#include "remdyn.h"
#include "dynmnu.h"
#include "mkstr.h"


// File for menus that are created dynamically
DynamicMenuServer TheDynamicMenuServer ;

void DynamicMenuServer::AddItem(MenuList * AddToThese, MenuItem * Item)
{
}


void DynamicMenuServer::RemoveItem(MenuList * RemoveFromThese,
	const char * CommandRemove) 
{
}


void DynamicMenuServer::MenuServer(class PacketHeader& Head,const char * Data)
{
	MenuServerCommand Command = (MenuServerCommand) Head.Identifier ;
	int Size = Head.DataSize ;
	// LogOut<<"In DynamicMenuServer::MenuServer, Size = " << Size << "\n" ;
	int EndNodeName = 0;
	for (int i = 0 ; i < Size ; i++) if (!Data[i]) {
		EndNodeName = i ;
		break ;
	}
	const char * ItemName = Data + EndNodeName + 1 ;
	if (!EndNodeName || Data[Size-1]) {
		TheLog << "EndNodeName = " << EndNodeName << "\n" ;
		TheLog << "Data[" << Size -1 << "] = " <<
			(int) Data[Size-1] << "\n" ;
		TheLog << "`" << Data << "'\n" ;
		if (EndNodeName) TheLog << "`" <<
			ItemName << "'\n" ;
		DbgError( "DynamicMenuServer::MenuServer","bad packet data");
	}
/*
 *	 LogOut << "Operating on `" << MenuName << "'  `" << ItemName
 *		<< "'\n" ;
 */
	char * Temp =  0 ;
	if (Command != MenuServerAttachOrphan)
		Data = Temp = Concatenate(Data,"InstancesMenu");
	DoCommand(Command,Data,ItemName);
	delete Temp ;
}

void DynamicMenuServer::DoCommand(MenuServerCommand Command,
	const char * MenuName, const char * ItemName)
{
	DynamicMenuInfo * Info ;
	int EndNodeName = strlen(ItemName);
	if (Command != MenuServerAttachOrphan) {
		for (Info = TheRemoteDynamicMenuTable;
			Info->TheMenu; Info++)
				if (!strcmp(Info->Name,MenuName)) break;
		if (!Info->TheMenu) {
			TheLog << "Looking for `" << MenuName << "'\n" ;
			DbgError("DynamicMenuServer::MenuServer",
				"no such Dynamic menu");
		}
	}

	switch(Command) {
case MenuServerNewMenuItem:
		{
			int NameSize = 1 + strlen(ItemName) ;
			char * NewName = Concatenate(ItemName);
			// LogMsg("NewMenuEntry:",NewName);
			// LogMsg("In Menu:", Info->TheMenu->GetHeader());

			MenuLine * NewLine = new MenuLine ;
			*NewLine = Info->Template ;
			NewLine->Command = NewName ;
			TheDynamicMenuController->AddMenuItem(Info->TheMenu,
				NewLine);
		}
		break ;
case MenuServerDeleteMenuItem:
		{
			int NameSize = 1 + strlen(ItemName) ;
			char * NewName = Concatenate(ItemName);
			// LogMsg("DeleteMenuEntry:",NewName);
			// LogMsg("In Menu:", Info->TheMenu->GetHeader());
			TheDynamicMenuController->DeleteMenuItem(Info->TheMenu,
				NewName);
		}
		break;
case MenuServerAttachOrphan:
		// LogOut << "MenuServerAttachOrphan\n" ;
		AttachOrphan(MenuName, ItemName);
		break ;
	}
}



