/*
 *  plotnd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProGui/remcom.h"
#include "ObjProComGui/plotdat.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/plotnd.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * PlotNodeNodeList = 0 ;
static InteractiveEntity * IntEntPlotNode ;
void PlotNodeNodesInit();
PlotNode::PlotNode (const char * Name, int16 In, StreamStr*StreamIn, int16 ScaleFlag, 
		TimingType TheTimingType):
	DisplayNodeStr(Name, In, 1,  new StreamStr(*StreamIn), TheTimingType)
,
	In_1(In),
	StreamIn_2(StreamIn),
	ScaleFlag_3(ScaleFlag),
	TheTimingType_4(TheTimingType)
{
#line 55 "../plotnd.usr"
 
	SetupState = RemoteSetupClear ;
	PlotId = 0 ;
	DataBufPtrs = 0 ;
	X_DataBufPtrs = 0 ;
	NextWordInBuf =  0 ;
	Channels = GetIn();
	if (ComSetup) RemoteSetup(RemoteSetupIdReq);
	HeaderComplete = 0;
	PlotDesc = 0;
	ChannelScale = 0;
	PrescaleFlag = GetScaleFlag();
#line 49 "../plotnd.C"
} // end constructor

PlotNode::~PlotNode()
{
#line 69 "../plotnd.usr"
 
	int i ;
	if (DataBufPtrs) for (i = 0 ; i < Channels ; i++) delete DataBufPtrs[i];
	delete DataBufPtrs ;
	if (X_DataBufPtrs) for (i = 0 ; i < Channels ; i++)
		delete X_DataBufPtrs[i];
	delete X_DataBufPtrs ;
	delete PlotDesc ;
	delete NextWordInBuf ;
#line 64 "../plotnd.C"
} // end destructor

int PlotNode::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

void PlotNodeNodesInit()
{
	if (PlotNodeNodeList)  return ;
	PlotNodeNodeList = new EntityList;
	IntEntPlotNode = new InteractiveEntity("PlotNode", PlotNodeNodeList,
		0, InteractiveNode, "plotnd.h",
		0, "DisplayNodeStr");
	TheNodes->Append(IntEntPlotNode);
} // end initalization

static InitObj LocalInit(PlotNodeNodesInit, "PlotNode", "DisplayNodeStr");

