/*
 *  truncb.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProUsr/trunc.h"
#include "ObjProComGui/cgidbg.h"

void Truncate::parameter_changed()
{
	int accuracy = GetAccuracy();
	if (accuracy > GetRange()) accuracy = GetRange();
	mask = 0x7fffffff ;
    int_over_max = mask ;
    mask >>= (31-accuracy);
    // LogOut << (void *) mask << " A\n" ;
    mask <<= (31-accuracy);
    // LogOut << (void *) mask << " B\n" ;

    mask >>= (31 - GetRange());
    // LogOut << (void *) mask << " C\n" ;

    const double over_max_32 =  0x7fffffff ;
    over_max = over_max_32 ;
    if (over_max > MachWord::max_positive) over_max = MachWord::max_positive ;
    if (over_max > mask) over_max = mask ;
    over_min = -over_max ;
/*
 *	LogOut << "over_max = " << over_max << ", over_min = " << over_min
 *       << "\n" ;
 */


	round_offset = 0 ;
	if (GetRound()) round_offset = .5 * (1 << (GetRange() - accuracy)) ;
}
