/*
 *  blockinit.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProUsr/block.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSPint/netlnk.h"

#include "fndtail.h"
#include "trunc.h"

int Truncate::InitAfterLinked()
{
    return set_read_binary_flag(binary_read_flag) ;
}


int FindStartTail::InitAfterLinked()
{
    return set_read_binary_flag(binary_read_flag) ;
}


void Block::static_ctor()
{
	the_convert_type = 0 ;
}

void Block::input_linked(int chan)
{
	// force IncrementIn and IncrementOut to be the reciprocal of
	// the relationship between the input and output chunk size
	// see we write one output for each input
	// LogOut << "Block::input_linked enter\n" ;
	if (chan != 0) DbgError("Block:input_linked","one channel only");
	int32 in_chunk=GetInStream()->GetChunkSize();
	int32 out_chunk=GetOutStream()->GetChunkSize();
	GetInLink()->set_increment_in(out_chunk);
	GetOutLink()->set_increment_out(in_chunk) ;
	// LogOut << "Block::input_linked exit\n" ;
	
}

int Block::InitAfterLinked()
{
	// LogOut << "Block::InitAfterLink for `" << GetName() << "'\n" ;
	StreamStr * in = 0 ;
	DfNode * driver = GetDriverNode();
	if (driver) in = driver->GetOutStream();
	if (!in) return 0 ;
	ArithType::ArithCapabilities arith_in = in->GetArithType();
	switch(arith_in) {
case ArithType::ArithInt32:
case ArithType::ArithFloat:
		switch (GetOutputArithmetic()) {
	case 0:
			if (TheArithType == arith_in) the_convert_type =
				no_conversion ;
			else if (arith_in == ArithType::ArithInt32)
				the_convert_type = int_to_float ;
			else the_convert_type = float_to_int ;
			break ;
	case 1:
			if (arith_in == ArithType::ArithInt32)
				the_convert_type = no_conversion ;
			else the_convert_type = float_to_int ;
			break ;
	case 2:
			if (arith_in == ArithType::ArithFloat)
				the_convert_type = no_conversion ;
			else the_convert_type = int_to_float ;
			break ;
		}
		break ;
case ArithType::ArithInt16:
		if (!GetOutputArithmetic()) {
			the_convert_type = no_conversion ;
			break ;
		}
	}
	return 1 ;
}

