/*
 *  topol.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TOPOL_DOT_H
#define TOPOL_DOT_H
/*  topol.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// This file contains the classes for defining process topology
// with nodes that fit the uniform data flow process model.

#include <string.h>
#include "portable.h"

class SourceData {
	int32 BytesPerSample ;
		// Size of a data sample
	char * SignalName ;  // ascii name of signal generator
	virtual void GenData (int32 Samples, void * Destination) ;
		// Vitual function to write `Samples' samples of data
		// at location `Destination'
public:
	SourceData (int32 bps, char * name)
	{
		BytesPerSample = bps ;
		SignalName = new char[strlen(name)+1];
		strcpy(SignalName,name);
	}
	const char * GetName() {return SignalName ;}
} ;

class UnFlowNet {
	class DfNdIn * NetInputs ;
	class DfNdOut * NetOutputs ;

} ;
#endif /* #ifdef TOPOL_DOT_H */
