/*
 *  replc.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef REPLC_DOT_H
#define REPLC_DOT_H

#include "errcode.h"

class DfNode ;
class ProcessNet ;

struct ReplaceNodeLinks {
	struct ReplaceOutBufferLink {DfNode * node; int channel_in;} ;
	struct ReplaceInLink {DfNode * node; int channel_from; } * inputs ;
	struct ReplaceOutLink
		{int size; ReplaceOutBufferLink * buf_links; int channel_from; }
		* outputs ;
	DfNode& node ;
	int in ;
	int out ;
	ReplaceNodeLinks(DfNode& node);
	~ReplaceNodeLinks();
	ErrCode LinkNewNode(ProcessNet &Net, DfNode &);
};
	
	
#endif /* #ifdef REPLC_DOT_H */
