/*
 *  interp.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
//	This contains the data structures for the run time
//	C++ interpreter

#ifndef INTERP_DOT_H
#define INTERP_DOT_H

#ifndef OVERFLOW
#include <complex.h>
#endif

#include "portable.h"
#include "slist.h"
#include "entenm.h"
#include "arthtyp.h"

//#include "dfnode.h"

#include "basic.h"
//#include "yachead.h"
//#include "network.h"
//#include "buffer.h"

class CmpdNode ;
class OutTokens ;



ValueType * GetTypeFromObj(ValueType * ) ;
InteractiveEntity * GetIntEntFromObj(ValueType * Obj) ;

int IsAllocationNeeded(DecType Type) ;
int IsComplex(DecType Type) ;
int IsFloat(DecType Type) ;
int IsNumeric(DecType Type) ;
int IsBuiltInClass(DecType Type);
int IsMachWordType(DecType Type) ;
int IsAccWordType(DecType Type) ;

class complex ConvertToComplex (const ValueType& Val) ;
class complex ConvertToComplex (DecType, const DataValue& Val) ;
class complex ConvertToComplex (DecType Type, const *, int index) ;

double ConvertToDouble (const class ValueType& Val) ;
double ConvertToDouble (DecType, const DataValue& Val) ;
double ConvertToDouble (DecType Type, const void *, int index) ;

inline double ConvertToDouble(const ValueType & Val, int Index)
{
	return ConvertToDouble(Val.Type,Val.Value.ValBuiltInClass,Index);
}

inline double ConvertToDouble(DecType Type, const void * Value)
{
	return ConvertToDouble(Type,Value,0);
}

const char * ConvertToString(DecType Type, const DataValue& Data) ;
const char * ConvertToString(ValueType& Val);
const char * ConvertToString(DecType type, const void *,int Index);
const char * ConvertToString(DecType Type, const void * Data,int Index,
	CppListCmds Cmd) ;
const char * ConvertToString(const double& val);

void * GetNthValue(DecType Type, void * Array, int Index) ;

void * DeclareObjectArray(DecType Type,int Size) ;
ArithType::ArithTypes DecTypeToArithType(DecType type) ;
// The above should be removed and all MachWord types external to nodes
// should be eliminated.

inline int is_floating_point_simulator()
{
	return TheArithType == ArithType::ArithFloat ||
	TheArithType == ArithType::ArithDouble  ;
}

#endif /* #ifdef INTERP_DOT_H */
