/*
 *  hrdarth.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <float.h>
#include "tmpglob.h"
#include "yacintfc.h"
#ifdef INTERACTIVE
#include "dspe_app.h"
#include "cgidbg.h"
#endif

const char * ArithTypeName = "float" ;
const char * ArithFormat = "%16.9e" ;
const char * ArithBinaryFormat = "0x%08x" ;

const float MachWord::max_positive = FLT_MAX ; ;
const float MachWord::min_negative = -FLT_MAX ;
const int32 MachWord::max_int_positive =  0x7fffffff ;
const int32 MachWord::min_int_negative =  0x80000000 ;
const uint32 MachWord::max_unsigned_int = 0x80000000 ;

const double AccMachWord::max_positive = DBL_MAX ;
const double AccMachWord::min_negative = -DBL_MAX ;



AccMachWord check_overflow_acc(double test_val,int32& number_overflows)
{
	return test_val ;
}

MachWord check_overflow(double test_val,int32& number_overflows)
{
    number_overflows += ArithCheckOverflow(test_val);
	return test_val ;
}


CxAccMachWord::operator complex() const
{
	return complex(Real,Imag);
}

CxMachWord::operator complex() const
{
	return complex(rl,ig);
}

CxMachWord::CxMachWord(MachWord r, MachWord i)
{
	rl =r ;
	ig = i;
}

CxMachWord::CxMachWord(MachWord r)
{
	rl = r;
	ig = (float) 0;
}

CxMachWord::CxMachWord(float r,float i)
{
	rl=MachWord(r);
	ig=MachWord(i);
}


CxMachWord::CxMachWord(const CxMachWord& x)
{
	rl = MachReal(x);
	ig = MachImag(x);
}

CxMachWord::CxMachWord(const complex& cx)
{
	rl =real(cx);
	ig =imag(cx);
}

CxAccMachWord::CxAccMachWord(float r,float i)
{
	Real=r;
	Imag=i;
}

CxAccMachWord::CxAccMachWord(const CxMachWord& W)
{
	Real = MachReal(W) ;
	Imag = MachImag(W);
}

CxAccMachWord::CxAccMachWord(const CxAccMachWord& W)
{
	Real = MachReal(W) ;
	Imag = MachImag(W);
}

CxAccMachWord::CxAccMachWord(AccMachWord R, AccMachWord I)
{
	Real = R ;
	Imag = I ;
}

CxAccMachWord::CxAccMachWord(MachWord R,MachWord I)
{
	Real = R ;
	Imag = I ;
}

MachWord::MachWord(double v)
{
	int warn = 0 ;
	if (v < 0) {
        if (v < MachWord::min_negative) v = MachWord::min_negative,warn=1 ;
    } else {
        if (v > MachWord::max_positive) v = MachWord::max_positive,warn=1 ;
    }
    if (warn) hard_limit_warn();
	value = v;
}

MachWord AccScale(AccMachWord word, int )
{
	float x = word ;
	return x ;
}

CxMachWord AccScale(CxAccMachWord word, int )
{
	return AccScale(word);
}

CxMachWord AccScale(CxAccMachWord word)
{
	float x = MachReal(word);
	float y = MachImag(word);
	return CxMachWord(x,y);
}

MachWord FullScale(double Val, int )
{
	return Val ;
}

CxMachWord FullScale(complex Val)
{
	float x = real(Val) ;
	float y = imag(Val) ;
	return CxMachWord(x,y);
}

CxMachWord FullScale(complex Val, int )
{
	return FullScale(Val);
}

void Normalize(MachWord * , int32 , enum NormalizeOption )
{
}

void Normalize(CxMachWord * , int32 , NormalizeOption )
{
}


CxMachWord RoundDouble(complex Val)
{
	return CxMachWord(RoundDouble(real(Val)),RoundDouble(imag(Val)));
}

MachWord RoundDouble(double Val)
{
	float v = Val ;
	return v ;
}



MachWord FullScale(double Val)
{
	float v = Val ;
	return v ;
}


double NormFromMachWord(double val) {return val ;}

double NormFromAccMachWord(double val) {return val;}

