#!/bin/sh
#  latex_ix.sh from ObjectProDSP 0.1
#  Copyright (C) 1994, Mountain Math Software, All rights reserved.
#  Licensed for free use and distribution under version 2 of the Gnu General
#  Public License. Please see file COPYING for details and restrictions.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
. $OPD_ROOT/doc/mac/set_tex_env
OPD_DEST=${1%%.dvi}
echo latex_ix $OPD_DEST
if [ ! -e $OPD_DEST.toc ] ;then touch $OPD_DEST.toc ;fi
if [ ! -e $OPD_DEST.idx ] ;then touch $OPD_DEST.idx ;fi
if [ ! -e $OPD_DEST.txx ] ;then touch $OPD_DEST.txx ;fi 
if [ ! -e old_$OPD_DEST.txx ] ;then touch old_$OPD_DEST.txx ;fi 
cp $OPD_DEST.toc old_$OPD_DEST.toc
cp $OPD_DEST.idx old_$OPD_DEST.idx
latex $OPD_DEST 
${OPD_ROOT}/bin/hyphen < $OPD_DEST.toc > $OPD_DEST.toc-
mv $OPD_DEST.toc- $OPD_DEST.toc
$OPD_ROOT/doc/scripts/check_index.sh $OPD_DEST
if ! cmp $OPD_DEST.idx old_$OPD_DEST.idx ;then \
	echo Index for $OPD_DEST needs updating. ; \
	if [ -e $1 ] ;then rm $1 ;fi
	make $OPD_DEST.idx ; \
fi
if ! cmp $OPD_DEST.txx old_$OPD_DEST.txx ;then \
	echo Index for $OPD_DEST needs updating. ; \
	if [ -e $1 ] ;then rm $1; fi
fi
if [ -n "$OPD_PATCH_TOC" ] ;then $OPD_PATCH_TOC $OPD_DEST ;fi
if ! cmp $OPD_DEST.toc old_$OPD_DEST.toc ;then \
	echo Table of contents for $OPD_DEST needs updating. ; \
	if [ -e $1 ] ;then rm $1 ;fi
fi
if fgrep -l "LaTeX Warning: Label(s) may have changed." $OPD_DEST.log ;then \
	echo Labels for $OPD_DEST needs updating. ; \
	if [ -e $1 ] ;then rm $1 ;fi
fi
make $1
