/*
 *  dlist.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DLIST_DOT_H
#define DLIST_DOT_H
/*  dlist.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
// This file defines the base classes for doubly linked lists. 
// It is generalized from Stroustrup's C++ Book. pp. 203 
#include "ObjProGen/slist.h"

class DoubleLink {
friend class DoubleList ;
friend class DoubleListIterator ;
	DoubleLink * Previous;
	DoubleLink * Next;
	Entity Entry ;
	DoubleLink(Entity e, DoubleLink * p,DoubleLink * n)
		{Entry=e; Next=n; Previous=p;}
	void Dump() const ;
} ;
 
class DoubleList {
friend class DoubleListIterator ;
	DoubleLink * Last ;
	void LinkDump() const ;
public:
	ErrCode Insert(Entity a) ;	// Add at head of list
	ErrCode Append(Entity a) ;  // Add at end of list
	Entity Get() ;		// Return and remove head of list
	Entity Pop() ;		// Return and remove tail of list
	void Clear() ;		// Remove all links
	Entity GetLast() {if(!Last) return (Entity) Last;
		else return Last->Entry;}
	Entity GetFirst() {if(!Last) return (Entity) Last;
		else return Last->Next->Entry;}

	DoubleList()         {Last = 0; }
	~DoubleList()	     {Clear(); }
	int Size() ;
	ErrCode RemoveEntry(Entity a) ;
} ;

class DoubleListIterator {
friend class DoubleList ;
	DoubleLink * CurrentEntry ;
	DoubleList * CurrentList ;
public:
	DoubleListIterator(DoubleList& Slist) {CurrentList = &Slist ;
						CurrentEntry = 0;}
	Entity Next() ;
	Entity Previous() ;
} ;

#endif /* #ifdef DLIST_DOT_H */
