/*
 *  dirfil.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DIRFIL_DOT_H
#define DIRFIL_DOT_H
/*  dirfil.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */

// MAXNAMLEN is defined to be maximum file name length in <dirent.h>.

class ExamineDirectory {
	const char * Directory ;
	const char * Suffix ;
	const char * Base ;
	int BaseLength ;
	
	char ** DirNames ;

	int NextDir ;

	int Ndirs ;
	void SortDir();
	void SetDirContents(int Number) ;
	void SetName(int Index, const char * FileName) ;
	int ValidFile(const char * name) ;
	int FindFiles(const char * DirName) ;
	int ClearName(const char * NameToClear, int NumVers) ;
	int UnLink(const char * ToUnLink) ;
public:
	ExamineDirectory(const char * d, const char * s=0, const char *b=0);
	~ExamineDirectory();
	const char * NextFile();
	const char * IsVersionFile(const char * Name) ;
	char * GetVersionFile();
	int MoveFile(const char * OldName,const char * NewName) ; 
	int NewVersion(const char * TempName,int LastVersion) ;
	int GetNumberFiles();
	const char * directory() const {return Directory;}
};

#endif /* #ifdef DIRFIL_DOT_H */
