/*
 *  copyright.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <sys/types.h>
#include "slist.h"
class istream ;
class ostream ;

struct FileType {
    const char * suffix ;
    enum comment_type {end_of_types=0,bracketed,per_line,no_notice} type ;
    const char * comment_start ;
    const char * prefix ; // suffix takes priority
    const char * comment_end ;
    const char * comment_middle ;
	int remove_old ;
	const char * first_line ;
    int length ;
	int has_suffix(const char * file_name);
	int has_prefix(const char * file_name);
	// returns number of lines written or -1 on error
	static const char * const termination_line ;
	int write(ostream& out, const char ** lines);

	void check_start();
	int is_first_line(const char * line);
	int may_be_comment(const char * line);
	int may_be_comment_start(const char * line);
	int may_be_comment_middle(const char * line);
	int may_be_comment_end(const char * line);
	int may_be_comment_terminate(const char * line);
	void init();
};


class AddCopyright {
	friend class AddCopyrightFile ;
	static FileType file_type[] ;
	static FileType no_notice[] ;
	const char ** const mountain_math ;
	const char ** const mountain_math_short ;
	const char ** const user ;
	const char ** temp_lines ;
	char ** const file_lines ;
	int next_file_line ;
	char * const line_buffer ;
	int the_length ;
	int the_short_length ;
	int the_user_length ;
	FileType * type(const char * file_name, FileType ty[]);
	ConstStringList not_found ;
	int write_error();
	int read_error();
	void build_temp_lines(const char ** mm, int user_flag=0) ;
	int write_base(ostream& out, const char * path_name, const char * fr=0) ;
	int read_line(istream& in);
	const char * next_line(int index, istream& in);
public:
	AddCopyright(const char ** mm, const char ** mm_s, const char **u);
	static const int byte_boundary ;
	static AddCopyright& add_copyright();
	
	// following 4 routines return number of lines wriiten or -1 if
	// an error was encountered
	int write(ostream & out,const char * path_name, int user_flag =0,
		const char * fr =0);
	int write_short(ostream & out,const char * path_name, int user_flag=0,
		const char * fr =0);
	int may_be_comment( const char * line, const char * path_name);
	int is_not_notice_type(const char * path_name);
	FileType * type(const char * file_name);
	static const char * const created_by ;
	static int default_user_flag ; // set this if you wat user notices
								   // on code generated by MakeTarget
	static const max_file_lines ;
	static const max_line_length ;
	static const char * plot_file_prologue ;
};


