#!/bin/sh
#  gen_test.sh from ObjectProDSP 0.1
#  Copyright (C) 1994, Mountain Math Software, All rights reserved.
#  Licensed for free use and distribution under version 2 of the Gnu General
#  Public License. Please see file COPYING for details and restrictions.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
# build shell scripts to create and execute tests in subidirecrories of
# of existing directory
function err() {
	echo "Error $1 in \`gen_test.sh'."
	echo "Error $1 in \`gen_test.sh'."  >> $OPD_TESTS
	exit 1
}

function make_interactive_node_test() {
	OPD_MASTER_SH=interactive_node_master_$1$OPD_TEST_TYPE_SUF.sh
	OPD_DATA=$OPD_ROOT/validate/test_data
	if ! echo "#!/bin/sh" > $OPD_MASTER_SH ;then err 1 ;fi
	find . -name $1'*.dpp' $OPD_NEWER_TESTS | sort > $OPD_DATA/temp_list
	( while read OPD_SCRIPT ;do $OPD_ROOT/scripts/create_interactive_node_test.sh $OPD_SCRIPT $OPD_TESTS \
        $OPD_TEST_TYPE ;done )  >> $OPD_MASTER_SH  < $OPD_DATA/temp_list 

	if ! chmod a+x $OPD_MASTER_SH ;then err 2 ;fi
	if ! echo "Created \``pwd`/$OPD_MASTER_SH." >> $OPD_TESTS ;then err 3 ;fi
	echo "Created \``pwd`/$OPD_MASTER_SH'." 
}

function make_target_test() {
	OPD_DATA=$OPD_ROOT/validate/test_data
	OPD_MASTER_SH=target_master_$1$OPD_TEST_TYPE_SUF.sh
	if ! echo "#!/bin/sh" > $OPD_MASTER_SH ;then err 4 ;fi
	find . -name $1.sh $OPD_NEWER_TESTS | sort > $OPD_DATA/temp_list
	( while read OPD_SCRIPT ;do $OPD_ROOT/scripts/create_target_test.sh $OPD_SCRIPT $OPD_TESTS \
        $OPD_TEST_TYPE ;done )  >> $OPD_MASTER_SH  < $OPD_DATA/temp_list

	if ! chmod a+x $OPD_MASTER_SH ;then err 5 ;fi
	if ! echo "Created \``pwd`/$OPD_MASTER_SH." >> $OPD_TESTS ;then err 6 ;fi
	echo "Created \``pwd`/$OPD_MASTER_SH'." 
}

OPD_TESTS=$1
OPD_TEST_TYPE=$2
OPD_TEST_TYPE_SUF=
if [ -n "$OPD_TEST_TYPE" ] ;then OPD_TEST_TYPE_SUF=_$OPD_TEST_TYPE ;fi

if [ -n "$OPD_MASTER_CREATE" ] ;then 
	if ! make_interactive_node_test ValCreate ;then err 7 ;fi
	if ! make_target_test create ;then err 9 ;fi
fi

if ! make_interactive_node_test ValCompare ;then err 8 ;fi
if ! make_target_test compare ;then err 10 ;fi



