# Contributing

## Overview

This repository is maintained by the [DMTF](https://www.dmtf.org/ "https://www.dmtf.org/").  All contributions are reviewed and approved by members of the organization.

## Submitting Issues

Bugs, feature requests, and questions are all submitted in the "Issues" section for the project.  DMTF members are responsible for triaging and addressing issues.

## Contribution Process

1. Fork the repository.
2. Make and commit changes.
3. Make a pull request.

All contributions must adhere to the BSD 3-Clause License described in the LICENSE.md file, and the [Developer Certificate of Origin](#developer-certificate-of-origin).

Pull requests are reviewed and approved by DMTF members.

## Developer Certificate of Origin

All contributions must adhere to the [Developer Certificate of Origin (DCO)](http://developercertificate.org "http://developercertificate.org").

The DCO is an attestation attached to every contribution made by every developer.  In the commit message of the contribution, the developer adds a "Signed-off-by" statement and thereby agrees to the DCO.  This can be added by using the `--signoff` parameter with `git commit`.

Full text of the DCO:

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```
