
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BRepAlgo_AsDes.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <BRepOffset_Inter3d.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Geom_BezierCurve.hxx>
#include <Geom_BSplineCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Edge.hxx>
#include <TopoDS_Vertex.hxx>
#include <Geom_BezierCurve.hxx>
#include <Geom_BSplineCurve.hxx>

// module includes
#include <BiTgte_Blend.hxx>
#include <BiTgte_ContactType.hxx>
#include <BiTgte_CurveOnEdge.hxx>
#include <BiTgte_CurveOnVertex.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BiTgte_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BiTgte", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<BiTgte_ContactType>(m, "BiTgte_ContactType",R"#()#")
        .value("BiTgte_FaceFace",BiTgte_ContactType::BiTgte_FaceFace)
        .value("BiTgte_FaceEdge",BiTgte_ContactType::BiTgte_FaceEdge)
        .value("BiTgte_FaceVertex",BiTgte_ContactType::BiTgte_FaceVertex)
        .value("BiTgte_EdgeEdge",BiTgte_ContactType::BiTgte_EdgeEdge)
        .value("BiTgte_EdgeVertex",BiTgte_ContactType::BiTgte_EdgeVertex)
        .value("BiTgte_VertexVertex",BiTgte_ContactType::BiTgte_VertexVertex).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BiTgte_Blend , shared_ptr<BiTgte_Blend>  >(m,"BiTgte_Blend",R"#(Root class)#");
    py::class_<BiTgte_CurveOnEdge ,opencascade::handle<BiTgte_CurveOnEdge>  , Adaptor3d_Curve >(m,"BiTgte_CurveOnEdge",R"#(private class used to create a filler rolling on an edge.private class used to create a filler rolling on an edge.)#");
    py::class_<BiTgte_CurveOnVertex ,opencascade::handle<BiTgte_CurveOnVertex>  , Adaptor3d_Curve >(m,"BiTgte_CurveOnVertex",R"#(private class used to create a filler rolling on an edge.private class used to create a filler rolling on an edge.)#");

};

// user-defined post-inclusion per module

// user-defined post
