# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhci import AzureStackHCIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIArcSettingsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_cluster(self, resource_group):
        response = self.client.arc_settings.list_by_cluster(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.arc_settings.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create(self, resource_group):
        response = self.client.arc_settings.create(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            arc_setting={
                "aggregateState": "str",
                "arcApplicationClientId": "str",
                "arcApplicationObjectId": "str",
                "arcApplicationTenantId": "str",
                "arcInstanceResourceGroup": "str",
                "arcServicePrincipalObjectId": "str",
                "connectivityProperties": {},
                "defaultExtensions": [{"category": "str", "consentTime": "2020-02-20 00:00:00"}],
                "id": "str",
                "name": "str",
                "perNodeDetails": [
                    {"arcInstance": "str", "arcNodeServicePrincipalObjectId": "str", "name": "str", "state": "str"}
                ],
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.arc_settings.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            arc_setting={"connectivityProperties": {}, "tags": {"str": "str"}},
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.arc_settings.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_generate_password(self, resource_group):
        response = self.client.arc_settings.generate_password(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_identity(self, resource_group):
        response = self.client.arc_settings.begin_create_identity(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_consent_and_install_default_extensions(self, resource_group):
        response = self.client.arc_settings.consent_and_install_default_extensions(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_initialize_disable_process(self, resource_group):
        response = self.client.arc_settings.begin_initialize_disable_process(
            resource_group_name=resource_group.name,
            cluster_name="str",
            arc_setting_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
