/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/lda_exc/lda_c_epc18.mpl
  Type of functional: lda_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t13, t14, t17, t18, tzk0;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t8 = t7 * t7;
  t9 = t8 * rho[0];
  t10 = params->b * t7;
  t13 = params->c * t8;
  t14 = rho[0] * rho[0];
  t17 = -0.4e1 * t10 * rho[0] + 0.16e2 * t13 * t14 + params->a;
  t18 = 0.1e1 / t17;
  tzk0 = my_piecewise3(t2, 0, -t9 * t18 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t13, t14, t17, t18, tzk0;

  double t22, t23, t27, t32, tvrho0;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t8 = t7 * t7;
  t9 = t8 * rho[0];
  t10 = params->b * t7;
  t13 = params->c * t8;
  t14 = rho[0] * rho[0];
  t17 = -0.4e1 * t10 * rho[0] + 0.16e2 * t13 * t14 + params->a;
  t18 = 0.1e1 / t17;
  tzk0 = my_piecewise3(t2, 0, -t9 * t18 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t22 = t17 * t17;
  t23 = 0.1e1 / t22;
  t27 = 0.32e2 * t13 * rho[0] - 0.4e1 * t10;
  t32 = my_piecewise3(t2, 0, t9 * t23 * t27 / 0.4e1 - t8 * t18 / 0.4e1);
  tvrho0 = rho[0] * t32 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t13, t14, t17, t18, tzk0;

  double t22, t23, t27, t32, tvrho0;

  double t39, t40, t44, t45, t50, tv2rho20;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t8 = t7 * t7;
  t9 = t8 * rho[0];
  t10 = params->b * t7;
  t13 = params->c * t8;
  t14 = rho[0] * rho[0];
  t17 = -0.4e1 * t10 * rho[0] + 0.16e2 * t13 * t14 + params->a;
  t18 = 0.1e1 / t17;
  tzk0 = my_piecewise3(t2, 0, -t9 * t18 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t22 = t17 * t17;
  t23 = 0.1e1 / t22;
  t27 = 0.32e2 * t13 * rho[0] - 0.4e1 * t10;
  t32 = my_piecewise3(t2, 0, t9 * t23 * t27 / 0.4e1 - t8 * t18 / 0.4e1);
  tvrho0 = rho[0] * t32 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t39 = 0.1e1 / t22 / t17;
  t40 = t27 * t27;
  t44 = t8 * t8;
  t45 = t44 * rho[0];
  t50 = my_piecewise3(t2, 0, t8 * t23 * t27 / 0.2e1 - t9 * t39 * t40 / 0.2e1 + 0.8e1 * t45 * t23 * params->c);
  tv2rho20 = rho[0] * t50 + 0.2e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t13, t14, t17, t18, tzk0;

  double t22, t23, t27, t32, tvrho0;

  double t39, t40, t44, t45, t50, tv2rho20;

  double t59, t60, t61, t70, tv3rho30;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t8 = t7 * t7;
  t9 = t8 * rho[0];
  t10 = params->b * t7;
  t13 = params->c * t8;
  t14 = rho[0] * rho[0];
  t17 = -0.4e1 * t10 * rho[0] + 0.16e2 * t13 * t14 + params->a;
  t18 = 0.1e1 / t17;
  tzk0 = my_piecewise3(t2, 0, -t9 * t18 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t22 = t17 * t17;
  t23 = 0.1e1 / t22;
  t27 = 0.32e2 * t13 * rho[0] - 0.4e1 * t10;
  t32 = my_piecewise3(t2, 0, t9 * t23 * t27 / 0.4e1 - t8 * t18 / 0.4e1);
  tvrho0 = rho[0] * t32 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t39 = 0.1e1 / t22 / t17;
  t40 = t27 * t27;
  t44 = t8 * t8;
  t45 = t44 * rho[0];
  t50 = my_piecewise3(t2, 0, t8 * t23 * t27 / 0.2e1 - t9 * t39 * t40 / 0.2e1 + 0.8e1 * t45 * t23 * params->c);
  tv2rho20 = rho[0] * t50 + 0.2e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t61 = t40 * t27;
  t70 = my_piecewise3(t2, 0, -0.3e1 / 0.2e1 * t8 * t39 * t40 + 0.24e2 * t44 * t23 * params->c + 0.3e1 / 0.2e1 * t9 * t60 * t61 - 0.48e2 * t45 * t39 * t27 * params->c);
  tv3rho30 = rho[0] * t70 + 0.3e1 * t50;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t9, t10;
  double t13, t14, t17, t18, tzk0;

  double t22, t23, t27, t32, tvrho0;

  double t39, t40, t44, t45, t50, tv2rho20;

  double t59, t60, t61, t70, tv3rho30;

  double t82, t92, t97, tv4rho40;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = 0.1e1 <= p->zeta_threshold;
  t4 = p->zeta_threshold - 0.1e1;
  t6 = my_piecewise5(t3, t4, t3, -t4, 0);
  t7 = 0.1e1 + t6;
  t8 = t7 * t7;
  t9 = t8 * rho[0];
  t10 = params->b * t7;
  t13 = params->c * t8;
  t14 = rho[0] * rho[0];
  t17 = -0.4e1 * t10 * rho[0] + 0.16e2 * t13 * t14 + params->a;
  t18 = 0.1e1 / t17;
  tzk0 = my_piecewise3(t2, 0, -t9 * t18 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t22 = t17 * t17;
  t23 = 0.1e1 / t22;
  t27 = 0.32e2 * t13 * rho[0] - 0.4e1 * t10;
  t32 = my_piecewise3(t2, 0, t9 * t23 * t27 / 0.4e1 - t8 * t18 / 0.4e1);
  tvrho0 = rho[0] * t32 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t39 = 0.1e1 / t22 / t17;
  t40 = t27 * t27;
  t44 = t8 * t8;
  t45 = t44 * rho[0];
  t50 = my_piecewise3(t2, 0, t8 * t23 * t27 / 0.2e1 - t9 * t39 * t40 / 0.2e1 + 0.8e1 * t45 * t23 * params->c);
  tv2rho20 = rho[0] * t50 + 0.2e1 * t32;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t59 = t22 * t22;
  t60 = 0.1e1 / t59;
  t61 = t40 * t27;
  t70 = my_piecewise3(t2, 0, -0.3e1 / 0.2e1 * t8 * t39 * t40 + 0.24e2 * t44 * t23 * params->c + 0.3e1 / 0.2e1 * t9 * t60 * t61 - 0.48e2 * t45 * t39 * t27 * params->c);
  tv3rho30 = rho[0] * t70 + 0.3e1 * t50;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t82 = t40 * t40;
  t92 = params->c * params->c;
  t97 = my_piecewise3(t2, 0, 0.6e1 * t8 * t60 * t61 - 0.192e3 * t44 * t39 * t27 * params->c - 0.6e1 * t9 / t59 / t17 * t82 + 0.288e3 * t45 * t60 * t40 * params->c - 0.1536e4 * t44 * t8 * rho[0] * t39 * t92);
  tv4rho40 = rho[0] * t97 + 0.4e1 * t70;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t27, t28, t31, t32, t33, t35, t38;
  double t39, t40, tzk0;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = M_CBRT2;
  t24 = t23 * t23;
  t25 = POW_1_3(t18);
  t27 = t22 * t4;
  t28 = POW_1_3(t27);
  t31 = t24 * t25 / 0.2e1 + t24 * t28 / 0.2e1;
  t32 = t31 * t31;
  t33 = t32 * t31;
  t35 = t32 * t32;
  t38 = params->c * t35 * t32 - params->b * t33 + params->a;
  t39 = 0.1e1 / t38;
  t40 = t22 * t39;
  tzk0 = my_piecewise3(t3, 0, -t18 * t40 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t27, t28, t31, t32, t33, t35, t38;
  double t39, t40, tzk0;

  double t43, t44, t45, t47, t48, t50, t51, t52;
  double t54, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t70, t73, t77, t80, t81;
  double t85, tvrho0, t88, t89, t92, t93, t95, t98;
  double t101, t106, t107, t111, tvrho1;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = M_CBRT2;
  t24 = t23 * t23;
  t25 = POW_1_3(t18);
  t27 = t22 * t4;
  t28 = POW_1_3(t27);
  t31 = t24 * t25 / 0.2e1 + t24 * t28 / 0.2e1;
  t32 = t31 * t31;
  t33 = t32 * t31;
  t35 = t32 * t32;
  t38 = params->c * t35 * t32 - params->b * t33 + params->a;
  t39 = 0.1e1 / t38;
  t40 = t22 * t39;
  tzk0 = my_piecewise3(t3, 0, -t18 * t40 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = t4 * t4;
  t44 = 0.1e1 / t43;
  t45 = t14 * t44;
  t47 = my_piecewise5(t8, 0, t12, 0, t5 - t45);
  t48 = t47 * t4;
  t50 = t17 * t22;
  t51 = t50 * t39;
  t52 = t19 * t44;
  t54 = my_piecewise5(t12, 0, t8, 0, -t5 - t52);
  t55 = t54 * t39;
  t57 = t38 * t38;
  t58 = 0.1e1 / t57;
  t59 = t22 * t58;
  t60 = params->b * t32;
  t61 = t25 * t25;
  t63 = t24 / t61;
  t64 = t48 + 0.1e1 + t16;
  t66 = t28 * t28;
  t68 = t24 / t66;
  t70 = t54 * t4 + t21 + 0.1e1;
  t73 = t63 * t64 / 0.6e1 + t68 * t70 / 0.6e1;
  t77 = params->c * t35 * t31;
  t80 = -0.3e1 * t60 * t73 + 0.6e1 * t77 * t73;
  t81 = t59 * t80;
  t85 = my_piecewise3(t3, 0, -t18 * t55 / 0.4e1 + t18 * t81 / 0.4e1 - t48 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho0 = t4 * t85 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t88 = my_piecewise5(t8, 0, t12, 0, -t5 - t45);
  t89 = t88 * t4;
  t92 = my_piecewise5(t12, 0, t8, 0, t5 - t52);
  t93 = t92 * t39;
  t95 = t89 + 0.1e1 + t16;
  t98 = t92 * t4 + t21 + 0.1e1;
  t101 = t63 * t95 / 0.6e1 + t68 * t98 / 0.6e1;
  t106 = -0.3e1 * t60 * t101 + 0.6e1 * t77 * t101;
  t107 = t59 * t106;
  t111 = my_piecewise3(t3, 0, t18 * t107 / 0.4e1 - t18 * t93 / 0.4e1 - t89 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho1 = t4 * t111 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t27, t28, t31, t32, t33, t35, t38;
  double t39, t40, tzk0;

  double t43, t44, t45, t47, t48, t50, t51, t52;
  double t54, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t70, t73, t77, t80, t81;
  double t85, tvrho0, t88, t89, t92, t93, t95, t98;
  double t101, t106, t107, t111, tvrho1;

  double t114, t115, t116, t119, t120, t123, t124, t130;
  double t131, t133, t134, t136, t139, t140, t143, t144;
  double t148, t149, t150, t151, t154, t155, t160, t161;
  double t165, t170, t171, t176, t179, t182, t187, t188;
  double t192, tv2rho20, t195, t196, t199, t200, t211, t212;
  double t215, t216, t219, t220, t225, t226, t228, t231;
  double t232, t233, t236, t239, t242, t245, t249, t252;
  double t259, t260, t263, t264, tv2rho21, t269, t270, t282;
  double t283, t286, t289, t290, t293, t296, t300, t303;
  double t308, t311, t318, t319, t323, tv2rho22;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = M_CBRT2;
  t24 = t23 * t23;
  t25 = POW_1_3(t18);
  t27 = t22 * t4;
  t28 = POW_1_3(t27);
  t31 = t24 * t25 / 0.2e1 + t24 * t28 / 0.2e1;
  t32 = t31 * t31;
  t33 = t32 * t31;
  t35 = t32 * t32;
  t38 = params->c * t35 * t32 - params->b * t33 + params->a;
  t39 = 0.1e1 / t38;
  t40 = t22 * t39;
  tzk0 = my_piecewise3(t3, 0, -t18 * t40 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = t4 * t4;
  t44 = 0.1e1 / t43;
  t45 = t14 * t44;
  t47 = my_piecewise5(t8, 0, t12, 0, t5 - t45);
  t48 = t47 * t4;
  t50 = t17 * t22;
  t51 = t50 * t39;
  t52 = t19 * t44;
  t54 = my_piecewise5(t12, 0, t8, 0, -t5 - t52);
  t55 = t54 * t39;
  t57 = t38 * t38;
  t58 = 0.1e1 / t57;
  t59 = t22 * t58;
  t60 = params->b * t32;
  t61 = t25 * t25;
  t63 = t24 / t61;
  t64 = t48 + 0.1e1 + t16;
  t66 = t28 * t28;
  t68 = t24 / t66;
  t70 = t54 * t4 + t21 + 0.1e1;
  t73 = t63 * t64 / 0.6e1 + t68 * t70 / 0.6e1;
  t77 = params->c * t35 * t31;
  t80 = -0.3e1 * t60 * t73 + 0.6e1 * t77 * t73;
  t81 = t59 * t80;
  t85 = my_piecewise3(t3, 0, -t18 * t55 / 0.4e1 + t18 * t81 / 0.4e1 - t48 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho0 = t4 * t85 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t88 = my_piecewise5(t8, 0, t12, 0, -t5 - t45);
  t89 = t88 * t4;
  t92 = my_piecewise5(t12, 0, t8, 0, t5 - t52);
  t93 = t92 * t39;
  t95 = t89 + 0.1e1 + t16;
  t98 = t92 * t4 + t21 + 0.1e1;
  t101 = t63 * t95 / 0.6e1 + t68 * t98 / 0.6e1;
  t106 = -0.3e1 * t60 * t101 + 0.6e1 * t77 * t101;
  t107 = t59 * t106;
  t111 = my_piecewise3(t3, 0, t18 * t107 / 0.4e1 - t18 * t93 / 0.4e1 - t89 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho1 = t4 * t111 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t114 = t43 * t4;
  t115 = 0.1e1 / t114;
  t116 = t14 * t115;
  t119 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t44 + 0.2e1 * t116);
  t120 = t119 * t4;
  t123 = t47 * t22;
  t124 = t123 * t39;
  t130 = t17 * t54;
  t131 = t130 * t39;
  t133 = t58 * t80;
  t134 = t50 * t133;
  t136 = t19 * t115;
  t139 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t44 + 0.2e1 * t136);
  t140 = t139 * t39;
  t143 = t54 * t58;
  t144 = t143 * t80;
  t148 = 0.1e1 / t57 / t38;
  t149 = t22 * t148;
  t150 = t80 * t80;
  t151 = t149 * t150;
  t154 = params->b * t31;
  t155 = t73 * t73;
  t160 = t24 / t61 / t18;
  t161 = t64 * t64;
  t165 = t120 + 0.2e1 * t47;
  t170 = t24 / t66 / t27;
  t171 = t70 * t70;
  t176 = t139 * t4 + 0.2e1 * t54;
  t179 = -t160 * t161 / 0.9e1 + t63 * t165 / 0.6e1 - t170 * t171 / 0.9e1 + t68 * t176 / 0.6e1;
  t182 = params->c * t35;
  t187 = -0.6e1 * t154 * t155 + 0.3e2 * t182 * t155 - 0.3e1 * t60 * t179 + 0.6e1 * t77 * t179;
  t188 = t59 * t187;
  t192 = my_piecewise3(t3, 0, -t120 * t40 / 0.4e1 - t124 / 0.2e1 - t48 * t55 / 0.2e1 + t48 * t81 / 0.2e1 - t131 / 0.2e1 + t134 / 0.2e1 - t18 * t140 / 0.4e1 + t18 * t144 / 0.2e1 - t18 * t151 / 0.2e1 + t18 * t188 / 0.4e1);
  tv2rho20 = t4 * t192 + 0.2e1 * t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t195 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t116);
  t196 = t195 * t4;
  t199 = t88 * t22;
  t200 = t199 * t39;
  t211 = t17 * t92;
  t212 = t211 * t39;
  t215 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t136);
  t216 = t215 * t39;
  t219 = t92 * t58;
  t220 = t219 * t80;
  t225 = t58 * t106;
  t226 = t50 * t225;
  t228 = t143 * t106;
  t231 = t18 * t22;
  t232 = t148 * t106;
  t233 = t232 * t80;
  t236 = t101 * t73;
  t239 = t95 * t64;
  t242 = t196 + t88 + t47;
  t245 = t98 * t70;
  t249 = t215 * t4 + t54 + t92;
  t252 = -t160 * t239 / 0.9e1 + t63 * t242 / 0.6e1 - t170 * t245 / 0.9e1 + t68 * t249 / 0.6e1;
  t259 = -0.6e1 * t154 * t236 + 0.3e2 * t182 * t236 - 0.3e1 * t60 * t252 + 0.6e1 * t77 * t252;
  t260 = t59 * t259;
  t263 = -t196 * t40 / 0.4e1 - t200 / 0.4e1 - t89 * t55 / 0.4e1 + t89 * t81 / 0.4e1 - t124 / 0.4e1 - t131 / 0.4e1 + t134 / 0.4e1 - t48 * t93 / 0.4e1 - t212 / 0.4e1 - t18 * t216 / 0.4e1 + t18 * t220 / 0.4e1 + t48 * t107 / 0.4e1 + t226 / 0.4e1 + t18 * t228 / 0.4e1 - t231 * t233 / 0.2e1 + t18 * t260 / 0.4e1;
  t264 = my_piecewise3(t3, 0, t263);
  tv2rho21 = t4 * t264 + t111 + t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t269 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t44 + 0.2e1 * t116);
  t270 = t269 * t4;
  t282 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t44 + 0.2e1 * t136);
  t283 = t282 * t39;
  t286 = t219 * t106;
  t289 = t106 * t106;
  t290 = t149 * t289;
  t293 = t101 * t101;
  t296 = t95 * t95;
  t300 = t270 + 0.2e1 * t88;
  t303 = t98 * t98;
  t308 = t282 * t4 + 0.2e1 * t92;
  t311 = -t160 * t296 / 0.9e1 + t63 * t300 / 0.6e1 - t170 * t303 / 0.9e1 + t68 * t308 / 0.6e1;
  t318 = -0.6e1 * t154 * t293 + 0.3e2 * t182 * t293 - 0.3e1 * t60 * t311 + 0.6e1 * t77 * t311;
  t319 = t59 * t318;
  t323 = my_piecewise3(t3, 0, -t270 * t40 / 0.4e1 - t200 / 0.2e1 - t89 * t93 / 0.2e1 + t89 * t107 / 0.2e1 - t212 / 0.2e1 + t226 / 0.2e1 - t18 * t283 / 0.4e1 + t18 * t286 / 0.2e1 - t18 * t290 / 0.2e1 + t18 * t319 / 0.4e1);
  tv2rho22 = t4 * t323 + 0.2e1 * t111;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t27, t28, t31, t32, t33, t35, t38;
  double t39, t40, tzk0;

  double t43, t44, t45, t47, t48, t50, t51, t52;
  double t54, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t70, t73, t77, t80, t81;
  double t85, tvrho0, t88, t89, t92, t93, t95, t98;
  double t101, t106, t107, t111, tvrho1;

  double t114, t115, t116, t119, t120, t123, t124, t130;
  double t131, t133, t134, t136, t139, t140, t143, t144;
  double t148, t149, t150, t151, t154, t155, t160, t161;
  double t165, t170, t171, t176, t179, t182, t187, t188;
  double t192, tv2rho20, t195, t196, t199, t200, t211, t212;
  double t215, t216, t219, t220, t225, t226, t228, t231;
  double t232, t233, t236, t239, t242, t245, t249, t252;
  double t259, t260, t263, t264, tv2rho21, t269, t270, t282;
  double t283, t286, t289, t290, t293, t296, t300, t303;
  double t308, t311, t318, t319, t323, tv2rho22;

  double t332, t333, t335, t336, t339, t342, t345, t348;
  double t352, t353, t359, t360, t361, t364, t365, t367;
  double t370, t374, t375, t381, t384, t387, t390, t393;
  double t400, t401, t406, t407, t412, t416, t418, t419;
  double t421, t424, t425, t427, t428, t432, t433, t436;
  double t437, t438, t439, t440, t444, t447, t449, tv3rho30;
  double t451, t452, t454, t455, t457, t458, t460, t461;
  double t463, t465, t473, t474, t475, t477, t478, t483;
  double t484, t486, t487, t489, t490, t496, t505, t506;
  double t509, t512, t520, t521, t524, t527, t530, t533;
  double t545, t546, t559, t560, t563, t575, t576, t581;
  double t582, t593, t594, t597, t599, t601, t602, t604;
  double t607, t610, tv3rho31, t612, t613, t615, t616, t618;
  double t619, t622, t623, t636, t637, t640, t641, t643;
  double t644, t646, t648, t650, t662, t663, t668, t672;
  double t677, t682, t685, t688, t691, t703, t716, t719;
  double t731, t732, t735, t737, t739, t740, t743, t745;
  double t746, t749, t752, tv3rho32, t765, t768, t771, t774;
  double t777, t780, t785, t786, t788, t791, t794, t799;
  double t802, t805, t814, t815, t828, t833, t836, t837;
  double t840, t843, t845, tv3rho33;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = M_CBRT2;
  t24 = t23 * t23;
  t25 = POW_1_3(t18);
  t27 = t22 * t4;
  t28 = POW_1_3(t27);
  t31 = t24 * t25 / 0.2e1 + t24 * t28 / 0.2e1;
  t32 = t31 * t31;
  t33 = t32 * t31;
  t35 = t32 * t32;
  t38 = params->c * t35 * t32 - params->b * t33 + params->a;
  t39 = 0.1e1 / t38;
  t40 = t22 * t39;
  tzk0 = my_piecewise3(t3, 0, -t18 * t40 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = t4 * t4;
  t44 = 0.1e1 / t43;
  t45 = t14 * t44;
  t47 = my_piecewise5(t8, 0, t12, 0, t5 - t45);
  t48 = t47 * t4;
  t50 = t17 * t22;
  t51 = t50 * t39;
  t52 = t19 * t44;
  t54 = my_piecewise5(t12, 0, t8, 0, -t5 - t52);
  t55 = t54 * t39;
  t57 = t38 * t38;
  t58 = 0.1e1 / t57;
  t59 = t22 * t58;
  t60 = params->b * t32;
  t61 = t25 * t25;
  t63 = t24 / t61;
  t64 = t48 + 0.1e1 + t16;
  t66 = t28 * t28;
  t68 = t24 / t66;
  t70 = t54 * t4 + t21 + 0.1e1;
  t73 = t63 * t64 / 0.6e1 + t68 * t70 / 0.6e1;
  t77 = params->c * t35 * t31;
  t80 = -0.3e1 * t60 * t73 + 0.6e1 * t77 * t73;
  t81 = t59 * t80;
  t85 = my_piecewise3(t3, 0, -t18 * t55 / 0.4e1 + t18 * t81 / 0.4e1 - t48 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho0 = t4 * t85 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t88 = my_piecewise5(t8, 0, t12, 0, -t5 - t45);
  t89 = t88 * t4;
  t92 = my_piecewise5(t12, 0, t8, 0, t5 - t52);
  t93 = t92 * t39;
  t95 = t89 + 0.1e1 + t16;
  t98 = t92 * t4 + t21 + 0.1e1;
  t101 = t63 * t95 / 0.6e1 + t68 * t98 / 0.6e1;
  t106 = -0.3e1 * t60 * t101 + 0.6e1 * t77 * t101;
  t107 = t59 * t106;
  t111 = my_piecewise3(t3, 0, t18 * t107 / 0.4e1 - t18 * t93 / 0.4e1 - t89 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho1 = t4 * t111 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t114 = t43 * t4;
  t115 = 0.1e1 / t114;
  t116 = t14 * t115;
  t119 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t44 + 0.2e1 * t116);
  t120 = t119 * t4;
  t123 = t47 * t22;
  t124 = t123 * t39;
  t130 = t17 * t54;
  t131 = t130 * t39;
  t133 = t58 * t80;
  t134 = t50 * t133;
  t136 = t19 * t115;
  t139 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t44 + 0.2e1 * t136);
  t140 = t139 * t39;
  t143 = t54 * t58;
  t144 = t143 * t80;
  t148 = 0.1e1 / t57 / t38;
  t149 = t22 * t148;
  t150 = t80 * t80;
  t151 = t149 * t150;
  t154 = params->b * t31;
  t155 = t73 * t73;
  t160 = t24 / t61 / t18;
  t161 = t64 * t64;
  t165 = t120 + 0.2e1 * t47;
  t170 = t24 / t66 / t27;
  t171 = t70 * t70;
  t176 = t139 * t4 + 0.2e1 * t54;
  t179 = -t160 * t161 / 0.9e1 + t63 * t165 / 0.6e1 - t170 * t171 / 0.9e1 + t68 * t176 / 0.6e1;
  t182 = params->c * t35;
  t187 = -0.6e1 * t154 * t155 + 0.3e2 * t182 * t155 - 0.3e1 * t60 * t179 + 0.6e1 * t77 * t179;
  t188 = t59 * t187;
  t192 = my_piecewise3(t3, 0, -t120 * t40 / 0.4e1 - t124 / 0.2e1 - t48 * t55 / 0.2e1 + t48 * t81 / 0.2e1 - t131 / 0.2e1 + t134 / 0.2e1 - t18 * t140 / 0.4e1 + t18 * t144 / 0.2e1 - t18 * t151 / 0.2e1 + t18 * t188 / 0.4e1);
  tv2rho20 = t4 * t192 + 0.2e1 * t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t195 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t116);
  t196 = t195 * t4;
  t199 = t88 * t22;
  t200 = t199 * t39;
  t211 = t17 * t92;
  t212 = t211 * t39;
  t215 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t136);
  t216 = t215 * t39;
  t219 = t92 * t58;
  t220 = t219 * t80;
  t225 = t58 * t106;
  t226 = t50 * t225;
  t228 = t143 * t106;
  t231 = t18 * t22;
  t232 = t148 * t106;
  t233 = t232 * t80;
  t236 = t101 * t73;
  t239 = t95 * t64;
  t242 = t196 + t88 + t47;
  t245 = t98 * t70;
  t249 = t215 * t4 + t54 + t92;
  t252 = -t160 * t239 / 0.9e1 + t63 * t242 / 0.6e1 - t170 * t245 / 0.9e1 + t68 * t249 / 0.6e1;
  t259 = -0.6e1 * t154 * t236 + 0.3e2 * t182 * t236 - 0.3e1 * t60 * t252 + 0.6e1 * t77 * t252;
  t260 = t59 * t259;
  t263 = -t196 * t40 / 0.4e1 - t200 / 0.4e1 - t89 * t55 / 0.4e1 + t89 * t81 / 0.4e1 - t124 / 0.4e1 - t131 / 0.4e1 + t134 / 0.4e1 - t48 * t93 / 0.4e1 - t212 / 0.4e1 - t18 * t216 / 0.4e1 + t18 * t220 / 0.4e1 + t48 * t107 / 0.4e1 + t226 / 0.4e1 + t18 * t228 / 0.4e1 - t231 * t233 / 0.2e1 + t18 * t260 / 0.4e1;
  t264 = my_piecewise3(t3, 0, t263);
  tv2rho21 = t4 * t264 + t111 + t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t269 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t44 + 0.2e1 * t116);
  t270 = t269 * t4;
  t282 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t44 + 0.2e1 * t136);
  t283 = t282 * t39;
  t286 = t219 * t106;
  t289 = t106 * t106;
  t290 = t149 * t289;
  t293 = t101 * t101;
  t296 = t95 * t95;
  t300 = t270 + 0.2e1 * t88;
  t303 = t98 * t98;
  t308 = t282 * t4 + 0.2e1 * t92;
  t311 = -t160 * t296 / 0.9e1 + t63 * t300 / 0.6e1 - t170 * t303 / 0.9e1 + t68 * t308 / 0.6e1;
  t318 = -0.6e1 * t154 * t293 + 0.3e2 * t182 * t293 - 0.3e1 * t60 * t311 + 0.6e1 * t77 * t311;
  t319 = t59 * t318;
  t323 = my_piecewise3(t3, 0, -t270 * t40 / 0.4e1 - t200 / 0.2e1 - t89 * t93 / 0.2e1 + t89 * t107 / 0.2e1 - t212 / 0.2e1 + t226 / 0.2e1 - t18 * t283 / 0.4e1 + t18 * t286 / 0.2e1 - t18 * t290 / 0.2e1 + t18 * t319 / 0.4e1);
  tv2rho22 = t4 * t323 + 0.2e1 * t111;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t332 = t148 * t150;
  t333 = t50 * t332;
  t335 = t139 * t58;
  t336 = t335 * t80;
  t339 = t143 * t187;
  t342 = t155 * t73;
  t345 = t73 * t179;
  t348 = t17 * t17;
  t352 = t24 / t61 / t348 / t43;
  t353 = t161 * t64;
  t359 = t43 * t43;
  t360 = 0.1e1 / t359;
  t361 = t14 * t360;
  t364 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t115 - 0.6e1 * t361);
  t365 = t364 * t4;
  t367 = t365 + 0.3e1 * t119;
  t370 = t22 * t22;
  t374 = t24 / t66 / t370 / t43;
  t375 = t171 * t70;
  t381 = t19 * t360;
  t384 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t115 - 0.6e1 * t381);
  t387 = t384 * t4 + 0.3e1 * t139;
  t390 = 0.5e1 / 0.27e2 * t352 * t353 - t160 * t64 * t165 / 0.3e1 + t63 * t367 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t375 - t170 * t70 * t176 / 0.3e1 + t68 * t387 / 0.6e1;
  t393 = params->c * t33;
  t400 = -0.18e2 * t154 * t345 + 0.9e2 * t182 * t345 + 0.12e3 * t393 * t342 - 0.6e1 * params->b * t342 - 0.3e1 * t60 * t390 + 0.6e1 * t77 * t390;
  t401 = t59 * t400;
  t406 = t119 * t22;
  t407 = t406 * t39;
  t412 = t123 * t133;
  t416 = t130 * t133;
  t418 = t58 * t187;
  t419 = t50 * t418;
  t421 = t384 * t39;
  t424 = t47 * t54;
  t425 = t424 * t39;
  t427 = t17 * t139;
  t428 = t427 * t39;
  t432 = t54 * t148;
  t433 = t432 * t150;
  t436 = t57 * t57;
  t437 = 0.1e1 / t436;
  t438 = t22 * t437;
  t439 = t150 * t80;
  t440 = t438 * t439;
  t444 = t148 * t80 * t187;
  t447 = 0.3e1 / 0.2e1 * t412 - 0.3e1 / 0.4e1 * t48 * t140 + 0.3e1 / 0.2e1 * t416 + 0.3e1 / 0.4e1 * t419 - t18 * t421 / 0.4e1 - 0.3e1 / 0.2e1 * t425 - 0.3e1 / 0.4e1 * t428 - 0.3e1 / 0.2e1 * t48 * t151 - 0.3e1 / 0.2e1 * t18 * t433 + 0.3e1 / 0.2e1 * t18 * t440 - 0.3e1 / 0.2e1 * t231 * t444;
  t449 = my_piecewise3(t3, 0, 0.3e1 / 0.4e1 * t120 * t81 + 0.3e1 / 0.2e1 * t48 * t144 + 0.3e1 / 0.4e1 * t48 * t188 - 0.3e1 / 0.2e1 * t333 + 0.3e1 / 0.4e1 * t18 * t336 + 0.3e1 / 0.4e1 * t18 * t339 + t18 * t401 / 0.4e1 - t365 * t40 / 0.4e1 - 0.3e1 / 0.4e1 * t407 - 0.3e1 / 0.4e1 * t120 * t55 + t447);
  tv3rho30 = t4 * t449 + 0.3e1 * t192;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t451 = 0.2e1 * t264;
  t452 = t88 * t54;
  t454 = t452 * t39 / 0.2e1;
  t455 = t17 * t215;
  t457 = t455 * t39 / 0.2e1;
  t458 = t47 * t92;
  t460 = t458 * t39 / 0.2e1;
  t461 = t195 * t22;
  t463 = t461 * t39 / 0.2e1;
  t465 = t199 * t133 / 0.2e1;
  t473 = t211 * t133 / 0.2e1;
  t474 = 0.2e1 * t115;
  t475 = 0.6e1 * t381;
  t477 = my_piecewise5(t12, 0, t8, 0, -t474 - t475);
  t478 = t477 * t39;
  t483 = t130 * t225 / 0.2e1;
  t484 = t58 * t259;
  t486 = t50 * t484 / 0.2e1;
  t487 = 0.6e1 * t361;
  t489 = my_piecewise5(t8, 0, t12, 0, t474 - t487);
  t490 = t489 * t4;
  t496 = t123 * t225 / 0.2e1;
  t505 = t215 * t58;
  t506 = t505 * t80;
  t509 = t219 * t187;
  t512 = t483 + t486 - t490 * t40 / 0.4e1 - t196 * t55 / 0.2e1 + t496 + t196 * t81 / 0.2e1 + t89 * t144 / 0.2e1 + t89 * t188 / 0.4e1 + t48 * t220 / 0.2e1 + t18 * t506 / 0.2e1 + t18 * t509 / 0.4e1;
  t520 = t50 * t233;
  t521 = t335 * t106;
  t524 = t143 * t259;
  t527 = params->b * t155;
  t530 = t252 * t73;
  t533 = t101 * t179;
  t545 = 0.2e1 * t195;
  t546 = t490 + t545 + t119;
  t559 = 0.2e1 * t215;
  t560 = t477 * t4 + t139 + t559;
  t563 = 0.5e1 / 0.27e2 * t352 * t95 * t161 - 0.2e1 / 0.9e1 * t160 * t242 * t64 - t160 * t95 * t165 / 0.9e1 + t63 * t546 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t98 * t171 - 0.2e1 / 0.9e1 * t170 * t249 * t70 - t170 * t98 * t176 / 0.9e1 + t68 * t560 / 0.6e1;
  t575 = 0.12e3 * t393 * t101 * t155 - 0.6e1 * t527 * t101 - 0.12e2 * t154 * t530 - 0.6e1 * t154 * t533 + 0.6e2 * t182 * t530 + 0.3e2 * t182 * t533 - 0.3e1 * t60 * t563 + 0.6e1 * t77 * t563;
  t576 = t59 * t575;
  t581 = t92 * t148;
  t582 = t581 * t150;
  t593 = t437 * t106;
  t594 = t593 * t150;
  t597 = t48 * t22;
  t599 = t18 * t54;
  t601 = t148 * t259;
  t602 = t601 * t80;
  t604 = t232 * t187;
  t607 = t412 / 0.2e1 + t416 / 0.2e1 + t419 / 0.4e1 - t407 / 0.4e1 - t425 / 0.2e1 - t428 / 0.4e1 + 0.3e1 / 0.2e1 * t231 * t594 - t597 * t233 - t599 * t233 - t231 * t602 - t231 * t604 / 0.2e1;
  t610 = my_piecewise3(t3, 0, -t454 - t457 - t460 - t463 + t465 - t89 * t140 / 0.4e1 - t120 * t93 / 0.4e1 - t48 * t216 / 0.2e1 + t473 - t18 * t478 / 0.4e1 + t512 + t120 * t107 / 0.4e1 + t48 * t228 / 0.2e1 + t48 * t260 / 0.2e1 - t520 + t18 * t521 / 0.4e1 + t18 * t524 / 0.2e1 + t18 * t576 / 0.4e1 - t89 * t151 / 0.2e1 - t18 * t582 / 0.2e1 - t333 / 0.2e1 + t607);
  tv3rho31 = t4 * t610 + t192 + t451;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t612 = t269 * t22;
  t613 = t612 * t39;
  t615 = t88 * t92;
  t616 = t615 * t39;
  t618 = t17 * t282;
  t619 = t618 * t39;
  t622 = my_piecewise5(t8, 0, t12, 0, -t474 - t487);
  t623 = t622 * t4;
  t636 = my_piecewise5(t12, 0, t8, 0, t474 - t475);
  t637 = t636 * t39;
  t640 = t148 * t289;
  t641 = t50 * t640;
  t643 = t58 * t318;
  t644 = t50 * t643;
  t646 = t211 * t225;
  t648 = t199 * t225;
  t650 = -t89 * t216 / 0.2e1 - t48 * t283 / 0.4e1 - t18 * t637 / 0.4e1 - t641 / 0.2e1 + t644 / 0.4e1 + t646 / 0.2e1 + t648 / 0.2e1 + t465 + t473 + t483 + t486;
  t662 = t282 * t58;
  t663 = t662 * t80;
  t668 = t505 * t106;
  t672 = t219 * t259;
  t677 = t432 * t289;
  t682 = t143 * t318;
  t685 = params->b * t73;
  t688 = t101 * t252;
  t691 = t311 * t73;
  t703 = t623 + t269 + t545;
  t716 = t636 * t4 + t282 + t559;
  t719 = 0.5e1 / 0.27e2 * t352 * t296 * t64 - 0.2e1 / 0.9e1 * t160 * t95 * t242 - t160 * t300 * t64 / 0.9e1 + t63 * t703 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t303 * t70 - 0.2e1 / 0.9e1 * t170 * t98 * t249 - t170 * t308 * t70 / 0.9e1 + t68 * t716 / 0.6e1;
  t731 = 0.12e3 * t393 * t293 * t73 - 0.12e2 * t154 * t688 - 0.6e1 * t154 * t691 + 0.6e2 * t182 * t688 + 0.3e2 * t182 * t691 - 0.6e1 * t685 * t293 - 0.3e1 * t60 * t719 + 0.6e1 * t77 * t719;
  t732 = t59 * t731;
  t735 = t89 * t22;
  t737 = t18 * t92;
  t739 = t437 * t289;
  t740 = t739 * t80;
  t743 = t232 * t259;
  t745 = t148 * t318;
  t746 = t745 * t80;
  t749 = t18 * t672 / 0.2e1 - t48 * t290 / 0.2e1 - t18 * t677 / 0.2e1 + t48 * t319 / 0.4e1 + t18 * t682 / 0.4e1 + t18 * t732 / 0.4e1 - t735 * t233 - t737 * t233 + 0.3e1 / 0.2e1 * t231 * t740 - t231 * t743 - t231 * t746 / 0.2e1;
  t752 = my_piecewise3(t3, 0, -t613 / 0.4e1 - t616 / 0.2e1 - t619 / 0.4e1 - t454 - t457 - t460 - t463 - t623 * t40 / 0.4e1 - t270 * t55 / 0.4e1 - t196 * t93 / 0.2e1 + t650 + t496 - t520 + t270 * t81 / 0.4e1 + t89 * t220 / 0.2e1 + t196 * t107 / 0.2e1 + t89 * t228 / 0.2e1 + t89 * t260 / 0.2e1 + t18 * t663 / 0.4e1 + t48 * t286 / 0.2e1 + t18 * t668 / 0.2e1 + t749);
  tv3rho32 = t4 * t752 + t323 + t451;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t765 = t662 * t106;
  t768 = t219 * t318;
  t771 = t293 * t101;
  t774 = t101 * t311;
  t777 = t296 * t95;
  t780 = t95 * t300;
  t785 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t115 - 0.6e1 * t361);
  t786 = t785 * t4;
  t788 = t786 + 0.3e1 * t269;
  t791 = t303 * t98;
  t794 = t98 * t308;
  t799 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t115 - 0.6e1 * t381);
  t802 = t799 * t4 + 0.3e1 * t282;
  t805 = 0.5e1 / 0.27e2 * t352 * t777 - t160 * t780 / 0.3e1 + t63 * t788 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t791 - t170 * t794 / 0.3e1 + t68 * t802 / 0.6e1;
  t814 = -0.18e2 * t154 * t774 + 0.9e2 * t182 * t774 + 0.12e3 * t393 * t771 - 0.3e1 * t60 * t805 + 0.6e1 * t77 * t805 - 0.6e1 * params->b * t771;
  t815 = t59 * t814;
  t828 = t799 * t39;
  t833 = t581 * t289;
  t836 = t289 * t106;
  t837 = t438 * t836;
  t840 = t232 * t318;
  t843 = -0.3e1 / 0.4e1 * t613 - 0.3e1 / 0.2e1 * t616 - 0.3e1 / 0.4e1 * t619 - t786 * t40 / 0.4e1 - 0.3e1 / 0.4e1 * t270 * t93 - 0.3e1 / 0.4e1 * t89 * t283 - t18 * t828 / 0.4e1 - 0.3e1 / 0.2e1 * t89 * t290 - 0.3e1 / 0.2e1 * t18 * t833 + 0.3e1 / 0.2e1 * t18 * t837 - 0.3e1 / 0.2e1 * t231 * t840;
  t845 = my_piecewise3(t3, 0, 0.3e1 / 0.2e1 * t648 + 0.3e1 / 0.2e1 * t646 - 0.3e1 / 0.2e1 * t641 + 0.3e1 / 0.4e1 * t644 + 0.3e1 / 0.4e1 * t270 * t107 + 0.3e1 / 0.2e1 * t89 * t286 + 0.3e1 / 0.4e1 * t89 * t319 + 0.3e1 / 0.4e1 * t18 * t765 + 0.3e1 / 0.4e1 * t18 * t768 + t18 * t815 / 0.4e1 + t843);
  tv3rho33 = t4 * t845 + 0.3e1 * t323;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, xc_lda_out_params *out)
{
  double t3, t4, t5, t8, t9, t12, t13, t14;
  double t16, t17, t18, t19, t21, t22, t23, t24;
  double t25, t27, t28, t31, t32, t33, t35, t38;
  double t39, t40, tzk0;

  double t43, t44, t45, t47, t48, t50, t51, t52;
  double t54, t55, t57, t58, t59, t60, t61, t63;
  double t64, t66, t68, t70, t73, t77, t80, t81;
  double t85, tvrho0, t88, t89, t92, t93, t95, t98;
  double t101, t106, t107, t111, tvrho1;

  double t114, t115, t116, t119, t120, t123, t124, t130;
  double t131, t133, t134, t136, t139, t140, t143, t144;
  double t148, t149, t150, t151, t154, t155, t160, t161;
  double t165, t170, t171, t176, t179, t182, t187, t188;
  double t192, tv2rho20, t195, t196, t199, t200, t211, t212;
  double t215, t216, t219, t220, t225, t226, t228, t231;
  double t232, t233, t236, t239, t242, t245, t249, t252;
  double t259, t260, t263, t264, tv2rho21, t269, t270, t282;
  double t283, t286, t289, t290, t293, t296, t300, t303;
  double t308, t311, t318, t319, t323, tv2rho22;

  double t332, t333, t335, t336, t339, t342, t345, t348;
  double t352, t353, t359, t360, t361, t364, t365, t367;
  double t370, t374, t375, t381, t384, t387, t390, t393;
  double t400, t401, t406, t407, t412, t416, t418, t419;
  double t421, t424, t425, t427, t428, t432, t433, t436;
  double t437, t438, t439, t440, t444, t447, t449, tv3rho30;
  double t451, t452, t454, t455, t457, t458, t460, t461;
  double t463, t465, t473, t474, t475, t477, t478, t483;
  double t484, t486, t487, t489, t490, t496, t505, t506;
  double t509, t512, t520, t521, t524, t527, t530, t533;
  double t545, t546, t559, t560, t563, t575, t576, t581;
  double t582, t593, t594, t597, t599, t601, t602, t604;
  double t607, t610, tv3rho31, t612, t613, t615, t616, t618;
  double t619, t622, t623, t636, t637, t640, t641, t643;
  double t644, t646, t648, t650, t662, t663, t668, t672;
  double t677, t682, t685, t688, t691, t703, t716, t719;
  double t731, t732, t735, t737, t739, t740, t743, t745;
  double t746, t749, t752, tv3rho32, t765, t768, t771, t774;
  double t777, t780, t785, t786, t788, t791, t794, t799;
  double t802, t805, t814, t815, t828, t833, t836, t837;
  double t840, t843, t845, tv3rho33;

  double t849, t851, t854, t856, t859, t860, t863, t865;
  double t867, t869, t871, t874, t875, t878, t879, t886;
  double t889, t893, t895, t901, t919, t925, t930, t931;
  double t932, t936, t945, t947, t957, t960, t967, t968;
  double t974, t988, t989, t995, t1006, t1009, t1010, t1026;
  double t1028, tv4rho40, t1031, t1033, t1036, t1038, t1040, t1046;
  double t1049, t1052, t1073, t1074, t1076, t1077, t1100, t1102;
  double t1108, t1128, t1137, t1139, t1141, t1143, t1150, t1152;
  double t1154, t1156, t1158, t1160, t1162, t1165, t1168, t1171;
  double t1173, t1176, t1179, t1182, t1188, t1196, t1208, t1216;
  double t1245, t1275, t1279, t1283, t1287, t1303, t1310, t1326;
  double t1332, t1336, tv4rho41, t1341, t1343, t1344, t1360, t1364;
  double t1366, t1367, t1368, t1369, t1370, t1371, t1379, t1382;
  double t1387, t1390, t1402, t1431, t1452, t1477, t1490, t1492;
  double t1497, t1505, t1513, t1524, t1529, t1546, t1551, t1556;
  double t1560, t1570, t1574, t1576, t1577, t1578, t1580, t1581;
  double t1583, t1585, t1588, t1589, t1592, t1595, t1598, t1600;
  double t1632, t1660, t1664, tv4rho42, t1683, t1706, t1709, t1716;
  double t1719, t1720, t1733, t1737, t1748, t1750, t1753, t1755;
  double t1758, t1760, t1762, t1764, t1766, t1769, t1772, t1775;
  double t1778, t1785, t1789, t1794, t1797, t1800, t1848, t1868;
  double t1878, t1896, t1919, t1922, t1951, t1955, tv4rho43, t1962;
  double t1963, t1972, t1987, t1998, t2002, t2035, t2038, t2041;
  double t2047, t2057, t2063, t2074, t2077, t2093, t2095, tv4rho44;

  lda_c_epc18_params *params;

  assert(p->params != NULL);
  params = (lda_c_epc18_params * )(p->params);

  t3 = rho[0] <= p->dens_threshold && rho[1] <= p->dens_threshold;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 * t4;
  t19 = -t14;
  t21 = my_piecewise5(t12, t9, t8, t13, t19 * t5);
  t22 = 0.1e1 + t21;
  t23 = M_CBRT2;
  t24 = t23 * t23;
  t25 = POW_1_3(t18);
  t27 = t22 * t4;
  t28 = POW_1_3(t27);
  t31 = t24 * t25 / 0.2e1 + t24 * t28 / 0.2e1;
  t32 = t31 * t31;
  t33 = t32 * t31;
  t35 = t32 * t32;
  t38 = params->c * t35 * t32 - params->b * t33 + params->a;
  t39 = 0.1e1 / t38;
  t40 = t22 * t39;
  tzk0 = my_piecewise3(t3, 0, -t18 * t40 / 0.4e1);

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = t4 * t4;
  t44 = 0.1e1 / t43;
  t45 = t14 * t44;
  t47 = my_piecewise5(t8, 0, t12, 0, t5 - t45);
  t48 = t47 * t4;
  t50 = t17 * t22;
  t51 = t50 * t39;
  t52 = t19 * t44;
  t54 = my_piecewise5(t12, 0, t8, 0, -t5 - t52);
  t55 = t54 * t39;
  t57 = t38 * t38;
  t58 = 0.1e1 / t57;
  t59 = t22 * t58;
  t60 = params->b * t32;
  t61 = t25 * t25;
  t63 = t24 / t61;
  t64 = t48 + 0.1e1 + t16;
  t66 = t28 * t28;
  t68 = t24 / t66;
  t70 = t54 * t4 + t21 + 0.1e1;
  t73 = t63 * t64 / 0.6e1 + t68 * t70 / 0.6e1;
  t77 = params->c * t35 * t31;
  t80 = -0.3e1 * t60 * t73 + 0.6e1 * t77 * t73;
  t81 = t59 * t80;
  t85 = my_piecewise3(t3, 0, -t18 * t55 / 0.4e1 + t18 * t81 / 0.4e1 - t48 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho0 = t4 * t85 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t88 = my_piecewise5(t8, 0, t12, 0, -t5 - t45);
  t89 = t88 * t4;
  t92 = my_piecewise5(t12, 0, t8, 0, t5 - t52);
  t93 = t92 * t39;
  t95 = t89 + 0.1e1 + t16;
  t98 = t92 * t4 + t21 + 0.1e1;
  t101 = t63 * t95 / 0.6e1 + t68 * t98 / 0.6e1;
  t106 = -0.3e1 * t60 * t101 + 0.6e1 * t77 * t101;
  t107 = t59 * t106;
  t111 = my_piecewise3(t3, 0, t18 * t107 / 0.4e1 - t18 * t93 / 0.4e1 - t89 * t40 / 0.4e1 - t51 / 0.4e1);
  tvrho1 = t4 * t111 + tzk0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t114 = t43 * t4;
  t115 = 0.1e1 / t114;
  t116 = t14 * t115;
  t119 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t44 + 0.2e1 * t116);
  t120 = t119 * t4;
  t123 = t47 * t22;
  t124 = t123 * t39;
  t130 = t17 * t54;
  t131 = t130 * t39;
  t133 = t58 * t80;
  t134 = t50 * t133;
  t136 = t19 * t115;
  t139 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t44 + 0.2e1 * t136);
  t140 = t139 * t39;
  t143 = t54 * t58;
  t144 = t143 * t80;
  t148 = 0.1e1 / t57 / t38;
  t149 = t22 * t148;
  t150 = t80 * t80;
  t151 = t149 * t150;
  t154 = params->b * t31;
  t155 = t73 * t73;
  t160 = t24 / t61 / t18;
  t161 = t64 * t64;
  t165 = t120 + 0.2e1 * t47;
  t170 = t24 / t66 / t27;
  t171 = t70 * t70;
  t176 = t139 * t4 + 0.2e1 * t54;
  t179 = -t160 * t161 / 0.9e1 + t63 * t165 / 0.6e1 - t170 * t171 / 0.9e1 + t68 * t176 / 0.6e1;
  t182 = params->c * t35;
  t187 = -0.6e1 * t154 * t155 + 0.3e2 * t182 * t155 - 0.3e1 * t60 * t179 + 0.6e1 * t77 * t179;
  t188 = t59 * t187;
  t192 = my_piecewise3(t3, 0, -t120 * t40 / 0.4e1 - t124 / 0.2e1 - t48 * t55 / 0.2e1 + t48 * t81 / 0.2e1 - t131 / 0.2e1 + t134 / 0.2e1 - t18 * t140 / 0.4e1 + t18 * t144 / 0.2e1 - t18 * t151 / 0.2e1 + t18 * t188 / 0.4e1);
  tv2rho20 = t4 * t192 + 0.2e1 * t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t195 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t116);
  t196 = t195 * t4;
  t199 = t88 * t22;
  t200 = t199 * t39;
  t211 = t17 * t92;
  t212 = t211 * t39;
  t215 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t136);
  t216 = t215 * t39;
  t219 = t92 * t58;
  t220 = t219 * t80;
  t225 = t58 * t106;
  t226 = t50 * t225;
  t228 = t143 * t106;
  t231 = t18 * t22;
  t232 = t148 * t106;
  t233 = t232 * t80;
  t236 = t101 * t73;
  t239 = t95 * t64;
  t242 = t196 + t88 + t47;
  t245 = t98 * t70;
  t249 = t215 * t4 + t54 + t92;
  t252 = -t160 * t239 / 0.9e1 + t63 * t242 / 0.6e1 - t170 * t245 / 0.9e1 + t68 * t249 / 0.6e1;
  t259 = -0.6e1 * t154 * t236 + 0.3e2 * t182 * t236 - 0.3e1 * t60 * t252 + 0.6e1 * t77 * t252;
  t260 = t59 * t259;
  t263 = -t196 * t40 / 0.4e1 - t200 / 0.4e1 - t89 * t55 / 0.4e1 + t89 * t81 / 0.4e1 - t124 / 0.4e1 - t131 / 0.4e1 + t134 / 0.4e1 - t48 * t93 / 0.4e1 - t212 / 0.4e1 - t18 * t216 / 0.4e1 + t18 * t220 / 0.4e1 + t48 * t107 / 0.4e1 + t226 / 0.4e1 + t18 * t228 / 0.4e1 - t231 * t233 / 0.2e1 + t18 * t260 / 0.4e1;
  t264 = my_piecewise3(t3, 0, t263);
  tv2rho21 = t4 * t264 + t111 + t85;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t269 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t44 + 0.2e1 * t116);
  t270 = t269 * t4;
  t282 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t44 + 0.2e1 * t136);
  t283 = t282 * t39;
  t286 = t219 * t106;
  t289 = t106 * t106;
  t290 = t149 * t289;
  t293 = t101 * t101;
  t296 = t95 * t95;
  t300 = t270 + 0.2e1 * t88;
  t303 = t98 * t98;
  t308 = t282 * t4 + 0.2e1 * t92;
  t311 = -t160 * t296 / 0.9e1 + t63 * t300 / 0.6e1 - t170 * t303 / 0.9e1 + t68 * t308 / 0.6e1;
  t318 = -0.6e1 * t154 * t293 + 0.3e2 * t182 * t293 - 0.3e1 * t60 * t311 + 0.6e1 * t77 * t311;
  t319 = t59 * t318;
  t323 = my_piecewise3(t3, 0, -t270 * t40 / 0.4e1 - t200 / 0.2e1 - t89 * t93 / 0.2e1 + t89 * t107 / 0.2e1 - t212 / 0.2e1 + t226 / 0.2e1 - t18 * t283 / 0.4e1 + t18 * t286 / 0.2e1 - t18 * t290 / 0.2e1 + t18 * t319 / 0.4e1);
  tv2rho22 = t4 * t323 + 0.2e1 * t111;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t332 = t148 * t150;
  t333 = t50 * t332;
  t335 = t139 * t58;
  t336 = t335 * t80;
  t339 = t143 * t187;
  t342 = t155 * t73;
  t345 = t73 * t179;
  t348 = t17 * t17;
  t352 = t24 / t61 / t348 / t43;
  t353 = t161 * t64;
  t359 = t43 * t43;
  t360 = 0.1e1 / t359;
  t361 = t14 * t360;
  t364 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t115 - 0.6e1 * t361);
  t365 = t364 * t4;
  t367 = t365 + 0.3e1 * t119;
  t370 = t22 * t22;
  t374 = t24 / t66 / t370 / t43;
  t375 = t171 * t70;
  t381 = t19 * t360;
  t384 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t115 - 0.6e1 * t381);
  t387 = t384 * t4 + 0.3e1 * t139;
  t390 = 0.5e1 / 0.27e2 * t352 * t353 - t160 * t64 * t165 / 0.3e1 + t63 * t367 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t375 - t170 * t70 * t176 / 0.3e1 + t68 * t387 / 0.6e1;
  t393 = params->c * t33;
  t400 = -0.18e2 * t154 * t345 + 0.9e2 * t182 * t345 + 0.12e3 * t393 * t342 - 0.6e1 * params->b * t342 - 0.3e1 * t60 * t390 + 0.6e1 * t77 * t390;
  t401 = t59 * t400;
  t406 = t119 * t22;
  t407 = t406 * t39;
  t412 = t123 * t133;
  t416 = t130 * t133;
  t418 = t58 * t187;
  t419 = t50 * t418;
  t421 = t384 * t39;
  t424 = t47 * t54;
  t425 = t424 * t39;
  t427 = t17 * t139;
  t428 = t427 * t39;
  t432 = t54 * t148;
  t433 = t432 * t150;
  t436 = t57 * t57;
  t437 = 0.1e1 / t436;
  t438 = t22 * t437;
  t439 = t150 * t80;
  t440 = t438 * t439;
  t444 = t148 * t80 * t187;
  t447 = 0.3e1 / 0.2e1 * t412 - 0.3e1 / 0.4e1 * t48 * t140 + 0.3e1 / 0.2e1 * t416 + 0.3e1 / 0.4e1 * t419 - t18 * t421 / 0.4e1 - 0.3e1 / 0.2e1 * t425 - 0.3e1 / 0.4e1 * t428 - 0.3e1 / 0.2e1 * t48 * t151 - 0.3e1 / 0.2e1 * t18 * t433 + 0.3e1 / 0.2e1 * t18 * t440 - 0.3e1 / 0.2e1 * t231 * t444;
  t449 = my_piecewise3(t3, 0, 0.3e1 / 0.4e1 * t120 * t81 + 0.3e1 / 0.2e1 * t48 * t144 + 0.3e1 / 0.4e1 * t48 * t188 - 0.3e1 / 0.2e1 * t333 + 0.3e1 / 0.4e1 * t18 * t336 + 0.3e1 / 0.4e1 * t18 * t339 + t18 * t401 / 0.4e1 - t365 * t40 / 0.4e1 - 0.3e1 / 0.4e1 * t407 - 0.3e1 / 0.4e1 * t120 * t55 + t447);
  tv3rho30 = t4 * t449 + 0.3e1 * t192;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t451 = 0.2e1 * t264;
  t452 = t88 * t54;
  t454 = t452 * t39 / 0.2e1;
  t455 = t17 * t215;
  t457 = t455 * t39 / 0.2e1;
  t458 = t47 * t92;
  t460 = t458 * t39 / 0.2e1;
  t461 = t195 * t22;
  t463 = t461 * t39 / 0.2e1;
  t465 = t199 * t133 / 0.2e1;
  t473 = t211 * t133 / 0.2e1;
  t474 = 0.2e1 * t115;
  t475 = 0.6e1 * t381;
  t477 = my_piecewise5(t12, 0, t8, 0, -t474 - t475);
  t478 = t477 * t39;
  t483 = t130 * t225 / 0.2e1;
  t484 = t58 * t259;
  t486 = t50 * t484 / 0.2e1;
  t487 = 0.6e1 * t361;
  t489 = my_piecewise5(t8, 0, t12, 0, t474 - t487);
  t490 = t489 * t4;
  t496 = t123 * t225 / 0.2e1;
  t505 = t215 * t58;
  t506 = t505 * t80;
  t509 = t219 * t187;
  t512 = t483 + t486 - t490 * t40 / 0.4e1 - t196 * t55 / 0.2e1 + t496 + t196 * t81 / 0.2e1 + t89 * t144 / 0.2e1 + t89 * t188 / 0.4e1 + t48 * t220 / 0.2e1 + t18 * t506 / 0.2e1 + t18 * t509 / 0.4e1;
  t520 = t50 * t233;
  t521 = t335 * t106;
  t524 = t143 * t259;
  t527 = params->b * t155;
  t530 = t252 * t73;
  t533 = t101 * t179;
  t545 = 0.2e1 * t195;
  t546 = t490 + t545 + t119;
  t559 = 0.2e1 * t215;
  t560 = t477 * t4 + t139 + t559;
  t563 = 0.5e1 / 0.27e2 * t352 * t95 * t161 - 0.2e1 / 0.9e1 * t160 * t242 * t64 - t160 * t95 * t165 / 0.9e1 + t63 * t546 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t98 * t171 - 0.2e1 / 0.9e1 * t170 * t249 * t70 - t170 * t98 * t176 / 0.9e1 + t68 * t560 / 0.6e1;
  t575 = 0.12e3 * t393 * t101 * t155 - 0.6e1 * t527 * t101 - 0.12e2 * t154 * t530 - 0.6e1 * t154 * t533 + 0.6e2 * t182 * t530 + 0.3e2 * t182 * t533 - 0.3e1 * t60 * t563 + 0.6e1 * t77 * t563;
  t576 = t59 * t575;
  t581 = t92 * t148;
  t582 = t581 * t150;
  t593 = t437 * t106;
  t594 = t593 * t150;
  t597 = t48 * t22;
  t599 = t18 * t54;
  t601 = t148 * t259;
  t602 = t601 * t80;
  t604 = t232 * t187;
  t607 = t412 / 0.2e1 + t416 / 0.2e1 + t419 / 0.4e1 - t407 / 0.4e1 - t425 / 0.2e1 - t428 / 0.4e1 + 0.3e1 / 0.2e1 * t231 * t594 - t597 * t233 - t599 * t233 - t231 * t602 - t231 * t604 / 0.2e1;
  t610 = my_piecewise3(t3, 0, -t454 - t457 - t460 - t463 + t465 - t89 * t140 / 0.4e1 - t120 * t93 / 0.4e1 - t48 * t216 / 0.2e1 + t473 - t18 * t478 / 0.4e1 + t512 + t120 * t107 / 0.4e1 + t48 * t228 / 0.2e1 + t48 * t260 / 0.2e1 - t520 + t18 * t521 / 0.4e1 + t18 * t524 / 0.2e1 + t18 * t576 / 0.4e1 - t89 * t151 / 0.2e1 - t18 * t582 / 0.2e1 - t333 / 0.2e1 + t607);
  tv3rho31 = t4 * t610 + t192 + t451;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t612 = t269 * t22;
  t613 = t612 * t39;
  t615 = t88 * t92;
  t616 = t615 * t39;
  t618 = t17 * t282;
  t619 = t618 * t39;
  t622 = my_piecewise5(t8, 0, t12, 0, -t474 - t487);
  t623 = t622 * t4;
  t636 = my_piecewise5(t12, 0, t8, 0, t474 - t475);
  t637 = t636 * t39;
  t640 = t148 * t289;
  t641 = t50 * t640;
  t643 = t58 * t318;
  t644 = t50 * t643;
  t646 = t211 * t225;
  t648 = t199 * t225;
  t650 = -t89 * t216 / 0.2e1 - t48 * t283 / 0.4e1 - t18 * t637 / 0.4e1 - t641 / 0.2e1 + t644 / 0.4e1 + t646 / 0.2e1 + t648 / 0.2e1 + t465 + t473 + t483 + t486;
  t662 = t282 * t58;
  t663 = t662 * t80;
  t668 = t505 * t106;
  t672 = t219 * t259;
  t677 = t432 * t289;
  t682 = t143 * t318;
  t685 = params->b * t73;
  t688 = t101 * t252;
  t691 = t311 * t73;
  t703 = t623 + t269 + t545;
  t716 = t636 * t4 + t282 + t559;
  t719 = 0.5e1 / 0.27e2 * t352 * t296 * t64 - 0.2e1 / 0.9e1 * t160 * t95 * t242 - t160 * t300 * t64 / 0.9e1 + t63 * t703 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t303 * t70 - 0.2e1 / 0.9e1 * t170 * t98 * t249 - t170 * t308 * t70 / 0.9e1 + t68 * t716 / 0.6e1;
  t731 = 0.12e3 * t393 * t293 * t73 - 0.12e2 * t154 * t688 - 0.6e1 * t154 * t691 + 0.6e2 * t182 * t688 + 0.3e2 * t182 * t691 - 0.6e1 * t685 * t293 - 0.3e1 * t60 * t719 + 0.6e1 * t77 * t719;
  t732 = t59 * t731;
  t735 = t89 * t22;
  t737 = t18 * t92;
  t739 = t437 * t289;
  t740 = t739 * t80;
  t743 = t232 * t259;
  t745 = t148 * t318;
  t746 = t745 * t80;
  t749 = t18 * t672 / 0.2e1 - t48 * t290 / 0.2e1 - t18 * t677 / 0.2e1 + t48 * t319 / 0.4e1 + t18 * t682 / 0.4e1 + t18 * t732 / 0.4e1 - t735 * t233 - t737 * t233 + 0.3e1 / 0.2e1 * t231 * t740 - t231 * t743 - t231 * t746 / 0.2e1;
  t752 = my_piecewise3(t3, 0, -t613 / 0.4e1 - t616 / 0.2e1 - t619 / 0.4e1 - t454 - t457 - t460 - t463 - t623 * t40 / 0.4e1 - t270 * t55 / 0.4e1 - t196 * t93 / 0.2e1 + t650 + t496 - t520 + t270 * t81 / 0.4e1 + t89 * t220 / 0.2e1 + t196 * t107 / 0.2e1 + t89 * t228 / 0.2e1 + t89 * t260 / 0.2e1 + t18 * t663 / 0.4e1 + t48 * t286 / 0.2e1 + t18 * t668 / 0.2e1 + t749);
  tv3rho32 = t4 * t752 + t323 + t451;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t765 = t662 * t106;
  t768 = t219 * t318;
  t771 = t293 * t101;
  t774 = t101 * t311;
  t777 = t296 * t95;
  t780 = t95 * t300;
  t785 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t115 - 0.6e1 * t361);
  t786 = t785 * t4;
  t788 = t786 + 0.3e1 * t269;
  t791 = t303 * t98;
  t794 = t98 * t308;
  t799 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t115 - 0.6e1 * t381);
  t802 = t799 * t4 + 0.3e1 * t282;
  t805 = 0.5e1 / 0.27e2 * t352 * t777 - t160 * t780 / 0.3e1 + t63 * t788 / 0.6e1 + 0.5e1 / 0.27e2 * t374 * t791 - t170 * t794 / 0.3e1 + t68 * t802 / 0.6e1;
  t814 = -0.18e2 * t154 * t774 + 0.9e2 * t182 * t774 + 0.12e3 * t393 * t771 - 0.3e1 * t60 * t805 + 0.6e1 * t77 * t805 - 0.6e1 * params->b * t771;
  t815 = t59 * t814;
  t828 = t799 * t39;
  t833 = t581 * t289;
  t836 = t289 * t106;
  t837 = t438 * t836;
  t840 = t232 * t318;
  t843 = -0.3e1 / 0.4e1 * t613 - 0.3e1 / 0.2e1 * t616 - 0.3e1 / 0.4e1 * t619 - t786 * t40 / 0.4e1 - 0.3e1 / 0.4e1 * t270 * t93 - 0.3e1 / 0.4e1 * t89 * t283 - t18 * t828 / 0.4e1 - 0.3e1 / 0.2e1 * t89 * t290 - 0.3e1 / 0.2e1 * t18 * t833 + 0.3e1 / 0.2e1 * t18 * t837 - 0.3e1 / 0.2e1 * t231 * t840;
  t845 = my_piecewise3(t3, 0, 0.3e1 / 0.2e1 * t648 + 0.3e1 / 0.2e1 * t646 - 0.3e1 / 0.2e1 * t641 + 0.3e1 / 0.4e1 * t644 + 0.3e1 / 0.4e1 * t270 * t107 + 0.3e1 / 0.2e1 * t89 * t286 + 0.3e1 / 0.4e1 * t89 * t319 + 0.3e1 / 0.4e1 * t18 * t765 + 0.3e1 / 0.4e1 * t18 * t768 + t18 * t815 / 0.4e1 + t843);
  tv3rho33 = t4 * t845 + 0.3e1 * t323;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t849 = t17 * t384 * t39;
  t851 = t119 * t54 * t39;
  t854 = t364 * t22 * t39;
  t856 = t47 * t139 * t39;
  t859 = t50 * t58 * t400;
  t860 = t130 * t418;
  t863 = t50 * t437 * t439;
  t865 = t427 * t133;
  t867 = t123 * t418;
  t869 = t123 * t332;
  t871 = t130 * t332;
  t874 = 0.1e1 / t359 / t4;
  t875 = t14 * t874;
  t878 = my_piecewise5(t8, 0, t12, 0, -0.24e2 * t360 + 0.24e2 * t875);
  t879 = t878 * t4;
  t886 = t19 * t874;
  t889 = my_piecewise5(t12, 0, t8, 0, 0.24e2 * t360 + 0.24e2 * t886);
  t893 = t406 * t133;
  t895 = t424 * t133;
  t901 = -t849 - 0.3e1 * t851 - t854 - 0.3e1 * t856 + t859 + 0.3e1 * t860 + 0.6e1 * t863 + 0.3e1 * t865 + 0.3e1 * t867 - 0.6e1 * t869 - 0.6e1 * t871 - t879 * t40 / 0.4e1 - t365 * t55 - 0.3e1 / 0.2e1 * t120 * t140 - t48 * t421 - t18 * t889 * t39 / 0.4e1 + 0.3e1 * t893 + 0.6e1 * t895 - 0.6e1 * t597 * t444 - 0.6e1 * t599 * t444;
  t919 = t139 * t148;
  t925 = t54 * t437;
  t930 = 0.1e1 / t436 / t38;
  t931 = t22 * t930;
  t932 = t150 * t150;
  t936 = t187 * t187;
  t945 = t50 * t444;
  t947 = t384 * t58;
  t957 = t179 * t179;
  t960 = t73 * t390;
  t967 = t24 / t61 / t348 / t17 / t114;
  t968 = t161 * t161;
  t974 = t165 * t165;
  t988 = t24 / t66 / t370 / t22 / t114;
  t989 = t171 * t171;
  t995 = t176 * t176;
  t1006 = -0.4e2 / 0.81e2 * t967 * t968 + 0.1e2 / 0.9e1 * t352 * t161 * t165 - t160 * t974 / 0.3e1 - 0.4e1 / 0.9e1 * t160 * t64 * t367 + t63 * (t879 + 0.4e1 * t364) / 0.6e1 - 0.4e2 / 0.81e2 * t988 * t989 + 0.1e2 / 0.9e1 * t374 * t171 * t176 - t170 * t995 / 0.3e1 - 0.4e1 / 0.9e1 * t170 * t70 * t387 + t68 * (t889 * t4 + 0.4e1 * t384) / 0.6e1;
  t1009 = params->c * t32;
  t1010 = t155 * t155;
  t1026 = -0.2e1 * t231 * t148 * t400 * t80 + 0.9e1 * t231 * t437 * t150 * t187 + t365 * t81 + 0.3e1 * t120 * t144 + 0.3e1 / 0.2e1 * t120 * t188 - 0.3e1 * t120 * t151 - 0.6e1 * t48 * t433 - 0.3e1 * t18 * t919 * t150 + 0.6e1 * t48 * t440 + 0.6e1 * t18 * t925 * t439 - 0.6e1 * t18 * t931 * t932 - 0.3e1 / 0.2e1 * t18 * t149 * t936 + 0.3e1 * t48 * t336 + 0.3e1 * t48 * t339 + t48 * t401 - 0.6e1 * t945 + t18 * t947 * t80 + 0.3e1 / 0.2e1 * t18 * t335 * t187 + t18 * t143 * t400 + t18 * t59 * (0.72e3 * t393 * t155 * t179 - 0.3e1 * t60 * t1006 + 0.6e1 * t77 * t1006 + 0.36e3 * t1009 * t1010 - 0.18e2 * t154 * t957 - 0.24e2 * t154 * t960 - 0.36e2 * t527 * t179 + 0.9e2 * t182 * t957 + 0.12e3 * t182 * t960) / 0.4e1;
  t1028 = my_piecewise3(t3, 0, t901 + t1026);
  tv4rho40 = t4 * t1028 + 0.4e1 * t449;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1031 = t211 * t332;
  t1033 = t199 * t332;
  t1036 = t50 * t58 * t575;
  t1038 = t130 * t484;
  t1040 = t427 * t225;
  t1046 = t563 * t73;
  t1049 = t252 * t179;
  t1052 = t101 * t390;
  t1073 = 0.12e2 * t360;
  t1074 = 0.24e2 * t875;
  t1076 = my_piecewise5(t8, 0, t12, 0, -t1073 + t1074);
  t1077 = t1076 * t4;
  t1100 = 0.24e2 * t886;
  t1102 = my_piecewise5(t12, 0, t8, 0, t1073 + t1100);
  t1108 = -0.4e2 / 0.81e2 * t967 * t95 * t353 + 0.5e1 / 0.9e1 * t352 * t242 * t161 + 0.5e1 / 0.9e1 * t352 * t239 * t165 - t160 * t546 * t64 / 0.3e1 - t160 * t242 * t165 / 0.3e1 - t160 * t95 * t367 / 0.9e1 + t63 * (t1077 + 0.3e1 * t489 + t364) / 0.6e1 - 0.4e2 / 0.81e2 * t988 * t98 * t375 + 0.5e1 / 0.9e1 * t374 * t249 * t171 + 0.5e1 / 0.9e1 * t374 * t245 * t176 - t170 * t560 * t70 / 0.3e1 - t170 * t249 * t176 / 0.3e1 - t170 * t98 * t387 / 0.9e1 + t68 * (t1102 * t4 + t384 + 0.3e1 * t477) / 0.6e1;
  t1128 = 0.36e3 * t1009 * t101 * t342 + 0.36e3 * t393 * t252 * t155 + 0.36e3 * t393 * t236 * t179 - 0.18e2 * t154 * t1046 + 0.9e2 * t182 * t1046 - 0.18e2 * t154 * t1049 + 0.9e2 * t182 * t1049 - 0.6e1 * t154 * t1052 + 0.3e2 * t182 * t1052 - 0.3e1 * t60 * t1108 + 0.6e1 * t77 * t1108 - 0.18e2 * t527 * t252 - 0.18e2 * t685 * t533;
  t1137 = t130 * t233;
  t1139 = t50 * t602;
  t1141 = t50 * t604;
  t1143 = -0.3e1 / 0.2e1 * t1031 - 0.3e1 / 0.2e1 * t1033 + 0.3e1 / 0.4e1 * t1036 + 0.3e1 / 0.2e1 * t1038 + 0.3e1 / 0.4e1 * t1040 + t18 * t59 * t1128 / 0.4e1 + 0.3e1 / 0.4e1 * t18 * t143 * t575 + 0.3e1 / 0.4e1 * t48 * t576 - 0.3e1 * t1137 - 0.3e1 * t1139 - 0.3e1 / 0.2e1 * t1141;
  t1150 = t406 * t225;
  t1152 = t455 * t133;
  t1154 = t211 * t418;
  t1156 = t458 * t133;
  t1158 = t199 * t418;
  t1160 = t461 * t133;
  t1162 = t452 * t133;
  t1165 = t17 * t477 * t39;
  t1168 = t195 * t54 * t39;
  t1171 = t47 * t215 * t39;
  t1173 = t18 * t947 * t106 / 0.4e1 + 0.3e1 / 0.4e1 * t18 * t335 * t259 + 0.3e1 / 0.4e1 * t1150 + 0.3e1 / 0.2e1 * t1152 + 0.3e1 / 0.4e1 * t1154 + 0.3e1 / 0.2e1 * t1156 + 0.3e1 / 0.4e1 * t1158 + 0.3e1 / 0.2e1 * t1160 + 0.3e1 / 0.2e1 * t1162 - 0.3e1 / 0.4e1 * t1165 - 0.3e1 / 0.2e1 * t1168 - 0.3e1 / 0.2e1 * t1171;
  t1176 = t489 * t22 * t39;
  t1179 = t88 * t139 * t39;
  t1182 = t119 * t92 * t39;
  t1188 = t123 * t484;
  t1196 = -0.3e1 / 0.4e1 * t1176 - 0.3e1 / 0.4e1 * t1179 - 0.3e1 / 0.4e1 * t1182 - t849 / 0.4e1 - 0.3e1 / 0.4e1 * t851 - t854 / 0.4e1 - 0.3e1 / 0.4e1 * t856 + 0.3e1 / 0.2e1 * t1188 - t1077 * t40 / 0.4e1 - 0.3e1 / 0.4e1 * t490 * t55 - 0.3e1 / 0.4e1 * t196 * t140;
  t1208 = t424 * t225;
  t1216 = -t89 * t421 / 0.4e1 - t365 * t93 / 0.4e1 - 0.3e1 / 0.4e1 * t120 * t216 - 0.3e1 / 0.4e1 * t48 * t478 - t18 * t1102 * t39 / 0.4e1 + 0.3e1 / 0.2e1 * t1208 + t859 / 0.4e1 + 0.3e1 / 0.4e1 * t860 + 0.3e1 / 0.2e1 * t863 + 0.3e1 / 0.4e1 * t865 + 0.3e1 / 0.4e1 * t867 - 0.3e1 / 0.2e1 * t869;
  t1245 = -0.3e1 / 0.2e1 * t871 + 0.3e1 / 0.4e1 * t893 + 0.3e1 / 0.2e1 * t895 + 0.9e1 / 0.2e1 * t231 * t593 * t80 * t187 - 0.6e1 * t231 * t930 * t106 * t439 - 0.3e1 / 0.2e1 * t735 * t444 - 0.3e1 / 0.2e1 * t737 * t444 - 0.3e1 / 0.2e1 * t120 * t22 * t233 - 0.3e1 * t48 * t54 * t233 - 0.3e1 * t597 * t602 - 0.3e1 / 0.2e1 * t18 * t139 * t233;
  t1275 = -0.3e1 * t599 * t602 - 0.3e1 / 0.2e1 * t231 * t148 * t575 * t80 + 0.9e1 / 0.2e1 * t597 * t594 + 0.9e1 / 0.2e1 * t599 * t594 + 0.9e1 / 0.2e1 * t231 * t437 * t259 * t150 - 0.3e1 / 0.2e1 * t597 * t604 - 0.3e1 / 0.2e1 * t599 * t604 - 0.3e1 / 0.2e1 * t231 * t601 * t187 - t231 * t232 * t400 / 0.2e1 - 0.3e1 / 0.2e1 * t945 - 0.3e1 / 0.2e1 * t196 * t151 - 0.3e1 / 0.2e1 * t89 * t433;
  t1279 = t215 * t148;
  t1283 = t50 * t594;
  t1287 = t92 * t437;
  t1303 = -0.3e1 / 0.2e1 * t48 * t582 - 0.3e1 / 0.2e1 * t18 * t1279 * t150 + 0.9e1 / 0.2e1 * t1283 + 0.3e1 / 0.2e1 * t89 * t440 + 0.3e1 / 0.2e1 * t18 * t1287 * t439 + 0.3e1 / 0.4e1 * t490 * t81 + 0.3e1 / 0.2e1 * t196 * t144 + 0.3e1 / 0.4e1 * t196 * t188 + 0.3e1 / 0.4e1 * t89 * t336 + 0.3e1 / 0.4e1 * t89 * t339 + t89 * t401 / 0.4e1;
  t1310 = t477 * t58;
  t1326 = t123 * t233;
  t1332 = 0.3e1 / 0.4e1 * t120 * t220 + 0.3e1 / 0.2e1 * t48 * t506 + 0.3e1 / 0.4e1 * t48 * t509 + 0.3e1 / 0.4e1 * t18 * t1310 * t80 + 0.3e1 / 0.4e1 * t18 * t505 * t187 + t18 * t219 * t400 / 0.4e1 + t365 * t107 / 0.4e1 + 0.3e1 / 0.4e1 * t120 * t228 + 0.3e1 / 0.4e1 * t120 * t260 - 0.3e1 * t1326 + 0.3e1 / 0.4e1 * t48 * t521 + 0.3e1 / 0.2e1 * t48 * t524;
  t1336 = my_piecewise3(t3, 0, t1143 + t1173 + t1196 + t1216 + t1245 + t1275 + t1303 + t1332);
  tv4rho41 = t4 * t1336 + t449 + 0.3e1 * t610;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1341 = t50 * t58 * t731;
  t1343 = my_piecewise5(t8, 0, t12, 0, t1074);
  t1344 = t1343 * t4;
  t1360 = my_piecewise5(t12, 0, t8, 0, t1100);
  t1364 = t130 * t643;
  t1366 = t455 * t225;
  t1367 = t211 * t484;
  t1368 = t130 * t640;
  t1369 = t1341 / 0.2e1 - t1344 * t40 / 0.4e1 - t623 * t55 / 0.2e1 - t270 * t140 / 0.4e1 - t490 * t93 / 0.2e1 - t196 * t216 - t89 * t478 / 0.2e1 - t120 * t283 / 0.4e1 - t48 * t637 / 0.2e1 - t18 * t1360 * t39 / 0.4e1 + t1364 / 0.2e1 + t1366 + t1367 - t1368;
  t1370 = t452 * t225;
  t1371 = t199 * t484;
  t1379 = t252 * t252;
  t1382 = t101 * t563;
  t1387 = t719 * t73;
  t1390 = t311 * t179;
  t1402 = t242 * t242;
  t1431 = t249 * t249;
  t1452 = -0.4e2 / 0.81e2 * t967 * t296 * t161 + 0.2e2 / 0.27e2 * t352 * t239 * t242 + 0.5e1 / 0.27e2 * t352 * t296 * t165 - 0.2e1 / 0.9e1 * t160 * t1402 - 0.2e1 / 0.9e1 * t160 * t95 * t546 + 0.5e1 / 0.27e2 * t352 * t300 * t161 - 0.2e1 / 0.9e1 * t160 * t703 * t64 - t160 * t300 * t165 / 0.9e1 + t63 * (t1344 + 0.2e1 * t622 + 0.2e1 * t489) / 0.6e1 - 0.4e2 / 0.81e2 * t988 * t303 * t171 + 0.2e2 / 0.27e2 * t374 * t245 * t249 + 0.5e1 / 0.27e2 * t374 * t303 * t176 - 0.2e1 / 0.9e1 * t170 * t1431 - 0.2e1 / 0.9e1 * t170 * t98 * t560 + 0.5e1 / 0.27e2 * t374 * t308 * t171 - 0.2e1 / 0.9e1 * t170 * t716 * t70 - t170 * t308 * t176 / 0.9e1 + t68 * (t1360 * t4 + 0.2e1 * t477 + 0.2e1 * t636) / 0.6e1;
  t1477 = 0.36e3 * t1009 * t293 * t155 + 0.12e3 * t393 * t311 * t155 + 0.12e3 * t393 * t293 * t179 - 0.6e1 * params->b * t179 * t293 + 0.48e3 * t393 * t236 * t252 - 0.12e2 * t154 * t1379 + 0.6e2 * t182 * t1379 - 0.12e2 * t154 * t1382 + 0.6e2 * t182 * t1382 - 0.12e2 * t154 * t1387 + 0.6e2 * t182 * t1387 - 0.6e1 * t154 * t1390 + 0.3e2 * t182 * t1390 - 0.3e1 * t60 * t1452 + 0.6e1 * t77 * t1452 - 0.6e1 * t527 * t311 - 0.24e2 * t685 * t688;
  t1490 = t50 * t740;
  t1492 = t50 * t743;
  t1497 = -t1031 + t1370 + t1371 - t1033 + t1036 / 0.2e1 + t1038 + t1040 / 0.2e1 + t18 * t59 * t1477 / 0.4e1 + t18 * t143 * t731 / 0.2e1 + t18 * t219 * t575 / 0.2e1 - t120 * t290 / 0.2e1 - t48 * t677 + 0.3e1 * t1490 - 0.2e1 * t1492 - t18 * t919 * t289 / 0.2e1;
  t1505 = t50 * t746;
  t1513 = t636 * t58;
  t1524 = t211 * t233;
  t1529 = t120 * t319 / 0.4e1 + t48 * t682 / 0.2e1 + t48 * t732 / 0.2e1 - t1505 + t18 * t335 * t318 / 0.4e1 + t89 * t576 / 0.2e1 + t48 * t663 / 0.2e1 + t18 * t1513 * t80 / 0.2e1 + t18 * t662 * t187 / 0.4e1 + t120 * t286 / 0.2e1 + t48 * t668 + t48 * t672 - 0.2e1 * t1524 + t18 * t1310 * t106 / 0.2e1;
  t1546 = t199 * t233;
  t1551 = t259 * t259;
  t1556 = t18 * t505 * t259 + t623 * t81 / 0.2e1 + t270 * t144 / 0.2e1 + t270 * t188 / 0.4e1 + t196 * t220 + t89 * t506 + t89 * t509 / 0.2e1 + t490 * t107 / 0.2e1 + t196 * t228 + t196 * t260 - 0.2e1 * t1546 + t89 * t521 / 0.2e1 + t89 * t524 - t18 * t149 * t1551 - t270 * t151 / 0.2e1;
  t1560 = t282 * t148;
  t1570 = -t89 * t582 - t18 * t1560 * t150 / 0.2e1 - 0.2e1 * t1137 - 0.2e1 * t1139 - t1141 + t1150 / 0.2e1 + t1152 + t1154 / 0.2e1 + t1156 + t1158 / 0.2e1 + t1160 + t1162 - t1165 / 0.2e1 - t1168;
  t1574 = t123 * t643;
  t1576 = t123 * t640;
  t1577 = t458 * t225;
  t1578 = t618 * t133;
  t1580 = t461 * t225;
  t1581 = t612 * t133;
  t1583 = t615 * t133;
  t1585 = t622 * t22 * t39;
  t1588 = t195 * t92 * t39;
  t1589 = -t1171 - t1176 / 0.2e1 - t1179 / 0.2e1 - t1182 / 0.2e1 + t1188 + t1208 + t1574 / 0.2e1 - t1576 + t1577 + t1578 / 0.2e1 + t1580 + t1581 / 0.2e1 + t1583 - t1585 / 0.2e1 - t1588;
  t1592 = t47 * t282 * t39;
  t1595 = t269 * t54 * t39;
  t1598 = t88 * t215 * t39;
  t1600 = t17 * t636 * t39;
  t1632 = -t1592 / 0.2e1 - t1595 / 0.2e1 - t1598 - t1600 / 0.2e1 + 0.6e1 * t231 * t593 * t80 * t259 + 0.3e1 * t735 * t594 + 0.3e1 * t737 * t594 - 0.6e1 * t231 * t930 * t289 * t150 + 0.3e1 / 0.2e1 * t231 * t437 * t318 * t150 - 0.2e1 * t196 * t22 * t233 - 0.2e1 * t89 * t54 * t233 - 0.2e1 * t735 * t602 - 0.2e1 * t48 * t92 * t233 - 0.2e1 * t18 * t215 * t233;
  t1660 = -0.2e1 * t737 * t602 + 0.3e1 * t597 * t740 - 0.2e1 * t597 * t743 + 0.3e1 * t599 * t740 - 0.2e1 * t599 * t743 - t597 * t746 - t599 * t746 - t231 * t148 * t731 * t80 - t735 * t604 - t737 * t604 + 0.3e1 / 0.2e1 * t231 * t739 * t187 - t231 * t232 * t575 - t231 * t745 * t187 / 0.2e1 + 0.3e1 * t1283 - 0.2e1 * t1326;
  t1664 = my_piecewise3(t3, 0, t1369 + t1497 + t1529 + t1556 + t1570 + t1589 + t1632 + t1660);
  tv4rho42 = t4 * t1664 + 0.2e1 * t610 + 0.2e1 * t752;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1683 = 0.3e1 / 0.4e1 * t1341 + 0.3e1 / 0.4e1 * t1364 + 0.3e1 / 0.2e1 * t1366 + 0.3e1 / 0.2e1 * t1367 - 0.3e1 / 0.2e1 * t1368 + 0.3e1 / 0.2e1 * t1370 + 0.3e1 / 0.2e1 * t1371 + 0.3e1 / 0.4e1 * t89 * t682 + 0.3e1 / 0.4e1 * t89 * t732 + 0.3e1 / 0.4e1 * t48 * t765 + 0.3e1 / 0.4e1 * t18 * t1513 * t106;
  t1706 = t50 * t840;
  t1709 = 0.3e1 / 0.4e1 * t18 * t662 * t259 + 0.3e1 / 0.4e1 * t48 * t768 + 0.3e1 / 0.4e1 * t18 * t505 * t318 + 0.3e1 / 0.4e1 * t623 * t107 + 0.3e1 / 0.4e1 * t270 * t228 + 0.3e1 / 0.4e1 * t270 * t260 + 0.3e1 / 0.2e1 * t196 * t286 + 0.3e1 / 0.2e1 * t89 * t668 + 0.3e1 / 0.2e1 * t89 * t672 + 0.3e1 / 0.4e1 * t196 * t319 - 0.3e1 / 0.2e1 * t1706 + 0.9e1 / 0.2e1 * t1490;
  t1716 = t50 * t437 * t836;
  t1719 = my_piecewise5(t8, 0, t12, 0, t1073 + t1074);
  t1720 = t1719 * t4;
  t1733 = -0.3e1 * t1492 - 0.3e1 / 0.2e1 * t1505 - 0.3e1 * t1524 - 0.3e1 * t1546 + 0.3e1 / 0.2e1 * t1716 - t1720 * t40 / 0.4e1 - t786 * t55 / 0.4e1 - 0.3e1 / 0.4e1 * t623 * t93 - 0.3e1 / 0.4e1 * t270 * t216 - 0.3e1 / 0.4e1 * t196 * t283 - 0.3e1 / 0.4e1 * t89 * t637;
  t1737 = my_piecewise5(t12, 0, t8, 0, -t1073 + t1100);
  t1748 = t199 * t640;
  t1750 = t211 * t640;
  t1753 = t50 * t58 * t814;
  t1755 = -t48 * t828 / 0.4e1 - t18 * t1737 * t39 / 0.4e1 + 0.3e1 / 0.4e1 * t1574 - 0.3e1 / 0.2e1 * t1576 + 0.3e1 / 0.2e1 * t1577 + 0.3e1 / 0.4e1 * t1578 + 0.3e1 / 0.2e1 * t1580 + 0.3e1 / 0.4e1 * t1581 + 0.3e1 / 0.2e1 * t1583 - 0.3e1 / 0.2e1 * t1748 - 0.3e1 / 0.2e1 * t1750 + t1753 / 0.4e1;
  t1758 = t211 * t643;
  t1760 = t618 * t225;
  t1762 = t199 * t643;
  t1764 = t615 * t225;
  t1766 = t612 * t225;
  t1769 = t88 * t282 * t39;
  t1772 = t17 * t799 * t39;
  t1775 = t785 * t22 * t39;
  t1778 = t269 * t92 * t39;
  t1785 = 0.3e1 / 0.4e1 * t1758 + 0.3e1 / 0.4e1 * t1760 + 0.3e1 / 0.4e1 * t1762 + 0.3e1 / 0.2e1 * t1764 + 0.3e1 / 0.4e1 * t1766 - 0.3e1 / 0.4e1 * t1769 - t1772 / 0.4e1 - t1775 / 0.4e1 - 0.3e1 / 0.4e1 * t1778 + 0.3e1 / 0.4e1 * t18 * t219 * t731 + t48 * t815 / 0.4e1;
  t1789 = params->b * t293;
  t1794 = t252 * t311;
  t1797 = t101 * t719;
  t1800 = t805 * t73;
  t1848 = -0.4e2 / 0.81e2 * t967 * t777 * t64 + 0.5e1 / 0.9e1 * t352 * t296 * t242 + 0.5e1 / 0.9e1 * t352 * t780 * t64 - t160 * t242 * t300 / 0.3e1 - t160 * t95 * t703 / 0.3e1 - t160 * t788 * t64 / 0.9e1 + t63 * (t1720 + t785 + 0.3e1 * t622) / 0.6e1 - 0.4e2 / 0.81e2 * t988 * t791 * t70 + 0.5e1 / 0.9e1 * t374 * t303 * t249 + 0.5e1 / 0.9e1 * t374 * t794 * t70 - t170 * t249 * t308 / 0.3e1 - t170 * t98 * t716 / 0.3e1 - t170 * t802 * t70 / 0.9e1 + t68 * (t1737 * t4 + 0.3e1 * t636 + t799) / 0.6e1;
  t1868 = 0.36e3 * t1009 * t771 * t73 + 0.36e3 * t393 * t293 * t252 + 0.36e3 * t393 * t774 * t73 - 0.18e2 * t154 * t1794 - 0.18e2 * t154 * t1797 - 0.6e1 * t154 * t1800 - 0.18e2 * t1789 * t252 + 0.9e2 * t182 * t1794 + 0.9e2 * t182 * t1797 + 0.3e2 * t182 * t1800 - 0.3e1 * t60 * t1848 + 0.6e1 * t77 * t1848 - 0.18e2 * t685 * t774;
  t1878 = t799 * t58;
  t1896 = t18 * t143 * t814 / 0.4e1 + t18 * t59 * t1868 / 0.4e1 + t786 * t81 / 0.4e1 + 0.3e1 / 0.4e1 * t270 * t220 + 0.3e1 / 0.4e1 * t89 * t663 + t18 * t1878 * t80 / 0.4e1 - 0.3e1 / 0.2e1 * t196 * t290 - 0.3e1 / 0.2e1 * t89 * t677 - 0.3e1 / 0.2e1 * t48 * t833 - 0.3e1 / 0.2e1 * t18 * t1279 * t289 + 0.3e1 / 0.2e1 * t48 * t837 + 0.3e1 / 0.2e1 * t18 * t925 * t836;
  t1919 = -0.3e1 / 0.4e1 * t1585 - 0.3e1 / 0.2e1 * t1588 - 0.3e1 / 0.4e1 * t1592 - 0.3e1 / 0.4e1 * t1595 - 0.3e1 / 0.2e1 * t1598 - 0.3e1 / 0.4e1 * t1600 + 0.9e1 / 0.2e1 * t231 * t593 * t318 * t80 - 0.3e1 / 0.2e1 * t270 * t22 * t233 - 0.3e1 * t89 * t92 * t233 - 0.3e1 / 0.2e1 * t735 * t746 - 0.3e1 / 0.2e1 * t18 * t282 * t233;
  t1922 = t148 * t814;
  t1951 = -0.3e1 / 0.2e1 * t737 * t746 - t231 * t1922 * t80 / 0.2e1 + 0.9e1 / 0.2e1 * t735 * t740 - 0.3e1 * t735 * t743 + 0.9e1 / 0.2e1 * t737 * t740 - 0.3e1 * t737 * t743 - 0.6e1 * t231 * t930 * t836 * t80 + 0.9e1 / 0.2e1 * t231 * t739 * t259 - 0.3e1 / 0.2e1 * t597 * t840 - 0.3e1 / 0.2e1 * t599 * t840 - 0.3e1 / 0.2e1 * t231 * t601 * t318 - 0.3e1 / 0.2e1 * t231 * t232 * t731;
  t1955 = my_piecewise3(t3, 0, t1683 + t1709 + t1733 + t1755 + t1785 + t1896 + t1919 + t1951);
  tv4rho43 = t4 * t1955 + 0.3e1 * t752 + t845;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1962 = my_piecewise5(t8, 0, t12, 0, 0.24e2 * t360 + 0.24e2 * t875);
  t1963 = t1962 * t4;
  t1972 = my_piecewise5(t12, 0, t8, 0, -0.24e2 * t360 + 0.24e2 * t886);
  t1987 = -0.6e1 * t1706 + 0.6e1 * t1716 - t1963 * t40 / 0.4e1 - t786 * t93 - 0.3e1 / 0.2e1 * t270 * t283 - t89 * t828 - t18 * t1972 * t39 / 0.4e1 - 0.6e1 * t1748 - 0.6e1 * t1750 + t1753 + 0.3e1 * t1758 + 0.3e1 * t1760 + 0.3e1 * t1762 + 0.6e1 * t1764 + 0.3e1 * t1766 - 0.3e1 * t1769 - t1772 - t1775 - 0.3e1 * t1778 - 0.3e1 * t270 * t290;
  t1998 = t289 * t289;
  t2002 = t318 * t318;
  t2035 = t311 * t311;
  t2038 = t101 * t805;
  t2041 = t296 * t296;
  t2047 = t300 * t300;
  t2057 = t303 * t303;
  t2063 = t308 * t308;
  t2074 = -0.4e2 / 0.81e2 * t967 * t2041 + 0.1e2 / 0.9e1 * t352 * t296 * t300 - t160 * t2047 / 0.3e1 - 0.4e1 / 0.9e1 * t160 * t95 * t788 + t63 * (t1963 + 0.4e1 * t785) / 0.6e1 - 0.4e2 / 0.81e2 * t988 * t2057 + 0.1e2 / 0.9e1 * t374 * t303 * t308 - t170 * t2063 / 0.3e1 - 0.4e1 / 0.9e1 * t170 * t98 * t802 + t68 * (t1972 * t4 + 0.4e1 * t799) / 0.6e1;
  t2077 = t293 * t293;
  t2093 = -0.6e1 * t89 * t833 - 0.3e1 * t18 * t1560 * t289 + 0.6e1 * t89 * t837 + 0.6e1 * t18 * t1287 * t836 - 0.6e1 * t18 * t931 * t1998 - 0.3e1 / 0.2e1 * t18 * t149 * t2002 + t786 * t107 + 0.3e1 * t270 * t286 + 0.3e1 / 0.2e1 * t270 * t319 + 0.3e1 * t89 * t765 + 0.3e1 * t89 * t768 + t89 * t815 + t18 * t1878 * t106 + 0.3e1 / 0.2e1 * t18 * t662 * t318 + t18 * t219 * t814 - 0.6e1 * t735 * t840 - 0.6e1 * t737 * t840 - 0.2e1 * t231 * t1922 * t106 + 0.9e1 * t231 * t739 * t318 + t18 * t59 * (0.72e3 * t393 * t293 * t311 + 0.36e3 * t1009 * t2077 - 0.18e2 * t154 * t2035 - 0.24e2 * t154 * t2038 - 0.36e2 * t1789 * t311 + 0.9e2 * t182 * t2035 + 0.12e3 * t182 * t2038 - 0.3e1 * t60 * t2074 + 0.6e1 * t77 * t2074) / 0.4e1;
  t2095 = my_piecewise3(t3, 0, t1987 + t2093);
  tv4rho44 = t4 * t2095 + 0.4e1 * t845;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

}

#endif

