/*
 * $Id: cap_proc.c,v 1.3 1997/05/04 05:35:46 morgan Exp $
 *
 * Copyright (c) 1997 Andrew G Morgan <morgan@parc.power.net>
 *
 * See end of file for Log.
 *
 * This file deals with setting capabilities on processes.
 */

#include "libcap.h"

cap_t cap_get_proc(void)
{
    cap_t result;

    /* allocate a new capability set */
    result = cap_init();
    if (result) {
	_cap_debug("getting current process' capabilities");

	/* fill the capability sets via a system call */
	if (_getproccap(sizeof(struct __cap_s),
			&result->set[CAP_INHERITABLE],
			&result->set[CAP_PERMITTED],
			&result->set[CAP_EFFECTIVE] ))
	    cap_free(&result);
    }

    return result;
}

int cap_set_proc(cap_t cap_d)
{
    if (good_cap_t(cap_d)) {
	_cap_debug("setting current process' capabilities");

	/* fill the capability sets via a system call */
	if (_setproccap(sizeof(struct __cap_s),
			&cap_d->set[CAP_INHERITABLE],
			&cap_d->set[CAP_PERMITTED],
			&cap_d->set[CAP_EFFECTIVE] )) {
	    _cap_debug("failed: %s", strerror(errno));
	}
    } else
	errno = EINVAL;

    return (errno ? -1:0);
}

/*
 * $Log: cap_proc.c,v $
 * Revision 1.3  1997/05/04 05:35:46  morgan
 * fixed errno setting. syscalls do this part
 *
 * Revision 1.2  1997/04/28 00:57:11  morgan
 * fixes and zefram's patches
 *
 * Revision 1.1  1997/04/21 04:32:52  morgan
 * Initial revision
 *
 */
