Summary: Secure Shell - encrypts network communications.
Name: ssh
Version: 1.2.21
#
# Note, this spec file will do the right thing if you build the RPM for
# non-us use when you replace the 'us' on the next line with 'i'.
#
Release: PAM2us
URL: http://www.cs.hut.fi/ssh/
Vendor: Jan "Yenya" Kasprzak <kas@fi.muni.cz>
Packager: Jan "Yenya" Kasprzak <kas@fi.muni.cz>
Source0: ftp://ftp.cs.hut.fi/pub/ssh/ssh-1.2.21.tar.gz
Source1: ftp://ftp.funet.fi/pub/crypt/mirrors/idea.sec.dsi.unimi.it/math/rsaref20.tar.Z
Source2: sshd.init
Source3: ssh.pam
Patch: ssh-1.2.21-PAM-et-al-2.patch
Patch1: ssh-1.2.20-alpha-rsaref.patch
Copyright: See COPYING file in documentation
Group: Networking/Utilities
BuildRoot: /tmp/ssh-root
Requires: pam >= 0.64

%description
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands on a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

This package includes the ssh server and extra documentation.

The 'i' form of the package is compiled with internal RSAREF and is
recommended for use outside the USA, the 'us' form is compiled the
external RSAREF library and should be used within the USA.

%package clients
Summary: Clients for connecting to Secure Shell servers
Group: Networking/Utilities
%description clients
This package includes the clients necessary to make encrypted connections
to SSH servers.

%changelog

* Thu Feb 19 1998 Andrew <morgan@linux.kernel.org>

- added support for plug-in authentication agents (PAM-client extensions) &
  enhanced PAM support (collaboration with Andrey V. Savochkin <saw@msu.ru>)
- better integration of PAM environment variables
- More flexible spec file taking into account i or us suffix of the release

* Fri Dec  5 1997 Jan "Yenya" Kasprzak <kas@fi.muni.cz>

- Upgraded to 1.2.21.

* Fri Jul 04 1997 Martin Ebourne <mje92@ecs.soton.ac.uk>

- Added 'echo' into sshd.init so it formats the output correctly
- Added patch for RSAREF on Alpha from Richard Bullington <rbulling@obscure.org>

%prep
%setup
echo Patching to use PAM and test for installed zlib

%patch -p1 -b .pre-pam

mkdir rsaref2
tar -C rsaref2 -xzf $RPM_SOURCE_DIR/rsaref20.tar.Z

if [ -e rsaref2/rsaref.tar ]; then
	cd rsaref2
	tar xf rsaref.tar
	cd ..
%ifarch alpha
	echo Patching RSAREF for 64 bitness
%patch1 -p1 -b .alpha
%endif
fi

autoheader
autoconf

%build
#
# Decide if we need to use the RSAREF lib or not...
#
case %{PACKAGE_RELEASE} in
*i)
	echo "Not using RSAREF"
	USE_RSAREF=
	;;
*us)
	echo "Will use RSAREF"
	USE_RSAREF=--with-rsaref
	;;
*)
	echo "Please choose a release for 'us' or 'i'nternational use"
	exit 1
	;;
esac
CFLAGS="$RPM_OPT_FLAGS -g" ./configure --prefix=/usr --with-etcdir=/etc/ssh --with-libwrap $USE_RSAREF --with-daemonpam --with-clientpam --with-brokenpamhack
##
# Hack to use my debugging library
##
#if [ -f /lib/libpamd.so ]; then
#	patch -p1 -b .pre-hack < /usr/src/redhat/SOURCES/ssh-pam-debug.patch
#fi
# End of hack.
##
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/etc/pam.d
make install_prefix=$RPM_BUILD_ROOT install
touch $RPM_BUILD_ROOT/etc/ssh/ssh_host_key
install -m644 $RPM_SOURCE_DIR/ssh.pam $RPM_BUILD_ROOT/etc/pam.d/ssh
install -m755 $RPM_SOURCE_DIR/sshd.init $RPM_BUILD_ROOT/etc/rc.d/init.d/sshd.init
for I in 3 5; do
	DIR=$RPM_BUILD_ROOT/etc/rc.d/rc$I.d
	mkdir -p $DIR
	ln -s ../init.d/sshd.init $DIR/S55sshd
done

for I in 0 1 2 6; do
	DIR=$RPM_BUILD_ROOT/etc/rc.d/rc$I.d
	mkdir -p $DIR
	ln -s ../init.d/sshd.init $DIR/K45sshd
done
install -m600 host_config.sample $RPM_BUILD_ROOT/etc/ssh/ssh_config
sed 's:_ETCDIR_:/etc/ssh:' < server_config.sample > sshd_config
install -m600 sshd_config $RPM_BUILD_ROOT/etc/ssh/sshd_config
# XXX
#strip $RPM_BUILD_ROOT/usr/sbin/* $RPM_BUILD_ROOT/usr/bin/* ||:

%clean
rm -rf $RPM_BUILD_ROOT

%pre
#
# if this machine is already running sshd, we better take it down now.
#
if [ -f /var/lock/subsys/sshd -a -f /etc/rc.d/init.d/sshd.init ]; then
	/etc/rc.d/init.d/sshd.init stop
	touch /var/lock/subsys/sshd-needed
fi

%post
#
# make a key for this host
#
if [ ! -f /etc/ssh/ssh_host_key -o ! -s /etc/ssh/ssh_host_key ]; then
	# Pre 1.2.20-1 RPM config was directly in /etc
	if [ -f /etc/ssh_host_key -a -s /etc/ssh_host_key ]; then
		mv /etc/ssh_host_key /etc/ssh_host_key.pub /etc/ssh/
		mv /etc/ssh_known_hosts /etc/ssh/ >/dev/null 2>&1 ||:
		mv /etc/ssh_random_seed /etc/ssh/ >/dev/null 2>&1 ||:
	else
        	/usr/bin/ssh-keygen -b 1024 -f /etc/ssh/ssh_host_key -N ''
	fi
fi
#
# Restart daemon (if it was running when we began to upgrade)
#
if [ -f /var/lock/subsys/sshd-needed ]; then
	rm /var/lock/subsys/sshd-needed
	/etc/rc.d/init.d/sshd.init start
fi

%files
%doc COPYING ChangeLog INSTALL README README.CIPHERS README.SECURERPC
%doc README.SECURID README.TIS README.PAM RFC RFC.nroff TODO
/usr/bin/ssh-keygen
/usr/man/man1/ssh-keygen.1
/usr/bin/make-ssh-known-hosts
/usr/sbin/sshd
/usr/man/man8/sshd.8
/usr/man/man1/make-ssh-known-hosts.1
%config /etc/ssh/sshd_config
%config /etc/pam.d/ssh
%config /etc/rc.d/init.d/sshd.init
/etc/rc.d/rc3.d/S55sshd
/etc/rc.d/rc5.d/S55sshd
/etc/rc.d/rc0.d/K45sshd
/etc/rc.d/rc1.d/K45sshd
/etc/rc.d/rc2.d/K45sshd
/etc/rc.d/rc6.d/K45sshd

%files clients
%doc COPYING
%config /etc/ssh/ssh_config
/usr/bin/ssh
/usr/bin/slogin
/usr/bin/ssh-agent
/usr/bin/ssh-add
/usr/bin/scp
/usr/bin/ssh-askpass
/usr/bin/ssh-keygen
/usr/man/man1/ssh-keygen.1
/usr/man/man1/ssh-agent.1
/usr/man/man1/ssh-add.1
/usr/man/man1/scp.1
/usr/man/man1/slogin.1
/usr/man/man1/ssh.1
