# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1NodeStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'capacity': 'object',
            'allocatable': 'object',
            'phase': 'str',
            'conditions': 'list[V1NodeCondition]',
            'addresses': 'list[V1NodeAddress]',
            'daemon_endpoints': 'V1NodeDaemonEndpoints',
            'node_info': 'V1NodeSystemInfo',
            'images': 'list[V1ContainerImage]'
        }

        self.attribute_map = {
            'capacity': 'capacity',
            'allocatable': 'allocatable',
            'phase': 'phase',
            'conditions': 'conditions',
            'addresses': 'addresses',
            'daemon_endpoints': 'daemonEndpoints',
            'node_info': 'nodeInfo',
            'images': 'images'
        }

        self._capacity = None
        self._allocatable = None
        self._phase = None
        self._conditions = None
        self._addresses = None
        self._daemon_endpoints = None
        self._node_info = None
        self._images = None

    @property
    def capacity(self):
        """
        Gets the capacity of this V1NodeStatus.
        Capacity represents the total resources of a node. More info: http://releases.k8s.io/release-1.2/docs/user-guide/persistent-volumes.md#capacity for more details.

        :return: The capacity of this V1NodeStatus.
        :rtype: object
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity):
        """
        Sets the capacity of this V1NodeStatus.
        Capacity represents the total resources of a node. More info: http://releases.k8s.io/release-1.2/docs/user-guide/persistent-volumes.md#capacity for more details.

        :param capacity: The capacity of this V1NodeStatus.
        :type: object
        """
        self._capacity = capacity

    @property
    def allocatable(self):
        """
        Gets the allocatable of this V1NodeStatus.
        Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.

        :return: The allocatable of this V1NodeStatus.
        :rtype: object
        """
        return self._allocatable

    @allocatable.setter
    def allocatable(self, allocatable):
        """
        Sets the allocatable of this V1NodeStatus.
        Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.

        :param allocatable: The allocatable of this V1NodeStatus.
        :type: object
        """
        self._allocatable = allocatable

    @property
    def phase(self):
        """
        Gets the phase of this V1NodeStatus.
        NodePhase is the recently observed lifecycle phase of the node. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-phase

        :return: The phase of this V1NodeStatus.
        :rtype: str
        """
        return self._phase

    @phase.setter
    def phase(self, phase):
        """
        Sets the phase of this V1NodeStatus.
        NodePhase is the recently observed lifecycle phase of the node. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-phase

        :param phase: The phase of this V1NodeStatus.
        :type: str
        """
        self._phase = phase

    @property
    def conditions(self):
        """
        Gets the conditions of this V1NodeStatus.
        Conditions is an array of current observed node conditions. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-condition

        :return: The conditions of this V1NodeStatus.
        :rtype: list[V1NodeCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this V1NodeStatus.
        Conditions is an array of current observed node conditions. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-condition

        :param conditions: The conditions of this V1NodeStatus.
        :type: list[V1NodeCondition]
        """
        self._conditions = conditions

    @property
    def addresses(self):
        """
        Gets the addresses of this V1NodeStatus.
        List of addresses reachable to the node. Queried from cloud provider, if available. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-addresses

        :return: The addresses of this V1NodeStatus.
        :rtype: list[V1NodeAddress]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses):
        """
        Sets the addresses of this V1NodeStatus.
        List of addresses reachable to the node. Queried from cloud provider, if available. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-addresses

        :param addresses: The addresses of this V1NodeStatus.
        :type: list[V1NodeAddress]
        """
        self._addresses = addresses

    @property
    def daemon_endpoints(self):
        """
        Gets the daemon_endpoints of this V1NodeStatus.
        Endpoints of daemons running on the Node.

        :return: The daemon_endpoints of this V1NodeStatus.
        :rtype: V1NodeDaemonEndpoints
        """
        return self._daemon_endpoints

    @daemon_endpoints.setter
    def daemon_endpoints(self, daemon_endpoints):
        """
        Sets the daemon_endpoints of this V1NodeStatus.
        Endpoints of daemons running on the Node.

        :param daemon_endpoints: The daemon_endpoints of this V1NodeStatus.
        :type: V1NodeDaemonEndpoints
        """
        self._daemon_endpoints = daemon_endpoints

    @property
    def node_info(self):
        """
        Gets the node_info of this V1NodeStatus.
        Set of ids/uuids to uniquely identify the node. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-info

        :return: The node_info of this V1NodeStatus.
        :rtype: V1NodeSystemInfo
        """
        return self._node_info

    @node_info.setter
    def node_info(self, node_info):
        """
        Sets the node_info of this V1NodeStatus.
        Set of ids/uuids to uniquely identify the node. More info: http://releases.k8s.io/release-1.2/docs/admin/node.md#node-info

        :param node_info: The node_info of this V1NodeStatus.
        :type: V1NodeSystemInfo
        """
        self._node_info = node_info

    @property
    def images(self):
        """
        Gets the images of this V1NodeStatus.
        List of container images on this node

        :return: The images of this V1NodeStatus.
        :rtype: list[V1ContainerImage]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this V1NodeStatus.
        List of container images on this node

        :param images: The images of this V1NodeStatus.
        :type: list[V1ContainerImage]
        """
        self._images = images

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
