// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +faminmax -O3 -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature +neon -target-feature +faminmax -S -O3 -Werror -Wall -o /dev/null %s

// REQUIRES: aarch64-registered-target

#include <arm_neon.h>

// CHECK-LABEL: define dso_local <4 x half> @test_vamin_f16(
// CHECK-SAME: <4 x half> noundef [[VN:%.*]], <4 x half> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMIN2_I:%.*]] = tail call <4 x half> @llvm.aarch64.neon.famin.v4f16(<4 x half> [[VN]], <4 x half> [[VM]])
// CHECK-NEXT:    ret <4 x half> [[FAMIN2_I]]
//
float16x4_t test_vamin_f16(float16x4_t vn, float16x4_t vm) {
  return vamin_f16(vn, vm);
}

// CHECK-LABEL: define dso_local <8 x half> @test_vaminq_f16(
// CHECK-SAME: <8 x half> noundef [[VN:%.*]], <8 x half> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMIN2_I:%.*]] = tail call <8 x half> @llvm.aarch64.neon.famin.v8f16(<8 x half> [[VN]], <8 x half> [[VM]])
// CHECK-NEXT:    ret <8 x half> [[FAMIN2_I]]
//
float16x8_t test_vaminq_f16(float16x8_t vn, float16x8_t vm) {
  return vaminq_f16(vn, vm);
}

// CHECK-LABEL: define dso_local <2 x float> @test_vamin_f32(
// CHECK-SAME: <2 x float> noundef [[VN:%.*]], <2 x float> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMIN2_I:%.*]] = tail call <2 x float> @llvm.aarch64.neon.famin.v2f32(<2 x float> [[VN]], <2 x float> [[VM]])
// CHECK-NEXT:    ret <2 x float> [[FAMIN2_I]]
//
float32x2_t test_vamin_f32(float32x2_t vn, float32x2_t vm) {
  return vamin_f32(vn, vm);
}

// CHECK-LABEL: define dso_local <4 x float> @test_vaminq_f32(
// CHECK-SAME: <4 x float> noundef [[VN:%.*]], <4 x float> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMIN2_I:%.*]] = tail call <4 x float> @llvm.aarch64.neon.famin.v4f32(<4 x float> [[VN]], <4 x float> [[VM]])
// CHECK-NEXT:    ret <4 x float> [[FAMIN2_I]]
//
float32x4_t test_vaminq_f32(float32x4_t vn, float32x4_t vm) {
  return vaminq_f32(vn, vm);
}

// CHECK-LABEL: define dso_local <2 x double> @test_vaminq_f64(
// CHECK-SAME: <2 x double> noundef [[VN:%.*]], <2 x double> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMIN2_I:%.*]] = tail call <2 x double> @llvm.aarch64.neon.famin.v2f64(<2 x double> [[VN]], <2 x double> [[VM]])
// CHECK-NEXT:    ret <2 x double> [[FAMIN2_I]]
//
float64x2_t test_vaminq_f64(float64x2_t vn, float64x2_t vm) {
  return vaminq_f64(vn, vm);
}

// CHECK-LABEL: define dso_local <4 x half> @test_vamax_f16(
// CHECK-SAME: <4 x half> noundef [[VN:%.*]], <4 x half> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMAX2_I:%.*]] = tail call <4 x half> @llvm.aarch64.neon.famax.v4f16(<4 x half> [[VN]], <4 x half> [[VM]])
// CHECK-NEXT:    ret <4 x half> [[FAMAX2_I]]
//
float16x4_t test_vamax_f16(float16x4_t vn, float16x4_t vm) {
  return vamax_f16(vn, vm);
}

// CHECK-LABEL: define dso_local <8 x half> @test_vamaxq_f16(
// CHECK-SAME: <8 x half> noundef [[VN:%.*]], <8 x half> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMAX2_I:%.*]] = tail call <8 x half> @llvm.aarch64.neon.famax.v8f16(<8 x half> [[VN]], <8 x half> [[VM]])
// CHECK-NEXT:    ret <8 x half> [[FAMAX2_I]]
//
float16x8_t test_vamaxq_f16(float16x8_t vn, float16x8_t vm) {
  return vamaxq_f16(vn, vm);
}

// CHECK-LABEL: define dso_local <2 x float> @test_vamax_f32(
// CHECK-SAME: <2 x float> noundef [[VN:%.*]], <2 x float> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMAX2_I:%.*]] = tail call <2 x float> @llvm.aarch64.neon.famax.v2f32(<2 x float> [[VN]], <2 x float> [[VM]])
// CHECK-NEXT:    ret <2 x float> [[FAMAX2_I]]
//
float32x2_t test_vamax_f32(float32x2_t vn, float32x2_t vm) {
  return vamax_f32(vn, vm);
}

// CHECK-LABEL: define dso_local <4 x float> @test_vamaxq_f32(
// CHECK-SAME: <4 x float> noundef [[VN:%.*]], <4 x float> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMAX2_I:%.*]] = tail call <4 x float> @llvm.aarch64.neon.famax.v4f32(<4 x float> [[VN]], <4 x float> [[VM]])
// CHECK-NEXT:    ret <4 x float> [[FAMAX2_I]]
//
float32x4_t test_vamaxq_f32(float32x4_t vn, float32x4_t vm) {
  return vamaxq_f32(vn, vm);
}

// CHECK-LABEL: define dso_local <2 x double> @test_vamaxq_f64(
// CHECK-SAME: <2 x double> noundef [[VN:%.*]], <2 x double> noundef [[VM:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[FAMAX2_I:%.*]] = tail call <2 x double> @llvm.aarch64.neon.famax.v2f64(<2 x double> [[VN]], <2 x double> [[VM]])
// CHECK-NEXT:    ret <2 x double> [[FAMAX2_I]]
//
float64x2_t test_vamaxq_f64(float64x2_t vn, float64x2_t vm) {
  return vamaxq_f64(vn, vm);
}
