      SUBROUTINE SCO_schedule()
C*****
C               *****************************
C               * OASIS ROUTINE  -  LEVEL 1 *
C               * -------------     ------- *
C               *****************************
C
C**** *SCO_schedule*  
C
C     Purpose:
C     -------
C     The routine groups fields into boundles considering the dependencies
C     among fields introduced by the use of 'sequencing index'(SEQ) and
C     BLASNEW transformation. The bundles are afterwards distributed among
C     processes.
C
C     Interface:
C     ---------
C       *CALL*  *SCO_schedule()
C
C     Called from:
C     -----------
C     driver
C
C     History:
C     -------
C       Version   Programmer         Date        Description
C       -------   ----------         ----        -----------  
C       3.3       I. Epicoco(CMCC)   09/11/16    created
C
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C* ---------------------------- Modules used ----------------------------
C
#if defined use_oasis_cmcc_para
      USE mod_analysis
      USE mod_string
      USE mod_parameter
      USE mod_experiment
      USE mod_comclim
C* ---------------------------- Include files ---------------------------
C
#include <mpif.h>
C* ---------------------------- Argument declarations -------------------------------
C
C* ---------------------------- Local declarations ----------------------
C
      INTEGER (kind=ip_intwp_p)  adj(ig_total_nfield,ig_total_nfield)
      INTEGER (kind=ip_intwp_p)  sco_count(ig_total_nfield)
      INTEGER (kind=ip_intwp_p)  sco_flag(ig_total_nfield)
      INTEGER (kind=ip_intwp_p)  bun_count(ig_total_nfield)
      INTEGER (kind=ip_intwp_p)  sco_if, jc, jb, sco_i, sco_j
      INTEGER (kind=ip_intwp_p)  sco_k, sco_l, bun_num, sco_seq, sco_idx
      LOGICAL add_flag
      INTEGER(kind=ip_intwp_p), DIMENSION(:,:), ALLOCATABLE :: bun_mat
      INTEGER(kind=ip_intwp_p), DIMENSION(:,:), ALLOCATABLE :: bun_array
      INTEGER(kind=ip_intwp_p), DIMENSION(:), ALLOCATABLE :: bun_work
      INTEGER(kind=ip_intwp_p), DIMENSION(:,:), ALLOCATABLE :: sched_mat
      INTEGER(kind=ip_intwp_p), DIMENSION(:), ALLOCATABLE :: sched_wei
      INTEGER(kind=ip_intwp_p), DIMENSION(:), ALLOCATABLE :: sched_count
      INTEGER(kind=ip_intwp_p) min_proc, temp, jmax, ierr
C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C
c
      adj(:,:) = -1
      sco_count(:) = 0
      bun_count(:) = 0
      sco_flag(:) = 0

      ALLOCATE(sco_myfield(ig_total_nfield))

c     Definition of adjacence matrix
      DO 100 sco_if = 1, ig_total_nfield
        IF (lg_state(sco_if)) THEN
          DO 150 jc = 1, nbnfld(ig_number_field(sco_if))
              IF ((cbnfld(jc,ig_number_field(sco_if)) .NE. 'CONSTANT')
     $        .AND. (cbnfld(jc,ig_number_field(sco_if)) .NE. ' ')) THEN
                  DO 160 jb = sco_if-1, 1, -1 
C* Check field names input list
C
                      IF (cbnfld(jc,ig_number_field(sco_if)) .EQ.
     $                      cnamout(ig_number_field(jb))) THEN
                            sco_count(sco_if) = sco_count(sco_if) + 1
                            adj(sco_if, jc) = jb
                      ENDIF
 160              CONTINUE
              ENDIF
 150      CONTINUE
        ENDIF
 100  CONTINUE

      bun_count = sco_count
c     Create bundles

      DO 200 sco_i = 1, ig_total_nfield 
        IF (lg_state(sco_i)) THEN
         DO 210 sco_j = 1, sco_count(sco_i)
             sco_flag(adj(sco_i, sco_j)) = 1
             DO 220 sco_k = 1, bun_count(adj(sco_i, sco_j))
               add_flag = .TRUE.
               DO 230 sco_l = 1, bun_count(sco_i)
                  IF (adj(adj(sco_i, sco_j),sco_k) 
     $                .EQ. adj(sco_i, sco_l)) THEN
                     add_flag = .FALSE.
                  END IF
 230           CONTINUE
               IF (add_flag) THEN
                  adj(sco_i, bun_count(sco_i) + 1) = 
     $            adj(adj(sco_i, sco_j),sco_k)
                  bun_count(sco_i) = bun_count(sco_i) + 1
               END IF
 220         CONTINUE
 210     CONTINUE
        ENDIF
 200  CONTINUE

c     Create the bundle-weight-seq matrix
      bun_num = 0
      DO 300 sco_i = 1, ig_total_nfield
        IF (lg_state(sco_i)) THEN
         IF (sco_flag(sco_i) .EQ. 0) THEN
            bun_num = bun_num + 1
         END IF
        END IF
 300  CONTINUE
      ALLOCATE(bun_array(bun_num,nmseq + 1))
      bun_array(:,:) = 0

      sco_idx = 0
      DO 320 sco_i = 1, ig_total_nfield
        IF (lg_state(sco_i)) THEN
        IF (sco_flag(sco_i) .EQ. 0) THEN
          sco_idx = sco_idx + 1
          bun_array(sco_idx, 1) = sco_i
          DO 310 sco_seq = 1, nmseq
              DO 330 sco_j = 1, bun_count(sco_i)
                IF (ig_number_field(adj(sco_i,sco_j)) .NE. 0) THEN
                  IF (nseqn(ig_number_field(adj(sco_i,sco_j))) 
     $               .EQ. sco_seq) THEN
                     bun_array(sco_idx,1 + sco_seq)=
     $               bun_array(sco_idx,1 + sco_seq) + 1
                  END IF
                END IF
 330          CONTINUE
              IF (ig_number_field(sco_i) .NE. 0) THEN
              IF (nseqn(ig_number_field(sco_i)) .EQ. sco_seq) THEN
                  bun_array(sco_idx,1 + sco_seq)=
     $            bun_array(sco_idx,1 + sco_seq) + 1
              END IF
              END IF
 310      CONTINUE
        END IF
        END IF
 320  CONTINUE

      ALLOCATE(bun_mat(bun_num, nmseq))
      ALLOCATE(bun_work(bun_num))
      bun_mat(:,:) = 0
      DO 400 sco_seq = nmseq, 1, -1
         sco_idx = 1
         bun_work=bun_array(:,sco_seq + 1)
         DO 410 sco_i = 1, bun_num
           max_wei = 0
           max_bun = -1
           DO 420 sco_j = 1, bun_num
              IF (bun_work(sco_j) .GT. max_wei) THEN
                 max_wei = bun_work(sco_j)
                 max_bun = sco_j
              END IF
 420       CONTINUE
           IF (max_bun .NE. -1) THEN
              bun_mat(sco_idx, sco_seq) = max_bun
              sco_idx = sco_idx + 1
              bun_work(max_bun) = 0
              IF (sco_seq .GT. 1) THEN
                 bun_array(max_bun, 2:sco_seq) = 0
              END IF
           END IF
 410     CONTINUE
 400  CONTINUE

c     Create scheduling matrix
      ALLOCATE(sched_mat(coupler_size, bun_num))
      ALLOCATE(sched_wei(coupler_size))
      ALLOCATE(sched_count(coupler_size))
      sched_mat(:,:) = -1
      sched_count(:) = 0
      DO 500 sco_seq = nmseq, 1, -1
         sched_wei(:) = 0
         DO 510 sco_j = 1, bun_num
           IF (bun_mat(sco_j,sco_seq) .GT. 0) THEN
                 min_wei = sched_wei(1)
                 min_proc = 1
                 DO 520 sco_i = 2, coupler_size
                    IF(sched_wei(sco_i) .LT. min_wei) THEN
                       min_wei = sched_wei(sco_i)
                       min_proc = sco_i
                    END IF
  520            CONTINUE
                 sched_count(min_proc) = sched_count(min_proc) + 1
                 sched_mat(min_proc, sched_count(min_proc)) = 
     $                 bun_array(bun_mat(sco_j, sco_seq), 1)
                 sched_wei(min_proc)= sched_wei(min_proc)+
     $             bun_array(bun_mat(sco_j,sco_seq),sco_seq+1)
           END IF
 510     CONTINUE
 500  CONTINUE

c     Create scheduling field vector
      sco_myfield(:) = 0
      sco_num_myf = 0
      DO 600 sco_i = 1, sched_count(coupler_rank + 1)
          DO 610 sco_j = 1, bun_count(sched_mat(coupler_rank + 1,sco_i))
             sco_num_myf = sco_num_myf + 1
             sco_myfield(sco_num_myf) = 
     $        adj(sched_mat(coupler_rank + 1, sco_i), sco_j)
 610      CONTINUE
          sco_num_myf = sco_num_myf + 1
          sco_myfield(sco_num_myf) = sched_mat(coupler_rank + 1, sco_i)
 600  CONTINUE

c     Order myfield array
      jmax = sco_num_myf - 1
      DO 700 sco_i = 1, sco_num_myf - 1
         DO 710 sco_j = 1, jmax
           IF(sco_myfield(sco_j) .GT. sco_myfield(sco_j+1)) THEN
              temp = sco_myfield(sco_j)
              sco_myfield(sco_j) = sco_myfield(sco_j + 1)
              sco_myfield(sco_j + 1) = temp
           END IF
 710     CONTINUE
         jmax = jmax - 1
 700  CONTINUE

      DEALLOCATE(bun_mat)
      DEALLOCATE(bun_array)
      DEALLOCATE(bun_work)
      DEALLOCATE(sched_mat)
      DEALLOCATE(sched_wei)
      DEALLOCATE(sched_count)

#endif
      RETURN
      END
