'use strict';
var path = require('path');
module.exports = {
  target: 'web',
  resolve: {
    modules: ['/usr/lib/nodejs', '.'],
  },
  resolveLoader: {
    modules: ['/usr/lib/nodejs'],
  },
  output: {
    libraryTarget: 'umd'
  },
  module: { rules: [ {test: /\.js$/, loader: 'babel-loader', options: { presets: [ 'es2015' ], plugins: ['add-module-exports'] } }] },
  externals: {
    'd3-dispatch': {
      commonjs: 'd3-dispatch',
      commonjs2: 'd3-dispatch',
      amd: 'd3-dispatch',
      root: '_'
    },
    'd3-drag': {
      commonjs: 'd3-drag',
      commonjs2: 'd3-drag',
      amd: 'd3-drag',
      root: '_'
    },
    'd3-interpolate': {
      commonjs: 'd3-interpolate',
      commonjs2: 'd3-interpolate',
      amd: 'd3-interpolate',
      root: '_'
    },
    'd3-selection': {
      commonjs: 'd3-selection',
      commonjs2: 'd3-selection',
      amd: 'd3-selection',
      root: '_'
    },
    'd3-transition': {
      commonjs: 'd3-transition',
      commonjs2: 'd3-transition',
      amd: 'd3-transition',
      root: '_'
    }
  }
};
