/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class ColumnInfo
implements Formatable {
    public int action;
    public String name;
    public DataTypeDescriptor dataType;
    public DefaultInfo defaultInfo;
    public DataValueDescriptor defaultValue;
    public UUID newDefaultUUID;
    public UUID oldDefaultUUID;
    public long autoincStart;
    public long autoincInc;
    public static final int CREATE = 0;
    public static final int MODIFY_COLUMN_DEFAULT = 1;
    public static final int DROP = 2;
    public static final int MODIFY_COLUMN_TYPE = 3;
    public static final int MODIFY_COLUMN_CONSTRAINT = 4;
    public static final int MODIFY_COLUMN_CONSTRAINT_NOT_NULL = 5;

    public ColumnInfo() {
    }

    public ColumnInfo(String string, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, UUID uUID, UUID uUID2, int n, long l, long l2) {
        this.name = string;
        this.dataType = dataTypeDescriptor;
        this.defaultValue = dataValueDescriptor;
        this.defaultInfo = defaultInfo;
        this.newDefaultUUID = uUID;
        this.oldDefaultUUID = uUID2;
        this.action = n;
        this.autoincStart = l;
        this.autoincInc = l2;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.name = (String)formatableHashtable.get("name");
        this.dataType = (DataTypeDescriptor)formatableHashtable.get("dataType");
        this.defaultValue = (DataValueDescriptor)formatableHashtable.get("defaultValue");
        this.defaultInfo = (DefaultInfo)formatableHashtable.get("defaultInfo");
        this.newDefaultUUID = (UUID)formatableHashtable.get("newDefaultUUID");
        this.oldDefaultUUID = (UUID)formatableHashtable.get("oldDefaultUUID");
        this.action = formatableHashtable.getInt("action");
        if (formatableHashtable.get("autoincStart") != null) {
            this.autoincStart = formatableHashtable.getLong("autoincStart");
            this.autoincInc = formatableHashtable.getLong("autoincInc");
        } else {
            this.autoincStart = 0L;
            this.autoincInc = 0L;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("name", this.name);
        formatableHashtable.put("dataType", this.dataType);
        formatableHashtable.put("defaultValue", this.defaultValue);
        formatableHashtable.put("defaultInfo", this.defaultInfo);
        formatableHashtable.put("newDefaultUUID", this.newDefaultUUID);
        formatableHashtable.put("oldDefaultUUID", this.oldDefaultUUID);
        formatableHashtable.putInt("action", this.action);
        if (this.autoincInc != 0L) {
            formatableHashtable.putLong("autoincStart", this.autoincStart);
            formatableHashtable.putLong("autoincInc", this.autoincInc);
        }
        objectOutput.writeObject(formatableHashtable);
    }

    public int getTypeFormatId() {
        return 358;
    }

    public String toString() {
        return "";
    }
}

