/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

class HistogramHash {
    int capacity;
    int[] colors;
    int[] counts;
    int size;
    int hashsize;
    boolean packed = false;
    int[] newColors;
    int[] newCounts;

    public HistogramHash(int n) {
        this.capacity = n;
        this.hashsize = n * 4 / 3;
        this.colors = new int[this.hashsize];
        this.counts = new int[this.hashsize];
    }

    void init() {
        this.size = 0;
        this.packed = false;
        int n = 0;
        while (n < this.hashsize) {
            this.colors[n] = -1;
            this.counts[n] = 0;
            ++n;
        }
    }

    boolean insert(int n) {
        int n2 = this.hashCode(n);
        if (this.colors[n2] == -1) {
            this.colors[n2] = n;
            int n3 = n2;
            this.counts[n3] = this.counts[n3] + 1;
            ++this.size;
            return this.size <= this.capacity;
        }
        if (this.colors[n2] == n) {
            int n4 = n2;
            this.counts[n4] = this.counts[n4] + 1;
            return this.size <= this.capacity;
        }
        int n5 = n2 + 1;
        while (n5 != n2) {
            if (this.colors[n5 %= this.hashsize] == -1) {
                this.colors[n5] = n;
                int n6 = n5;
                this.counts[n6] = this.counts[n6] + 1;
                ++this.size;
                return this.size <= this.capacity;
            }
            if (this.colors[n5] == n) {
                int n7 = n5;
                this.counts[n7] = this.counts[n7] + 1;
                return this.size <= this.capacity;
            }
            ++n5;
        }
        return this.size <= this.capacity;
    }

    boolean isFull() {
        return this.size > this.capacity;
    }

    void put(int n, int n2) {
        int n3 = this.hashCode(n);
        if (this.colors[n3] == -1) {
            this.colors[n3] = n;
            this.counts[n3] = n2;
            ++this.size;
            return;
        }
        if (this.colors[n3] == n) {
            this.counts[n3] = n2;
            return;
        }
        int n4 = n3 + 1;
        while (n4 != n3) {
            if (this.colors[n4 %= this.hashsize] == -1) {
                this.colors[n4] = n;
                this.counts[n4] = n2;
                ++this.size;
                return;
            }
            if (this.colors[n4] == n) {
                this.counts[n4] = n2;
                return;
            }
            ++n4;
        }
    }

    int get(int n) {
        int n2 = this.hashCode(n);
        if (this.colors[n2] == n) {
            return this.counts[n2];
        }
        int n3 = n2 + 1;
        while (n3 != n2) {
            if (this.colors[n3 %= this.hashsize] == n) {
                return this.counts[n3];
            }
            ++n3;
        }
        return -1;
    }

    int[] getCounts() {
        if (!this.packed) {
            this.pack();
        }
        return this.newCounts;
    }

    int[] getColors() {
        if (!this.packed) {
            this.pack();
        }
        return this.newColors;
    }

    void pack() {
        this.newColors = new int[this.capacity];
        this.newCounts = new int[this.capacity];
        int n = 0;
        int n2 = 0;
        while (n < this.hashsize) {
            if (this.colors[n] != -1) {
                this.newColors[n2] = this.colors[n];
                this.newCounts[n2] = this.counts[n];
                ++n2;
            }
            ++n;
        }
        this.packed = true;
    }

    int hashCode(int n) {
        return ((n >> 16) * 33023 + (n >> 8 & 0xFF) * 30013 + (n & 0xFF) * 27011) % this.hashsize;
    }
}

