/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DataBufferProxy
implements Serializable {
    private transient DataBuffer dataBuffer;

    public DataBufferProxy(DataBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.dataBuffer.getDataType();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeObject(this.dataBuffer.getOffsets());
        objectOutputStream.writeInt(this.dataBuffer.getSize());
        Object object = null;
        switch (n) {
            case 0: {
                object = ((DataBufferByte)this.dataBuffer).getBankData();
                break;
            }
            case 2: {
                object = ((DataBufferShort)this.dataBuffer).getBankData();
                break;
            }
            case 1: {
                object = ((DataBufferUShort)this.dataBuffer).getBankData();
                break;
            }
            case 3: {
                object = ((DataBufferInt)this.dataBuffer).getBankData();
                break;
            }
            case 4: {
                object = DataBufferUtils.getBankDataFloat(this.dataBuffer);
                break;
            }
            case 5: {
                object = DataBufferUtils.getBankDataDouble(this.dataBuffer);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferProxy0"));
            }
        }
        objectOutputStream.writeObject(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = -1;
        int[] nArray = null;
        int n2 = -1;
        Object object = null;
        n = objectInputStream.readInt();
        nArray = (int[])objectInputStream.readObject();
        n2 = objectInputStream.readInt();
        object = objectInputStream.readObject();
        switch (n) {
            case 0: {
                this.dataBuffer = new DataBufferByte((byte[][])object, n2, nArray);
                break;
            }
            case 2: {
                this.dataBuffer = new DataBufferShort((short[][])object, n2, nArray);
                break;
            }
            case 1: {
                this.dataBuffer = new DataBufferUShort((short[][])object, n2, nArray);
                break;
            }
            case 3: {
                this.dataBuffer = new DataBufferInt((int[][])object, n2, nArray);
                break;
            }
            case 4: {
                this.dataBuffer = DataBufferUtils.createDataBufferFloat((float[][])object, n2, nArray);
                break;
            }
            case 5: {
                this.dataBuffer = DataBufferUtils.createDataBufferDouble((double[][])object, n2, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("DataBufferProxy0"));
            }
        }
    }
}

