package Net::Async::Spotify::Object::Track;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Generated::Track);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Track - Package representing Main Spotify Track Object

=head1 DESCRIPTION

Main module for an Autogenerated one L<Net::Async::Spotify::Object::Generated::Track>.
Will hold all extra functionality for Spotify Track Object

=head1 METHODS

=cut

sub to_human {
    my $self = shift;
    return join(' | ',
        $self->id,
        $self->name,
        join(' & ', map {$_->name} $self->artists->@*),
        $self->album->name,
        $self->popularity
    );
}

1;
