
package Net::Simplify::FieldError;


=head1 NAME

Net::Simplify::ApiException - Simplify Commerce field error class

=head1 SYNOPSIS

  use Net::Simplify;

  $Net::Simplify::public_key = 'YOUR PUBLIC KEY';
  $Net::Simplify::private_key = 'YOUR PRIVATE KEY';

  eval {
      my $payment = Net::Simplify::Payment->create(...);
  };
  if ($@) {
      if ($@->isa('Net::Simplify::BadRequestException')) {
          if ($@->has_field_errors) {
              foreach my $error ($@->field_errors) {
                  my $c = $error->code;
                  my $f = $error->field;
                  my $m = $error->message;
                  printf "Field error: %s - '%s' (%s)\n", $f, $m, $c;
              }
          }
      }
  }
 
=head1 DESCRIPTION

Represents a single error in an API request to create or update a domain object.

=head2 METHODS

=head3 field()

The name of the field with the error.

=head3 code()

The field error code.

=head3 message()

A textual description of the error.

=head3 stringify()

A string representation of the field error.

=head1 SEE ALSO

L<Net::Simplify>,
L<Net::Simplify::BadRequestException>,
L<http://www.simplify.com>

=head1 VERSION

1.0.1

=head1 LICENSE

Copyright (c) 2013, MasterCard International Incorporated
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are 
permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of 
conditions and the following disclaimer.
Redistributions in binary form must reproduce the above copyright notice, this list of 
conditions and the following disclaimer in the documentation and/or other materials 
provided with the distribution.
Neither the name of the MasterCard International Incorporated nor the names of its 
contributors may be used to endorse or promote products derived from this software 
without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER 
IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

=cut

use 5.006;
use strict;
use warnings FATAL => 'all';

use overload ('""' => 'stringify');

sub new {
    my ($class, $params) = @_;

    my $self = {};

    $self->{field} = $params->{field};
    $self->{code} = $params->{code};
    $self->{message} = $params->{message};

    bless $self, $class;
}

sub field {
    my ($self) = @_;

    $self->{field};
}

sub code {
    my ($self) = @_;

    $self->{code};
}
sub message {
    my ($self) = @_;

    $self->{message};
}

sub stringify {
    my ($self) = @_;

    my $code = $self->{code};
    my $field = $self->{field};
    my $message = $self->{message};

    qq|Field error: ${field} "${message}" (${code})\n|;
}


1;
