package Net::Amazon::EMR::EbsVolume;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'Device' => ( is => 'ro', 
                  isa => 'Str' );

has 'VolumeId' => ( is => 'ro', 
                    isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::EbsVolume

=head1 DESCRIPTION

Implements the EbsVolume data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_EbsVolume.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
