use Test::More;
use VAPID qw/all/;

ok(my ($pub, $priv) = generate_vapid_keys());

ok(validate_subject('mailto:thisusedtobeanemail@gmail.com'));
ok(validate_public_key($pub));
ok(validate_private_key($priv));
ok(validate_expiration(time + 60));

ok(my $header = generate_vapid_header(
	'https://fcm.googleapis.com/fcm/send/d2rLOOozIpQ:APA91bFe-zbw1MTmD_64V112CcqP-hxKOl0PRnvq2a2wVV84SBvc6acwWSMf7uPyX56fbe8Nba_wYHDtthL7hE7IBgoTexPD-aovf3gyUB_k0O_OkLkEpirRWVdHcvrSyXJvcxyjKu-I',
	'mailto:thisusedtobeanemail@gmail.com',
	$pub,
	$priv,
	time + 60
));

done_testing();
