# -*- perl -*-

# t/001_load.t - check module loading and create testing directory

use Test::More tests => 7;
use FindBin;
use Data::Dumper 'Dumper';
use Proc::ProcessTableLight 'process_table';

`$ENV{_} $FindBin::Bin/test.pl start`;
sleep(1);



ok(-e "$FindBin::Bin/test.pid", 'check exists pid file');
ok(-e "$FindBin::Bin/test.err", 'check exists err file');
ok(-e "$FindBin::Bin/test.log", 'check exists log file');

sub get_pid{
  open(F, "$FindBin::Bin/test.pid");
  my $pid=<F>;
  close(F);
  $pid=~s/[\r\n]//gs;
  
  return $pid;
}

sub find_process{
  my ($pid)=@_;
  
  my $process_table=process_table;
  my $is_process=0;
  foreach my $row (@{$process_table}){
    if ($row->{PID}==$pid && $row->{COMMAND}=~/test\.pl/){
      $is_process=1;
    }
  }
  
  return $is_process;
}

my $pid1=get_pid;
my $is_process1=find_process($pid1);
ok($is_process1==1, 'check exists process');





# restart

`$ENV{_} $FindBin::Bin/test.pl restart`;
sleep(1);

my $pid2=get_pid;
my $is_process2=find_process($pid2);
ok($is_process2==1, 'check exists process after restart 1');
ok($pid1 ne $pid2, 'check exists process after restart 2');


# stop

`$ENV{_} $FindBin::Bin/test.pl stop`;
sleep(1);

my $pid3=get_pid;
my $is_process3=find_process($pid3);
ok($is_process3==0, 'check not exists process after stop');


kill 'KILL', $pid3;