
use v6;

use Wkhtmltox::PDF;

sub MAIN() {
	# Print library version
	my $version = Wkhtmltox::PDF.version;
	say "wkhtmltopdf version: $version";

	# Create PDF output directory
	my $output-dir = "output".IO.mkdir;

	# Generate HTML
	my $html = render-html($version);

	# Create pdf object
	my $pdf = Wkhtmltox::PDF.new;

	# Get global settings
	say $pdf.get-global-setting("size.pageSize");
	say $pdf.get-global-setting("orientation");

	# Set global settings
	$pdf.set-global-setting("size.pageSize", "A4");
	$pdf.set-global-setting("orientation", "Landscape");

	# Convert HTML to PDF
	my $pdf-blob = $pdf.render($html);
	"$output-dir/output.pdf".IO.spurt($pdf-blob) if $pdf-blob.defined;

	$pdf.destroy;
}

sub render-html($version) {
	my $table-contents = '';
	for 1..10 -> $i {
		$table-contents ~= qq:to/HTML/;
		<tr>
			<td>{$i}</td>
			<td>{$i * $i}</td>
		</tr>
		HTML
	} 

	my $base-path = $*CWD ~ '/examples/';
	qq:to/HTML/;
		<!DOCTYPE html>
		<html>
		<head>
			<base href="$base-path">
			<link rel="stylesheet" type="text/css" href="$($base-path)assets/css/style.css" />
		</head>
		<body>
			<table class="table">
				<tr>
					<td style="width:20%">
						<img src="assets/images/camelia-logo.png" style="height: 100px;">
					</td>
					<td style="width:80%; text-align: center">
						<h1>Perl 6 rocks</h1>
					</td>
					<td style="width: 20%">
						<img src="assets/images/camelia-logo.png" style="height: 100px;">
					</td>
				</div>
			</div>
			<table class="table grid">
				<tr>
					<th>n</th>
					<th>n^2</th>
				</tr>
				$table-contents
			</table>
			<hr>
			<div style="float:right; text-align: right; width: 30%">
				Generated by libhtmltox v$version
			</div>
		</body>
		</html>
	HTML
}
