;;; xemacs-ucs.el --- sample setting of XEmacs-UCS

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, UCS-4, UTF-8, coding-system, MULE.

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Code:

;; Unicode 2.0
(load "ucs-irv")	;0000-007F; C0 Controls and Basic Latin
(load "ucs-latin-1")	;0080-00FF; C1 Controls and Latin-1 Supplement
(load "ucs-latin-a")	;0100-017F; Latin Extended-A 
(load "ucs-latin-b")	;0180-01FF; Latin Extended-B
(load "ucs-ipa")	;0250-02AF; IPA Extensions
(load "ucs-sp-modifier");02B0-02FF; Spacing Modifier Letters
(load "ucs-greek")	;0370-03FF; Greek
(load "ucs-cyril")	;0400-04FF; Cyrillic
(load "ucs-hebrew")	;0590-05FF; Hebrew
(load "ucs-latin-add")	;1E00-1EFF; Latin Extended Additional
(load "ucs-puncture")	;2000-206F; General Punctuation
(load "ucs-ss")		;2070-209F; Superscripts and Subscripts
(load "ucs-ll-sym")	;2100-214F; Letterlike Symbols
(load "ucs-num")	;2150-218F; Number Forms
(load "ucs-arrows")	;2190-21FF; Arrows
(load "ucs-math")	;2200-22FF; Mathematical Operators
(load "ucs-misc-tech")	;2300-23FF; Miscellaneous Technical
(load "ucs-ctrl-pic")	;2400-243F; Control Pictures
(load "ucs-enclosed")	;2460-24FF; Enclosed Alphanumerics
(load "ucs-box")	;2500-257F; Box Drawing
(load "ucs-block")	;2580-259F; Block Elements
(load "ucs-geometric")	;25A0-25FF; Geometric Shapes
(load "ucs-misc-sym")	;2600-26FF; Miscellaneous Symbols
(load "ucs-dingbats")	;2700-27BF; Dingbats
(load "ucs-cjk-sym")	;3000-303F; CJK Symbols and Punctuation
(load "ucs-hiragana")	;3040-309F; Hiragana
(load "ucs-katakana")	;30A0-30FF; Katakana
(load "ucs-bopomofo")	;3100-312F; Bopomofo
(load "ucs-hangul-compat");3130-318F; Hangul Compatibility Jamo
(load "ucs-enclosed-cjk");3200-32FF; Enclosed CJK Letters and Months
(load "ucs-cjk-compat")	;3300-33FF; CJK Compatibility
(load "ucs-cjk")	;4E00-9FA5; CJK Unified Ideographs
(load "ucs-hangul")	;AC00-D7A3; Hangul Syllables

(load "ucs-cjk-c-ideo")	;F900-FAFF; CJK Compatibility Ideographs
(load "ucs-small")	;FE50-FE6F; Small Form Variants
(load "ucs-hw-fw")	;FF00-FFEF; Halfwidth and Fullwidth Forms


;; Unicode 3.0 addition
(load "ucs-cjk-radicals");2F00-2FD5; KangXi radicals


(make-coding-system
 'iso-10646-ucs-4 'ucs-4
 "Coding-system of ISO 10646 UCS-4."
 '(mnemonic "UCS-4"))

(make-coding-system
 'utf-8 'utf-8
 "Coding-system of ISO 10646 UTF-8."
 '(mnemonic "UTF-8"))

(set-coding-category-system 'ucs-4 'iso-10646-ucs-4)
(set-coding-category-system 'utf-8 'utf-8)

(set-coding-priority-list
 '(iso-7 iso-8-2 iso-8-designate iso-8-1 iso-lock-shift
	 utf-8 ucs-4 shift-jis big5 no-conversion))

(provide 'xemacs-ucs)

;;; xemacs-ucs.el ends here
