;;; ucs-greek.el --- Greek table of UCS

;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;; Keywords: ISO/IEC 10646, Unicode, charset, MULE, Greek

;; This file is part of XEmacs-UCS.

;; XEmacs-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; XEmacs-UCS is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'ucs-util)

;; GREEK TONOS
(ucs-set-char #x0384 ?$(D"8(B) ; J90-D-2238
(ucs-set-char #x0384 ?-F) ; ISO-8859-7-B4-A

;; GREEK DIALYTIKA TONOS
(ucs-set-char #x0385 ?$(D"9(B) ; J90-D-2239
(ucs-set-char #x0385 ?-F) ; ISO-8859-7-B5-A

;; GREEK CAPITAL LETTER ALPHA WITH TONOS
(ucs-set-char #x0386 ?$(D&a(B) ; J90-D-2661
(ucs-set-char #x0386 ?-F) ; ISO-8859-7-B6-A

;; GREEK CAPITAL LETTER EPSILON WITH TONOS
(ucs-set-char #x0388 ?$(D&b(B) ; J90-D-2662
(ucs-set-char #x0388 ?-F) ; ISO-8859-7-B8-A

;; GREEK CAPITAL LETTER ETA WITH TONOS
(ucs-set-char #x0389 ?$(D&c(B) ; J90-D-2663
(ucs-set-char #x0389 ?-F) ; ISO-8859-7-B9-A

;; GREEK CAPITAL LETTER IOTA WITH TONOS
(ucs-set-char #x038A ?$(D&d(B) ; J90-D-2664
(ucs-set-char #x038A ?-F) ; ISO-8859-7-BA-A

;; GREEK CAPITAL LETTER OMICRON WITH TONOS
(ucs-set-char #x038C ?$(D&g(B) ; J90-D-2667
(ucs-set-char #x038C ?-F) ; ISO-8859-7-BC-A

;; GREEK CAPITAL LETTER UPSILON WITH TONOS
(ucs-set-char #x038E ?$(D&i(B) ; J90-D-2669
(ucs-set-char #x038E ?-F) ; ISO-8859-7-BE-A

;; GREEK CAPITAL LETTER OMEGA WITH TONOS
(ucs-set-char #x038F ?$(D&l(B) ; J90-D-266C
(ucs-set-char #x038F ?-F) ; ISO-8859-7-BF-A

;; GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
(ucs-set-char #x0390 ?$(D&v(B) ; J90-D-2676
(ucs-set-char #x0390 ?-F) ; ISO-8859-7-C0-A

;; GREEK CAPITAL LETTER ALPHA
(ucs-set-char #x0391 ?$(C%A(B) ; KS0-C-2541
(ucs-set-char #x0391 ?$(G$u(B) ; C01-G-2475
(ucs-set-char #x0391 ?$(@&!(B) ; J78-@-2621
(ucs-set-char #x0391 ?$(A&!(B) ; GB0-A-2621
(ucs-set-char #x0391 ?$(B&!(B) ; J83-B-2621
(ucs-set-char #x0391 ?-F) ; ISO-8859-7-C1-A

;; GREEK CAPITAL LETTER BETA
(ucs-set-char #x0392 ?$(C%B(B) ; KS0-C-2542
(ucs-set-char #x0392 ?$(G$v(B) ; C01-G-2476
(ucs-set-char #x0392 ?$(@&"(B) ; J78-@-2622
(ucs-set-char #x0392 ?$(A&"(B) ; GB0-A-2622
(ucs-set-char #x0392 ?$(B&"(B) ; J83-B-2622
(ucs-set-char #x0392 ?-F) ; ISO-8859-7-C2-A

;; GREEK CAPITAL LETTER GAMMA
(ucs-set-char #x0393 ?$(C%C(B) ; KS0-C-2543
(ucs-set-char #x0393 ?$(G$w(B) ; C01-G-2477
(ucs-set-char #x0393 ?$(@&#(B) ; J78-@-2623
(ucs-set-char #x0393 ?$(A&#(B) ; GB0-A-2623
(ucs-set-char #x0393 ?$(B&#(B) ; J83-B-2623
(ucs-set-char #x0393 ?-F) ; ISO-8859-7-C3-A

;; GREEK CAPITAL LETTER DELTA
(ucs-set-char #x0394 ?$(C%D(B) ; KS0-C-2544
(ucs-set-char #x0394 ?$(G$x(B) ; C01-G-2478
(ucs-set-char #x0394 ?$(@&$(B) ; J78-@-2624
(ucs-set-char #x0394 ?$(A&$(B) ; GB0-A-2624
(ucs-set-char #x0394 ?$(B&$(B) ; J83-B-2624
(ucs-set-char #x0394 ?-F) ; ISO-8859-7-C4-A

;; GREEK CAPITAL LETTER EPSILON
(ucs-set-char #x0395 ?$(C%E(B) ; KS0-C-2545
(ucs-set-char #x0395 ?$(G$y(B) ; C01-G-2479
(ucs-set-char #x0395 ?$(@&%(B) ; J78-@-2625
(ucs-set-char #x0395 ?$(A&%(B) ; GB0-A-2625
(ucs-set-char #x0395 ?$(B&%(B) ; J83-B-2625
(ucs-set-char #x0395 ?-F) ; ISO-8859-7-C5-A

;; GREEK CAPITAL LETTER ZETA
(ucs-set-char #x0396 ?$(C%F(B) ; KS0-C-2546
(ucs-set-char #x0396 ?$(G$z(B) ; C01-G-247A
(ucs-set-char #x0396 ?$(@&&(B) ; J78-@-2626
(ucs-set-char #x0396 ?$(A&&(B) ; GB0-A-2626
(ucs-set-char #x0396 ?$(B&&(B) ; J83-B-2626
(ucs-set-char #x0396 ?-F) ; ISO-8859-7-C6-A

;; GREEK CAPITAL LETTER ETA
(ucs-set-char #x0397 ?$(C%G(B) ; KS0-C-2547
(ucs-set-char #x0397 ?$(G${(B) ; C01-G-247B
(ucs-set-char #x0397 ?$(@&'(B) ; J78-@-2627
(ucs-set-char #x0397 ?$(A&'(B) ; GB0-A-2627
(ucs-set-char #x0397 ?$(B&'(B) ; J83-B-2627
(ucs-set-char #x0397 ?-F) ; ISO-8859-7-C7-A

;; GREEK CAPITAL LETTER THETA
(ucs-set-char #x0398 ?$(C%H(B) ; KS0-C-2548
(ucs-set-char #x0398 ?$(G$|(B) ; C01-G-247C
(ucs-set-char #x0398 ?$(@&((B) ; J78-@-2628
(ucs-set-char #x0398 ?$(A&((B) ; GB0-A-2628
(ucs-set-char #x0398 ?$(B&((B) ; J83-B-2628
(ucs-set-char #x0398 ?-F) ; ISO-8859-7-C8-A

;; GREEK CAPITAL LETTER IOTA
(ucs-set-char #x0399 ?$(C%I(B) ; KS0-C-2549
(ucs-set-char #x0399 ?$(G$}(B) ; C01-G-247D
(ucs-set-char #x0399 ?$(@&)(B) ; J78-@-2629
(ucs-set-char #x0399 ?$(A&)(B) ; GB0-A-2629
(ucs-set-char #x0399 ?$(B&)(B) ; J83-B-2629
(ucs-set-char #x0399 ?-F) ; ISO-8859-7-C9-A

;; GREEK CAPITAL LETTER KAPPA
(ucs-set-char #x039A ?$(C%J(B) ; KS0-C-254A
(ucs-set-char #x039A ?$(G$~(B) ; C01-G-247E
(ucs-set-char #x039A ?$(@&*(B) ; J78-@-262A
(ucs-set-char #x039A ?$(A&*(B) ; GB0-A-262A
(ucs-set-char #x039A ?$(B&*(B) ; J83-B-262A
(ucs-set-char #x039A ?-F) ; ISO-8859-7-CA-A

;; GREEK CAPITAL LETTER LAMDA
(ucs-set-char #x039B ?$(C%K(B) ; KS0-C-254B
(ucs-set-char #x039B ?$(G%!(B) ; C01-G-2521
(ucs-set-char #x039B ?$(@&+(B) ; J78-@-262B
(ucs-set-char #x039B ?$(A&+(B) ; GB0-A-262B
(ucs-set-char #x039B ?$(B&+(B) ; J83-B-262B
(ucs-set-char #x039B ?-F) ; ISO-8859-7-CB-A

;; GREEK CAPITAL LETTER MU
(ucs-set-char #x039C ?$(C%L(B) ; KS0-C-254C
(ucs-set-char #x039C ?$(G%"(B) ; C01-G-2522
(ucs-set-char #x039C ?$(@&,(B) ; J78-@-262C
(ucs-set-char #x039C ?$(A&,(B) ; GB0-A-262C
(ucs-set-char #x039C ?$(B&,(B) ; J83-B-262C
(ucs-set-char #x039C ?-F) ; ISO-8859-7-CC-A

;; GREEK CAPITAL LETTER NU
(ucs-set-char #x039D ?$(C%M(B) ; KS0-C-254D
(ucs-set-char #x039D ?$(G%#(B) ; C01-G-2523
(ucs-set-char #x039D ?$(@&-(B) ; J78-@-262D
(ucs-set-char #x039D ?$(A&-(B) ; GB0-A-262D
(ucs-set-char #x039D ?$(B&-(B) ; J83-B-262D
(ucs-set-char #x039D ?-F) ; ISO-8859-7-CD-A

;; GREEK CAPITAL LETTER XI
(ucs-set-char #x039E ?$(C%N(B) ; KS0-C-254E
(ucs-set-char #x039E ?$(G%$(B) ; C01-G-2524
(ucs-set-char #x039E ?$(@&.(B) ; J78-@-262E
(ucs-set-char #x039E ?$(A&.(B) ; GB0-A-262E
(ucs-set-char #x039E ?$(B&.(B) ; J83-B-262E
(ucs-set-char #x039E ?-F) ; ISO-8859-7-CE-A

;; GREEK CAPITAL LETTER OMICRON
(ucs-set-char #x039F ?$(C%O(B) ; KS0-C-254F
(ucs-set-char #x039F ?$(G%%(B) ; C01-G-2525
(ucs-set-char #x039F ?$(@&/(B) ; J78-@-262F
(ucs-set-char #x039F ?$(A&/(B) ; GB0-A-262F
(ucs-set-char #x039F ?$(B&/(B) ; J83-B-262F
(ucs-set-char #x039F ?-F) ; ISO-8859-7-CF-A

;; GREEK CAPITAL LETTER PI
(ucs-set-char #x03A0 ?$(C%P(B) ; KS0-C-2550
(ucs-set-char #x03A0 ?$(G%&(B) ; C01-G-2526
(ucs-set-char #x03A0 ?$(@&0(B) ; J78-@-2630
(ucs-set-char #x03A0 ?$(A&0(B) ; GB0-A-2630
(ucs-set-char #x03A0 ?$(B&0(B) ; J83-B-2630
(ucs-set-char #x03A0 ?-F) ; ISO-8859-7-D0-A

;; GREEK CAPITAL LETTER RHO
(ucs-set-char #x03A1 ?$(C%Q(B) ; KS0-C-2551
(ucs-set-char #x03A1 ?$(G%'(B) ; C01-G-2527
(ucs-set-char #x03A1 ?$(@&1(B) ; J78-@-2631
(ucs-set-char #x03A1 ?$(A&1(B) ; GB0-A-2631
(ucs-set-char #x03A1 ?$(B&1(B) ; J83-B-2631
(ucs-set-char #x03A1 ?-F) ; ISO-8859-7-D1-A

;; GREEK CAPITAL LETTER SIGMA
(ucs-set-char #x03A3 ?$(C%R(B) ; KS0-C-2552
(ucs-set-char #x03A3 ?$(G%((B) ; C01-G-2528
(ucs-set-char #x03A3 ?$(@&2(B) ; J78-@-2632
(ucs-set-char #x03A3 ?$(A&2(B) ; GB0-A-2632
(ucs-set-char #x03A3 ?$(B&2(B) ; J83-B-2632
(ucs-set-char #x03A3 ?-F) ; ISO-8859-7-D3-A

;; GREEK CAPITAL LETTER TAU
(ucs-set-char #x03A4 ?$(C%S(B) ; KS0-C-2553
(ucs-set-char #x03A4 ?$(G%)(B) ; C01-G-2529
(ucs-set-char #x03A4 ?$(@&3(B) ; J78-@-2633
(ucs-set-char #x03A4 ?$(A&3(B) ; GB0-A-2633
(ucs-set-char #x03A4 ?$(B&3(B) ; J83-B-2633
(ucs-set-char #x03A4 ?-F) ; ISO-8859-7-D4-A

;; GREEK CAPITAL LETTER UPSILON
(ucs-set-char #x03A5 ?$(C%T(B) ; KS0-C-2554
(ucs-set-char #x03A5 ?$(G%*(B) ; C01-G-252A
(ucs-set-char #x03A5 ?$(@&4(B) ; J78-@-2634
(ucs-set-char #x03A5 ?$(A&4(B) ; GB0-A-2634
(ucs-set-char #x03A5 ?$(B&4(B) ; J83-B-2634
(ucs-set-char #x03A5 ?-F) ; ISO-8859-7-D5-A

;; GREEK CAPITAL LETTER PHI
(ucs-set-char #x03A6 ?$(C%U(B) ; KS0-C-2555
(ucs-set-char #x03A6 ?$(G%+(B) ; C01-G-252B
(ucs-set-char #x03A6 ?$(@&5(B) ; J78-@-2635
(ucs-set-char #x03A6 ?$(A&5(B) ; GB0-A-2635
(ucs-set-char #x03A6 ?$(B&5(B) ; J83-B-2635
(ucs-set-char #x03A6 ?-F) ; ISO-8859-7-D6-A

;; GREEK CAPITAL LETTER CHI
(ucs-set-char #x03A7 ?$(C%V(B) ; KS0-C-2556
(ucs-set-char #x03A7 ?$(G%,(B) ; C01-G-252C
(ucs-set-char #x03A7 ?$(@&6(B) ; J78-@-2636
(ucs-set-char #x03A7 ?$(A&6(B) ; GB0-A-2636
(ucs-set-char #x03A7 ?$(B&6(B) ; J83-B-2636
(ucs-set-char #x03A7 ?-F) ; ISO-8859-7-D7-A

;; GREEK CAPITAL LETTER PSI
(ucs-set-char #x03A8 ?$(C%W(B) ; KS0-C-2557
(ucs-set-char #x03A8 ?$(G%-(B) ; C01-G-252D
(ucs-set-char #x03A8 ?$(@&7(B) ; J78-@-2637
(ucs-set-char #x03A8 ?$(A&7(B) ; GB0-A-2637
(ucs-set-char #x03A8 ?$(B&7(B) ; J83-B-2637
(ucs-set-char #x03A8 ?-F) ; ISO-8859-7-D8-A

;; GREEK CAPITAL LETTER OMEGA
(ucs-set-char #x03A9 ?$(C%X(B) ; KS0-C-2558
(ucs-set-char #x03A9 ?$(G%.(B) ; C01-G-252E
(ucs-set-char #x03A9 ?$(@&8(B) ; J78-@-2638
(ucs-set-char #x03A9 ?$(A&8(B) ; GB0-A-2638
(ucs-set-char #x03A9 ?$(B&8(B) ; J83-B-2638
(ucs-set-char #x03A9 ?-F) ; ISO-8859-7-D9-A

;; GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
(ucs-set-char #x03AA ?$(D&e(B) ; J90-D-2665
(ucs-set-char #x03AA ?-F) ; ISO-8859-7-DA-A

;; GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
(ucs-set-char #x03AB ?$(D&j(B) ; J90-D-266A
(ucs-set-char #x03AB ?-F) ; ISO-8859-7-DB-A

;; GREEK SMALL LETTER ALPHA WITH TONOS
(ucs-set-char #x03AC ?$(D&q(B) ; J90-D-2671
(ucs-set-char #x03AC ?-F) ; ISO-8859-7-DC-A

;; GREEK SMALL LETTER EPSILON WITH TONOS
(ucs-set-char #x03AD ?$(D&r(B) ; J90-D-2672
(ucs-set-char #x03AD ?-F) ; ISO-8859-7-DD-A

;; GREEK SMALL LETTER ETA WITH TONOS
(ucs-set-char #x03AE ?$(D&s(B) ; J90-D-2673
(ucs-set-char #x03AE ?-F) ; ISO-8859-7-DE-A

;; GREEK SMALL LETTER IOTA WITH TONOS
(ucs-set-char #x03AF ?$(D&t(B) ; J90-D-2674
(ucs-set-char #x03AF ?-F) ; ISO-8859-7-DF-A

;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
(ucs-set-char #x03B0 ?$(D&{(B) ; J90-D-267B
(ucs-set-char #x03B0 ?-F) ; ISO-8859-7-E0-A

;; GREEK SMALL LETTER ALPHA
(ucs-set-char #x03B1 ?$(C%a(B) ; KS0-C-2561
(ucs-set-char #x03B1 ?$(G%/(B) ; C01-G-252F
(ucs-set-char #x03B1 ?$(@&A(B) ; J78-@-2641
(ucs-set-char #x03B1 ?$(A&A(B) ; GB0-A-2641
(ucs-set-char #x03B1 ?$(B&A(B) ; J83-B-2641
(ucs-set-char #x03B1 ?-F) ; ISO-8859-7-E1-A

;; GREEK SMALL LETTER BETA
(ucs-set-char #x03B2 ?$(C%b(B) ; KS0-C-2562
(ucs-set-char #x03B2 ?$(G%0(B) ; C01-G-2530
(ucs-set-char #x03B2 ?$(@&B(B) ; J78-@-2642
(ucs-set-char #x03B2 ?$(A&B(B) ; GB0-A-2642
(ucs-set-char #x03B2 ?$(B&B(B) ; J83-B-2642
(ucs-set-char #x03B2 ?-F) ; ISO-8859-7-E2-A

;; GREEK SMALL LETTER GAMMA
(ucs-set-char #x03B3 ?$(C%c(B) ; KS0-C-2563
(ucs-set-char #x03B3 ?$(G%1(B) ; C01-G-2531
(ucs-set-char #x03B3 ?$(@&C(B) ; J78-@-2643
(ucs-set-char #x03B3 ?$(A&C(B) ; GB0-A-2643
(ucs-set-char #x03B3 ?$(B&C(B) ; J83-B-2643
(ucs-set-char #x03B3 ?-F) ; ISO-8859-7-E3-A

;; GREEK SMALL LETTER DELTA
(ucs-set-char #x03B4 ?$(C%d(B) ; KS0-C-2564
(ucs-set-char #x03B4 ?$(G%2(B) ; C01-G-2532
(ucs-set-char #x03B4 ?$(@&D(B) ; J78-@-2644
(ucs-set-char #x03B4 ?$(A&D(B) ; GB0-A-2644
(ucs-set-char #x03B4 ?$(B&D(B) ; J83-B-2644
(ucs-set-char #x03B4 ?-F) ; ISO-8859-7-E4-A

;; GREEK SMALL LETTER EPSILON
(ucs-set-char #x03B5 ?$(C%e(B) ; KS0-C-2565
(ucs-set-char #x03B5 ?$(G%3(B) ; C01-G-2533
(ucs-set-char #x03B5 ?$(@&E(B) ; J78-@-2645
(ucs-set-char #x03B5 ?$(A&E(B) ; GB0-A-2645
(ucs-set-char #x03B5 ?$(B&E(B) ; J83-B-2645
(ucs-set-char #x03B5 ?-F) ; ISO-8859-7-E5-A

;; GREEK SMALL LETTER ZETA
(ucs-set-char #x03B6 ?$(C%f(B) ; KS0-C-2566
(ucs-set-char #x03B6 ?$(G%4(B) ; C01-G-2534
(ucs-set-char #x03B6 ?$(@&F(B) ; J78-@-2646
(ucs-set-char #x03B6 ?$(A&F(B) ; GB0-A-2646
(ucs-set-char #x03B6 ?$(B&F(B) ; J83-B-2646
(ucs-set-char #x03B6 ?-F) ; ISO-8859-7-E6-A

;; GREEK SMALL LETTER ETA
(ucs-set-char #x03B7 ?$(C%g(B) ; KS0-C-2567
(ucs-set-char #x03B7 ?$(G%5(B) ; C01-G-2535
(ucs-set-char #x03B7 ?$(@&G(B) ; J78-@-2647
(ucs-set-char #x03B7 ?$(A&G(B) ; GB0-A-2647
(ucs-set-char #x03B7 ?$(B&G(B) ; J83-B-2647
(ucs-set-char #x03B7 ?-F) ; ISO-8859-7-E7-A

;; GREEK SMALL LETTER THETA
(ucs-set-char #x03B8 ?$(C%h(B) ; KS0-C-2568
(ucs-set-char #x03B8 ?$(G%6(B) ; C01-G-2536
(ucs-set-char #x03B8 ?$(@&H(B) ; J78-@-2648
(ucs-set-char #x03B8 ?$(A&H(B) ; GB0-A-2648
(ucs-set-char #x03B8 ?$(B&H(B) ; J83-B-2648
(ucs-set-char #x03B8 ?-F) ; ISO-8859-7-E8-A

;; GREEK SMALL LETTER IOTA
(ucs-set-char #x03B9 ?$(C%i(B) ; KS0-C-2569
(ucs-set-char #x03B9 ?$(G%7(B) ; C01-G-2537
(ucs-set-char #x03B9 ?$(@&I(B) ; J78-@-2649
(ucs-set-char #x03B9 ?$(A&I(B) ; GB0-A-2649
(ucs-set-char #x03B9 ?$(B&I(B) ; J83-B-2649
(ucs-set-char #x03B9 ?-F) ; ISO-8859-7-E9-A

;; GREEK SMALL LETTER KAPPA
(ucs-set-char #x03BA ?$(C%j(B) ; KS0-C-256A
(ucs-set-char #x03BA ?$(G%8(B) ; C01-G-2538
(ucs-set-char #x03BA ?$(@&J(B) ; J78-@-264A
(ucs-set-char #x03BA ?$(A&J(B) ; GB0-A-264A
(ucs-set-char #x03BA ?$(B&J(B) ; J83-B-264A
(ucs-set-char #x03BA ?-F) ; ISO-8859-7-EA-A

;; GREEK SMALL LETTER LAMDA
(ucs-set-char #x03BB ?$(C%k(B) ; KS0-C-256B
(ucs-set-char #x03BB ?$(G%9(B) ; C01-G-2539
(ucs-set-char #x03BB ?$(@&K(B) ; J78-@-264B
(ucs-set-char #x03BB ?$(A&K(B) ; GB0-A-264B
(ucs-set-char #x03BB ?$(B&K(B) ; J83-B-264B
(ucs-set-char #x03BB ?-F) ; ISO-8859-7-EB-A

;; GREEK SMALL LETTER MU
(ucs-set-char #x03BC ?$(C%l(B) ; KS0-C-256C
(ucs-set-char #x03BC ?$(G%:(B) ; C01-G-253A
(ucs-set-char #x03BC ?$(@&L(B) ; J78-@-264C
(ucs-set-char #x03BC ?$(A&L(B) ; GB0-A-264C
(ucs-set-char #x03BC ?$(B&L(B) ; J83-B-264C
(ucs-set-char #x03BC ?-F) ; ISO-8859-7-EC-A

;; GREEK SMALL LETTER NU
(ucs-set-char #x03BD ?$(C%m(B) ; KS0-C-256D
(ucs-set-char #x03BD ?$(G%;(B) ; C01-G-253B
(ucs-set-char #x03BD ?$(@&M(B) ; J78-@-264D
(ucs-set-char #x03BD ?$(A&M(B) ; GB0-A-264D
(ucs-set-char #x03BD ?$(B&M(B) ; J83-B-264D
(ucs-set-char #x03BD ?-F) ; ISO-8859-7-ED-A

;; GREEK SMALL LETTER XI
(ucs-set-char #x03BE ?$(C%n(B) ; KS0-C-256E
(ucs-set-char #x03BE ?$(G%<(B) ; C01-G-253C
(ucs-set-char #x03BE ?$(@&N(B) ; J78-@-264E
(ucs-set-char #x03BE ?$(A&N(B) ; GB0-A-264E
(ucs-set-char #x03BE ?$(B&N(B) ; J83-B-264E
(ucs-set-char #x03BE ?-F) ; ISO-8859-7-EE-A

;; GREEK SMALL LETTER OMICRON
(ucs-set-char #x03BF ?$(C%o(B) ; KS0-C-256F
(ucs-set-char #x03BF ?$(G%=(B) ; C01-G-253D
(ucs-set-char #x03BF ?$(@&O(B) ; J78-@-264F
(ucs-set-char #x03BF ?$(A&O(B) ; GB0-A-264F
(ucs-set-char #x03BF ?$(B&O(B) ; J83-B-264F
(ucs-set-char #x03BF ?-F) ; ISO-8859-7-EF-A

;; GREEK SMALL LETTER PI
(ucs-set-char #x03C0 ?$(C%p(B) ; KS0-C-2570
(ucs-set-char #x03C0 ?$(G%>(B) ; C01-G-253E
(ucs-set-char #x03C0 ?$(@&P(B) ; J78-@-2650
(ucs-set-char #x03C0 ?$(A&P(B) ; GB0-A-2650
(ucs-set-char #x03C0 ?$(B&P(B) ; J83-B-2650
(ucs-set-char #x03C0 ?-F) ; ISO-8859-7-F0-A

;; GREEK SMALL LETTER RHO
(ucs-set-char #x03C1 ?$(C%q(B) ; KS0-C-2571
(ucs-set-char #x03C1 ?$(G%?(B) ; C01-G-253F
(ucs-set-char #x03C1 ?$(@&Q(B) ; J78-@-2651
(ucs-set-char #x03C1 ?$(A&Q(B) ; GB0-A-2651
(ucs-set-char #x03C1 ?$(B&Q(B) ; J83-B-2651
(ucs-set-char #x03C1 ?-F) ; ISO-8859-7-F1-A

;; GREEK SMALL LETTER FINAL SIGMA
(ucs-set-char #x03C2 ?$(D&x(B) ; J90-D-2678
(ucs-set-char #x03C2 ?-F) ; ISO-8859-7-F2-A

;; GREEK SMALL LETTER SIGMA
(ucs-set-char #x03C3 ?$(C%r(B) ; KS0-C-2572
(ucs-set-char #x03C3 ?$(G%@(B) ; C01-G-2540
(ucs-set-char #x03C3 ?$(@&R(B) ; J78-@-2652
(ucs-set-char #x03C3 ?$(A&R(B) ; GB0-A-2652
(ucs-set-char #x03C3 ?$(B&R(B) ; J83-B-2652
(ucs-set-char #x03C3 ?-F) ; ISO-8859-7-F3-A

;; GREEK SMALL LETTER TAU
(ucs-set-char #x03C4 ?$(C%s(B) ; KS0-C-2573
(ucs-set-char #x03C4 ?$(G%A(B) ; C01-G-2541
(ucs-set-char #x03C4 ?$(@&S(B) ; J78-@-2653
(ucs-set-char #x03C4 ?$(A&S(B) ; GB0-A-2653
(ucs-set-char #x03C4 ?$(B&S(B) ; J83-B-2653
(ucs-set-char #x03C4 ?-F) ; ISO-8859-7-F4-A

;; GREEK SMALL LETTER UPSILON
(ucs-set-char #x03C5 ?$(C%t(B) ; KS0-C-2574
(ucs-set-char #x03C5 ?$(G%B(B) ; C01-G-2542
(ucs-set-char #x03C5 ?$(@&T(B) ; J78-@-2654
(ucs-set-char #x03C5 ?$(A&T(B) ; GB0-A-2654
(ucs-set-char #x03C5 ?$(B&T(B) ; J83-B-2654
(ucs-set-char #x03C5 ?-F) ; ISO-8859-7-F5-A

;; GREEK SMALL LETTER PHI
(ucs-set-char #x03C6 ?$(C%u(B) ; KS0-C-2575
(ucs-set-char #x03C6 ?$(G%C(B) ; C01-G-2543
(ucs-set-char #x03C6 ?$(@&U(B) ; J78-@-2655
(ucs-set-char #x03C6 ?$(A&U(B) ; GB0-A-2655
(ucs-set-char #x03C6 ?$(B&U(B) ; J83-B-2655
(ucs-set-char #x03C6 ?-F) ; ISO-8859-7-F6-A

;; GREEK SMALL LETTER CHI
(ucs-set-char #x03C7 ?$(C%v(B) ; KS0-C-2576
(ucs-set-char #x03C7 ?$(G%D(B) ; C01-G-2544
(ucs-set-char #x03C7 ?$(@&V(B) ; J78-@-2656
(ucs-set-char #x03C7 ?$(A&V(B) ; GB0-A-2656
(ucs-set-char #x03C7 ?$(B&V(B) ; J83-B-2656
(ucs-set-char #x03C7 ?-F) ; ISO-8859-7-F7-A

;; GREEK SMALL LETTER PSI
(ucs-set-char #x03C8 ?$(C%w(B) ; KS0-C-2577
(ucs-set-char #x03C8 ?$(G%E(B) ; C01-G-2545
(ucs-set-char #x03C8 ?$(@&W(B) ; J78-@-2657
(ucs-set-char #x03C8 ?$(A&W(B) ; GB0-A-2657
(ucs-set-char #x03C8 ?$(B&W(B) ; J83-B-2657
(ucs-set-char #x03C8 ?-F) ; ISO-8859-7-F8-A

;; GREEK SMALL LETTER OMEGA
(ucs-set-char #x03C9 ?$(C%x(B) ; KS0-C-2578
(ucs-set-char #x03C9 ?$(G%F(B) ; C01-G-2546
(ucs-set-char #x03C9 ?$(@&X(B) ; J78-@-2658
(ucs-set-char #x03C9 ?$(A&X(B) ; GB0-A-2658
(ucs-set-char #x03C9 ?$(B&X(B) ; J83-B-2658
(ucs-set-char #x03C9 ?-F) ; ISO-8859-7-F9-A

;; GREEK SMALL LETTER IOTA WITH DIALYTIKA
(ucs-set-char #x03CA ?$(D&u(B) ; J90-D-2675
(ucs-set-char #x03CA ?-F) ; ISO-8859-7-FA-A

;; GREEK SMALL LETTER UPSILON WITH DIALYTIKA
(ucs-set-char #x03CB ?$(D&z(B) ; J90-D-267A
(ucs-set-char #x03CB ?-F) ; ISO-8859-7-FB-A

;; GREEK SMALL LETTER OMICRON WITH TONOS
(ucs-set-char #x03CC ?$(D&w(B) ; J90-D-2677
(ucs-set-char #x03CC ?-F) ; ISO-8859-7-FC-A

;; GREEK SMALL LETTER UPSILON WITH TONOS
(ucs-set-char #x03CD ?$(D&y(B) ; J90-D-2679
(ucs-set-char #x03CD ?-F) ; ISO-8859-7-FD-A

;; GREEK SMALL LETTER OMEGA WITH TONOS
(ucs-set-char #x03CE ?$(D&|(B) ; J90-D-267C
(ucs-set-char #x03CE ?-F) ; ISO-8859-7-FE-A

;;; ucs-greek.el ends here
