;;; xlib-const.el --- Constants used in Xlib for masks and the like.

;; Copyright (C) 1996, 1997, 1998 Eric M. Ludlam
;;
;; Author: Eric M. Ludlam <zappo@gnu.ai.mit.edu>
;; Modified: Zajcev Evgeny <zevlg@yandex.ru>
;; Keywords: xlib, xwem
;; X-RCS: $Id: xlib-const.el,v 1.4 2004/05/05 16:46:50 lg Exp $
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's author (see below) or write to:
;;
;;              The Free Software Foundation, Inc.
;;              675 Mass Ave.
;;              Cambridge, MA 02139, USA.
;;
;; Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
;;

;;; Commentary:
;;
;; Constants used with our X connection.

;;; Code:


;;;###autoload
(defconst xlib-version "xlib(xemacs-package): $Revision: 1.4 $")

;;;###autoload
(defconst X-False 0 "False")
;;;###autoload
(defconst X-True 1 "True")

;;;###autoload
(defconst X-CopyFromParent 0 "CopyFromParent opcode.")
;;;###autoload
(defconst X-InputOutput 1 "InputOutput opcode.")
;;;###autoload
(defconst X-InputOnly 2 "InputOnly opcode.")

;;; Gravity

;;;###autoload
(defconst X-Unmap 0 "Unmap gravity.")
;;;###autoload
(defconst X-NorthWest 1 "NorthWest gravity.")
;;;###autoload
(defconst X-North 2 "North gravity.")
;;;###autoload
(defconst X-NorthEast 3 "NorthEast gravity.")
;;;###autoload
(defconst X-West 4 "West gravity.")
;;;###autoload
(defconst X-Center 5 "Center gravity.")
;;;###autoload
(defconst X-East 6 "East gravity.")
;;;###autoload
(defconst X-SouthWest 7 "SouthWest gravity.")
;;;###autoload
(defconst X-South 8 "South gravity.")
;;;###autoload
(defconst X-SouthEast 9 "SouthEast gravity.")
;;;###autoload
(defconst X-Static 10 "Static gravity.")

;; backing store

;;;###autoload
(defconst X-NotUseful 0 "NotUseful backing store.")
;;;###autoload
(defconst X-WhenMapped 1 "WhenMapped backing store.")
;;;###autoload
(defconst X-Always 2 "Always backing store.")

;;; Event Masks

;;;###autoload
(defconst XM-NoEvent #x0 "No Event mask.")
;;;###autoload
(defconst XM-KeyPress #x1 "KeyPress bitmask.")
;;;###autoload
(defconst XM-KeyRelease #x2 "KeyRelease bitmask.")
;;;###autoload
(defconst XM-ButtonPress #x4 "ButtonPress bitmask.")
;;;###autoload
(defconst XM-ButtonRelease #x8 "ButtonRelease bitmask.")
;;;###autoload
(defconst XM-EnterWindow #x10 "EnterWindow bitmask.")
;;;###autoload
(defconst XM-LeaveWindow #x20 "LeaveWindow bitmask.")
;;;###autoload
(defconst XM-PointerMotion #x40 "PointerMotion bitmask.")
;;;###autoload
(defconst XM-PointerMotionHint #x80 "PointerMotionHint bitmask.")
;;;###autoload
(defconst XM-Button1Motion #x100 "Button2Motion bitmask.")
;;;###autoload
(defconst XM-Button2Motion #x200 "Button2Motion bitmask.")
;;;###autoload
(defconst XM-Button3Motion #x400 "Button3Motion bitmask.")
;;;###autoload
(defconst XM-Button4Motion #x800 "Button4Motion bitmask.")
;;;###autoload
(defconst XM-Button5Motion #x1000 "Button5Motion bitmask.")
;;;###autoload
(defconst XM-ButtonMotion #x2000 "Button bitmask.")
;;;###autoload
(defconst XM-KeymapState #x4000 "KeymapState bitmask.")
;;;###autoload
(defconst XM-Exposure #x8000 "Exposure bitmask.")
;;;###autoload
(defconst XM-VisibilityChange #x10000 "VisibilityChange bitmask.")
;;;###autoload
(defconst XM-StructureNotify #x20000 "StructureNotify bitmask.")
;;;###autoload
(defconst XM-ResizeRedirect #x40000 "ResizeRedirect bitmask.")
;;;###autoload
(defconst XM-SubstructureNotify #x80000 "SubstructureNotify bitmask.")
;;;###autoload
(defconst XM-SubstructureRedirect #x100000 "SubstructureRedirect bitmask.")
;;;###autoload
(defconst XM-FocusChange #x200000 "FocusChange bitmask.")
;;;###autoload
(defconst XM-PropertyChange #x400000 "PropertyChange bitmask.")
;;;###autoload
(defconst XM-ColormapChange #x800000 "ColormapChange bitmask.")
;;;###autoload
(defconst XM-OwnerGrabButton #x1000000 "OwnerGrabButton bitmask.")

;; Event OpCodes

;;;###autoload
(defconst X-SyntheticMask 128 "Mask the synthetic part off.")
;;;###autoload
(defconst X-KeyPress 2 "KeyPress event.")
;;;###autoload
(defconst X-KeyRelease 3 "KeyRelease event.")
;;;###autoload
(defconst X-ButtonPress 4 "ButtonPress event.")
;;;###autoload
(defconst X-ButtonRelease 5 "ButtonRelease event.")
;;;###autoload
(defconst X-MotionNotify 6 "MotionNotify event.")
;;;###autoload
(defconst X-EnterNotify 7 "EnterNotify event.")
;;;###autoload
(defconst X-LeaveNotify 8 "LeaveNotify event.")
;;;###autoload
(defconst X-FocusIn 9 "FocusIn event.")
;;;###autoload
(defconst X-FocusOut 10 "FocusOut event.")
;;;###autoload
(defconst X-KeymapNotify 11 "KeymapNotify event.")
;;;###autoload
(defconst X-Expose 12 "Expose event.")
;;;###autoload
(defconst X-GraphicsExpose 13 "GraphicsExpose event.")
;;;###autoload
(defconst X-NoExpose 14 "NoExpose event.")
;;;###autoload
(defconst X-VisibilityNotify 15 "VisibilityNotify event.")
;;;###autoload
(defconst X-CreateNotify 16 "CreateNotify event.")
;;;###autoload
(defconst X-DestroyNotify 17 "DestroyNotify event.")
;;;###autoload
(defconst X-UnmapNotify 18 "UnmapNotify event.")
;;;###autoload
(defconst X-MapNotify 19 "MapNotify event.")
;;;###autoload
(defconst X-MapRequest 20 "MapRequest event.")
;;;###autoload
(defconst X-ReparentNotify 21 "ReparentNotify event.")
;;;###autoload
(defconst X-ConfigureNotify 22 "ConfigureNotify event.")
;;;###autoload
(defconst X-ConfigureRequest 23 "ConfigureRequest event.")
;;;###autoload
(defconst X-GravityNotify 24 "GravityNotify event.")
;;;###autoload
(defconst X-ResizeRequest 25 "ResizeRequest event.")
;;;###autoload
(defconst X-CirculateNotify 26 "CirculateNotify event.")
;;;###autoload
(defconst X-CirculateRequest 27 "CirculateRequest event.")
;;;###autoload
(defconst X-PropertyNotify 28 "PropertyNotify event.")
;;;###autoload
(defconst X-SelectionClear 29 "SelectionClear event.")
;;;###autoload
(defconst X-SelectionRequest 30 "SelectionRequest event.")
;;;###autoload
(defconst X-SelectionNotify 31 "SelectionNotify event.")
;;;###autoload
(defconst X-ColormapNotify 32 "ColormapNotify event.")
;;;###autoload
(defconst X-ClientMessage 33 "ClientMessage event.")
;;;###autoload
(defconst X-MappingNotify 34 "MappingNotify event.")
;;;###autoload
(defconst X-MaxEvent 35 "1 greater than the largest event opcode.")

;; Properties
;;;###autoload
(defconst X-PropertyNewValue 0)
;;;###autoload
(defconst X-PropertyDelete 1)

;;; Stacking constants
;;;###autoload
(defconst X-Above 0 "Stacking mode Above.")
;;;###autoload
(defconst X-Below 1 "Stacking mode Below.")
;;;###autoload
(defconst X-TopIf 2 "Stacking mode TopIf.")
;;;###autoload
(defconst X-BottomIf 3 "Stacking mode BottomIf.")
;;;###autoload
(defconst X-Opposite 4 "Stacking mode Opposite.")

;;; Atom format
;;;###autoload
(defconst X-format-8 8 "8 bit formatting for Atoms.")
;;;###autoload
(defconst X-format-16 16 "16 bit formatting for Atoms.")
;;;###autoload
(defconst X-format-32 32 "32 bit formatting for Atoms.")

;;; Predefined Atoms
;;;###autoload
(autoload 'make-X-Atom "xlib-xwin")

;;;###autoload
(defconst XA-AnyPropertyType (make-X-Atom :id 0.0 :name "") "Any atom.")
;;;###autoload
(defconst XA-primary (make-X-Atom :id 1.0 :name "PRIMARY") "Atom primary encoding.")
;;;###autoload
(defconst XA-secondary (make-X-Atom :id 2.0 :name "SECONDARY") "Atom secondary encoding.")
;;;###autoload
(defconst XA-arc (make-X-Atom :id 3.0 :name "ARC") "Atom arc encoding.")
;;;###autoload
(defconst XA-atom (make-X-Atom :id 4.0 :name "ATOM") "Atom atom encoding.")
;;;###autoload
(defconst XA-bitmap (make-X-Atom :id 5.0 :name "BITMAP") "Atom bitmap encoding.")
;;;###autoload
(defconst XA-cardinal (make-X-Atom :id 6.0 :name "CARDINAL") "Atom cardinal encoding.")
;;;###autoload
(defconst XA-colormap (make-X-Atom :id 7.0 :name "COLORMAP") "Atom colormap encoding.")
;;;###autoload
(defconst XA-cursor (make-X-Atom :id 8.0 :name "CURSOR") "Atom cursor encoding.")
;;;###autoload
(defconst XA-cut-buffer0 (make-X-Atom :id 9.0 :name "XA-CUT-BUFFER0") "Atom cut-buffer0 encoding.")
;;;###autoload
(defconst XA-cut-buffer1 (make-X-Atom :id 10.0 :name "CUT-BUFFER1") "Atom cut-buffer1 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer2 (make-X-Atom :id 11.0 :name "CUT-BUFFER2") "Atom cut-buffer2 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer3 (make-X-Atom :id 12.0 :name "CUT-BUFFER3") "Atom cut-buffer3 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer4 (make-X-Atom :id 13.0 :name "CUT-BUFFER4") "Atom cut-buffer4 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer5 (make-X-Atom :id 14.0 :name "CUT-BUFFER5") "Atom cut-buffer5 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer6 (make-X-Atom :id 15.0 :name "CUT-BUFFER6") "Atom cut-buffer6 eoncoding.")
;;;###autoload
(defconst XA-cut-buffer7 (make-X-Atom :id 16.0 :name "CUT-BUFFER7") "Atom cut-buffer7 eoncoding.")
;;;###autoload
(defconst XA-drawable (make-X-Atom :id 17.0 :name "XA-DRAWABLE") "Atom drawable eoncoding.")
;;;###autoload
(defconst XA-font (make-X-Atom :id 18.0 :name "FONT") "Atom font eoncoding.")
;;;###autoload
(defconst XA-integer (make-X-Atom :id 19.0 :name "INTEGER") "Atom integer eoncoding.")
;;;###autoload
(defconst XA-pixmap (make-X-Atom :id 20.0 :name "PIXMAP") "Atom pixmap eoncoding.")
;;;###autoload
(defconst XA-point (make-X-Atom :id 21.0 :name "POINT") "Atom point eoncoding.")
;;;###autoload
(defconst XA-rectangle (make-X-Atom :id 22.0 :name "RECTANGLE") "Atom rectangle eoncoding.")
;;;###autoload
(defconst XA-resource-manager (make-X-Atom :id 23.0 :name "RESOURCE-MANAGER") "Atom resource-manager eoncoding.")
;;;###autoload
(defconst XA-rgb-color-map (make-X-Atom :id 24.0 :name "RGB-COLOR-MAP") "Atom rgb-color-map eoncoding.")
;;;###autoload
(defconst XA-rgb-best-map (make-X-Atom :id 25.0 :name "RGB-BEST-MAP") "Atom rgb-best-map eoncoding.")
;;;###autoload
(defconst XA-rgb-blue-map (make-X-Atom :id 26.0 :name "RGB-BLUE-MAP") "Atom rgb-blue-map eoncoding.")
;;;###autoload
(defconst XA-rgb-default-map (make-X-Atom :id 27.0 :name "RGB-DEFAULT-MAP") "Atom rgb-default-map eoncoding.")
;;;###autoload
(defconst XA-rgb-gray-map (make-X-Atom :id 28.0 :name "RGB-GRAY-MAP") "Atom rgb-gray-map eoncoding.")
;;;###autoload
(defconst XA-rgb-green-map (make-X-Atom :id 29.0 :name "RGB-GREEN-MAP") "Atom rgb-green-map eoncoding.")
;;;###autoload
(defconst XA-rgb-red-map (make-X-Atom :id 30.0 :name "RGB-RED-MAP") "Atom rgb-red-map eoncoding.")
;;;###autoload
(defconst XA-string (make-X-Atom :id 31.0 :name "STRING") "Atom string eoncoding.")
;;;###autoload
(defconst XA-visualid (make-X-Atom :id 32.0 :name "VISUALID") "Atom visualid eoncoding.")
;;;###autoload
(defconst XA-window (make-X-Atom :id 33.0 :name "WINDOW") "Atom window eoncoding.")
;;;###autoload
(defconst XA-wm-command (make-X-Atom :id 34.0 :name "WM-COMMAND") "Atom wm-command eoncoding.")
;;;###autoload
(defconst XA-wm-hints (make-X-Atom :id 35.0 :name "WM-HINTS") "Atom wm-hints eoncoding.")
;;;###autoload
(defconst XA-wm-client-machine (make-X-Atom :id 36.0 :name "WM-CLIENT-MACHINE") "Atom wm-client-machine eoncoding.")
;;;###autoload
(defconst XA-wm-icon-name (make-X-Atom :id 37.0 :name "WM-ICON-NAME") "Atom wm-icon-name eoncoding.")
;;;###autoload
(defconst XA-wm-icon-size (make-X-Atom :id 38.0 :name "WM-ICON-SIZE") "Atom wm-icon-size eoncoding.")
;;;###autoload
(defconst XA-wm-name (make-X-Atom :id 39.0 :name "WM-NAME") "Atom wm-name eoncoding.")
;;;###autoload
(defconst XA-wm-normal-hints (make-X-Atom :id 40.0 :name "WM-NORMAL-HINTS") "Atom wm-normal-hints eoncoding.")
;;;###autoload
(defconst XA-wm-size-hints (make-X-Atom :id 41.0 :name "WM-SIZE-HINTS") "Atom wm-size-hints eoncoding.")
;;;###autoload
(defconst XA-wm-zoom-hints (make-X-Atom :id 42.0 :name "WM-ZOOM-HINTS") "Atom wm-zoom-hints eoncoding.")
;;;###autoload
(defconst XA-min-space (make-X-Atom :id 43.0 :name "MIN-SPACE") "Atom min-space eoncoding.")
;;;###autoload
(defconst XA-norm-space (make-X-Atom :id 44.0 :name "NORM-SPACE") "Atom norm-space eoncoding.")
;;;###autoload
(defconst XA-max-space (make-X-Atom :id 45.0 :name "MAX-SPACE") "Atom max-space eoncoding.")
;;;###autoload
(defconst XA-end-space (make-X-Atom :id 46.0 :name "END-SPACE") "Atom end-space eoncoding.")
;;;###autoload
(defconst XA-superscript-x (make-X-Atom :id 47.0 :name "SUPERSCRIPT-X") "Atom superscript-x eoncoding.")
;;;###autoload
(defconst XA-superscript-y (make-X-Atom :id 48.0 :name "SUPERSCRIPT-Y") "Atom superscript-y eoncoding.")
;;;###autoload
(defconst XA-subscript-x (make-X-Atom :id 49.0 :name "SUBSCRIPT-X") "Atom subscript-x eoncoding.")
;;;###autoload
(defconst XA-subscript-y (make-X-Atom :id 50.0 :name "SUBSCRIPT-Y") "Atom subscript-y eoncoding.")
;;;###autoload
(defconst XA-underline-position (make-X-Atom :id 51.0 :name "UNDERLINE-POSITION") "Atom underline-position eoncoding.")
;;;###autoload
(defconst XA-underline-thickness (make-X-Atom :id 52.0 :name "UNDERLINE-THICKNESS") "Atom underline-thickness eoncoding.")
;;;###autoload
(defconst XA-strikeout-ascent (make-X-Atom :id 53.0 :name "STRIKEOUT-ASCENT") "Atom strikeout-ascent eoncoding.")
;;;###autoload
(defconst XA-strikeout-descent (make-X-Atom :id 54.0 :name "STRIKEOUT-DESCENT") "Atom strikeout-descent eoncoding.")
;;;###autoload
(defconst XA-italic-angle (make-X-Atom :id 55.0 :name "ITALIC-ANGLE") "Atom italic-angle eoncoding.")
;;;###autoload
(defconst XA-x-height (make-X-Atom :id 56.0 :name "X-HEIGHT") "Atom x-height eoncoding.")
;;;###autoload
(defconst XA-quad-width (make-X-Atom :id 57.0 :name "QUAD-WIDTH") "Atom quad-width eoncoding.")
;;;###autoload
(defconst XA-weight (make-X-Atom :id 58.0 :name "WEIGHT") "Atom weight eoncoding.")
;;;###autoload
(defconst XA-point-size (make-X-Atom :id 59.0 :name "POINT-SIZE") "Atom point-size eoncoding.")
;;;###autoload
(defconst XA-resolution (make-X-Atom :id 60.0 :name "RESOLUTION") "Atom resolution eoncoding.")
;;;###autoload
(defconst XA-copyright (make-X-Atom :id 61.0 :name "COPYRIGHT") "Atom copyright eoncoding.")
;;;###autoload
(defconst XA-notice (make-X-Atom :id 62.0 :name "NOTICE") "Atom notice eoncoding.")
;;;###autoload
(defconst XA-font-name (make-X-Atom :id 63.0 :name "FONT-NAME") "Atom font-name eoncoding.")
;;;###autoload
(defconst XA-family-name (make-X-Atom :id 64.0 :name "FAMILY-NAME") "Atom family-name eoncoding.")
;;;###autoload
(defconst XA-full-name (make-X-Atom :id 65.0 :name "FULL-NAME") "Atom full-name eoncoding.")
;;;###autoload
(defconst XA-cap-height (make-X-Atom :id 66.0 :name "CAP-HEIGHT") "Atom cap-height eoncoding.")
;;;###autoload
(defconst XA-wm-class (make-X-Atom :id 67.0 :name "WM-CLASS") "Atom wm-class eoncoding.")
;;;###autoload
(defconst XA-wm-transient-for (make-X-Atom :id 68.0 :name "WM-TRANSIENT-FOR") "Atom wm-transient-for eoncoding.")

;;; Property Modes for atoms
;;;###autoload
(defconst X-PropModeReplace 0 "Property Mode Replace")
;;;###autoload
(defconst X-PropModePrepend 1 "Property Mode Prepend")
;;;###autoload
(defconst X-PropModeAppend  2 "Property Mode Append")

;;; KeyButtonMask

;;;###autoload
(defconst X-Shift #x1 "Shift bitmask.")
;;;###autoload
(defconst X-Lock #x2 "Lock bitmask.")
;;;###autoload
(defconst X-Control #x4 "Control bitmask.")
;;;###autoload
(defconst X-Mod1 #x8 "Mod1 bitmask.")
;;;###autoload
(defconst X-Mod2 #x10 "Mod2 bitmask.")
;;;###autoload
(defconst X-Mod3 #x20 "Mod3 bitmask.")
;;;###autoload
(defconst X-Mod4 #x40 "Mod4 bitmask.")
;;;###autoload
(defconst X-Mod5 #x80 "Mod5 bitmask.")
;;;###autoload
(defconst X-Button1 #x100 "Button1 bitmask.")
;;;###autoload
(defconst X-Button2 #x200 "Button2 bitmask.")
;;;###autoload
(defconst X-Button3 #x400 "Button3 bitmask.")
;;;###autoload
(defconst X-Button4 #x800 "Button4 bitmask.")
;;;###autoload
(defconst X-Button5 #x1000 "Button5 bitmask.")

;;;###autoload
(defconst X-XButton1 1)
;;;###autoload
(defconst X-XButton2 2)
;;;###autoload
(defconst X-XButton3 3)
;;;###autoload
(defconst X-XButton4 4)
;;;###autoload
(defconst X-XButton5 5)
;;; Graphic context stuff
;;

;;; functions
;;;###autoload
(defconst X-GXClear 0 "GC function type id.")
;;;###autoload
(defconst X-GXAnd 1 "GC function type id.")
;;;###autoload
(defconst X-GXAndReverse 2 "GC function type id.")
;;;###autoload
(defconst X-GXCopy 3 "GC function type id.")
;;;###autoload
(defconst X-GXAndInverted 4 "GC function type id.")
;;;###autoload
(defconst X-GXNoOp 5 "GC function type id.")
;;;###autoload
(defconst X-GXXor 6 "GC function type id.")
;;;###autoload
(defconst X-GXOr 7 "GC function type id.")
;;;###autoload
(defconst X-GXNor 8 "GC function type id.")
;;;###autoload
(defconst X-GXEquiv 9 "GC function type id.")
;;;###autoload
(defconst X-GXInvert 10 "GC function type id.")
;;;###autoload
(defconst X-GXOrReverse 11 "GC function type id.")
;;;###autoload
(defconst X-GXCopyInverted 12 "GC function type id.")
;;;###autoload
(defconst X-GXOrInverted 13 "GC function type id.")
;;;###autoload
(defconst X-GXNand 14 "GC function type id.")
;;;###autoload
(defconst X-GXSet 15 "GC function type id.")

;; line styles
;;;###autoload
(defconst X-LineSolid 0 "GC line-style.")
;;;###autoload
(defconst X-LineOnOffDash 1 "GC line-style.")
;;;###autoload
(defconst X-LineDoubleDash 2 "GC line-style.")

;; cap-styles
;;;###autoload
(defconst X-CapNotLast 0 "GC cap-styles.")
;;;###autoload
(defconst X-CapButt 1 "GC cap-styles.")
;;;###autoload
(defconst X-CapRound 2 "GC cap-styles.")
;;;###autoload
(defconst X-CapProjecting 3 "GC cap-styles.")

;; join styles
;;;###autoload
(defconst X-JoinMiter 0 "GC join-style.")
;;;###autoload
(defconst X-JoinRound 1 "GC join-style.")
;;;###autoload
(defconst X-JoinBevel 2 "GC join-style.")

;; fill style
;;;###autoload
(defconst X-FillSolid 0 "GC fill-style.")
;;;###autoload
(defconst X-FillTiled 1 "GC fill-style.")
;;;###autoload
(defconst X-FillStippled 2 "GC fill-style.")
;;;###autoload
(defconst X-FillOpaqueStippled 3 "GC fill-style.")

;; fill rule
;;;###autoload
(defconst X-EvenOddRule 0 "GC fill-rule.")
;;;###autoload
(defconst X-WindingRule 1 "GC fill-rule.")

;; arc-mode
;;;###autoload
(defconst X-ArcChord 0 "GC arc mode.")
;;;###autoload
(defconst X-ArcPieSlice 1 "GC arc mode.")

;; Subwindow mode
;;;###autoload
(defconst X-ClipByChildren 0 "GC subwindow-mode.")
;;;###autoload
(defconst X-IncludeInferiors 1 "GC subwindow-mode.")

;; XSetClipRectangles ordering
;;;###autoload
(defconst X-UnSorted 0 "Unsorted list.")
;;;###autoload
(defconst X-YSorted 1 "Sorted by Y.")
;;;###autoload
(defconst X-YXSorted 2 "Sorted by X and Y.")
;;;###autoload
(defconst X-YXBanded 3)

;; Imaging
;;;###autoload
(defconst X-XYBitmap 0)			; depth 1, XYFormat
;;;###autoload
(defconst X-XYPixmap 1)			; depth == drawable depth
;;;###autoload
(defconst X-ZPixmap 2)			; depth == drawable depth

;;; Some color type stuff
;;
;;;###autoload
(defconst X-AllocNone 0 "No color entries writable.")
;;;###autoload
(defconst X-AllocAll  1 "All color entries writable.")

;;;###autoload
(defconst X-DoRed 1 "Do Red mask.")
;;;###autoload
(defconst X-DoGreen 2 "Do Green mask.")
;;;###autoload
(defconst X-DoBlue 4 "Do blue mask.")
;;;###autoload
(defconst X-DoRedGreenBlue 7 "All Color Dos ored together.")

;;; Poling coordinate mode
;;;###autoload
(defconst X-Origin 0 "Specifies point drawn with relation to origin.")
;;;###autoload
(defconst X-Previous 1 "Specifies points draw with relation to previous point.")

;;; Filling shapes
;;;###autoload
(defconst X-Complex 0)
;;;###autoload
(defconst X-Nonconvex 1)
;;;###autoload
(defconst X-Convex 2)

;; Misc
;;;###autoload
(defconst X-None 0 "universal null resource or null atom")

;;;###autoload
(defconst X-RevertToNone 0 "for XSetInputFocus")
;;;###autoload
(defconst X-RevertToPointerRoot 1 "for XSetInputFocus")
;;;###autoload
(defconst X-RevertToParent 2 "for XSetInputFocus")

;;;###autoload
(defconst X-ParentRelative 1
  "Background pixmap in CreateWindow and ChangeWindowAttributes.")
;;;###autoload
(defconst X-CopyFromParent 0
  "Border pixmap in CreateWindow and ChangeWindowAttributes special
  VisualID and special window class passed to CreateWindow.")
;;;###autoload
(defconst X-PointerWindow 0 "destination window in SendEvent")
;;;###autoload
(defconst X-InputFocus 1 "destination window in SendEvent")
;;;###autoload
(defconst X-PointerRoot	1 "focus window in SetInputFocus")
;;;###autoload
(defconst X-AnyPropertyType 0 "special Atom, passed to GetProperty")
;;;###autoload
(defconst X-AnyKey 0 "special Key Code, passed to GrabKey")
;;;###autoload
(defconst X-AnyButton 0 "special Button Code, passed to GrabButton")
;;;###autoload
(defconst X-AllTemporary 0 "special Resource ID passed to KillClient")
;;;###autoload
(defconst X-CurrentTime	0 "special Time")
;;;###autoload
(defconst X-NoSymbol 0 "special KeySym")

;;;###autoload
(defconst X-GrabModeSync 0 "specific mode")
;;;###autoload
(defconst X-GrabModeAsync 1 "specific mode")

;;;###autoload
(defconst X-AllPlanes -1 "Mask for all planes in XGetImage.")

;; AllowEvents modes
;;;###autoload
(defconst X-AsyncPointer 0)
;;;###autoload
(defconst X-SyncPointer 1)
;;;###autoload
(defconst X-ReplayPointer 2)
;;;###autoload
(defconst X-AsyncKeyboard 3)
;;;###autoload
(defconst X-SyncKeyboard 4)
;;;###autoload
(defconst X-ReplayKeyboard 5)
;;;###autoload
(defconst X-AsyncBoth 6)
;;;###autoload
(defconst X-SyncBoth 7)

;; For window Attributes
;;;###autoload
(defconst X-CWBackPixmap #x1)
;;;###autoload
(defconst X-CWBackPixel #x2)
;;;###autoload
(defconst X-CWBorderPixmap #x4)
;;;###autoload
(defconst X-CWBorderPixel #x8)
;;;###autoload
(defconst X-CWBitGravity #x10)
;;;###autoload
(defconst X-CWWinGravity #x20)
;;;###autoload
(defconst X-CWBackingStore #x40)
;;;###autoload
(defconst X-CWBackingPlanes #x80)
;;;###autoload
(defconst X-CWBackingPixel #x100)
;;;###autoload
(defconst X-CWOverrideRedirect #x200)
;;;###autoload
(defconst X-CWSaveUnder #x400)
;;;###autoload
(defconst X-CWEventMask #x800)
;;;###autoload
(defconst X-CWDontPropagate #x1000)
;;;###autoload
(defconst X-CWColormap #x2000)
;;;###autoload
(defconst X-CWCursor #x4000)

;; used in ChangeSaveSet
;;;###autoload
(defconst X-SetModeInsert 0)
;;;###autoload
(defconst X-SetModeDelete 1)

;; used in ConfigureWindow
;;;###autoload
(defconst X-CWX #x1)
;;;###autoload
(defconst X-CWY #x2)
;;;###autoload
(defconst X-CWWidth #x4)
;;;###autoload
(defconst X-CWHeight #x8)
;;;###autoload
(defconst X-CWBorderWidth #x10)
;;;###autoload
(defconst X-CWSibling #x20)
;;;###autoload
(defconst X-CWStackMode #x40)

;;; Cursors
;;;###autoload
(defconst X-XC-num_glyphs 154)
;;;###autoload
(defconst X-XC-X_cursor 0)
;;;###autoload
(defconst X-XC-arrow 2)
;;;###autoload
(defconst X-XC-based_arrow_down 4)
;;;###autoload
(defconst X-XC-based_arrow_up 6)
;;;###autoload
(defconst X-XC-boat 8)
;;;###autoload
(defconst X-XC-bogosity 10)
;;;###autoload
(defconst X-XC-bottom_left_corner 12)
;;;###autoload
(defconst X-XC-bottom_right_corner 14)
;;;###autoload
(defconst X-XC-bottom_side 16)
;;;###autoload
(defconst X-XC-bottom_tee 18)
;;;###autoload
(defconst X-XC-box_spiral 20)
;;;###autoload
(defconst X-XC-center_ptr 22)
;;;###autoload
(defconst X-XC-circle 24)
;;;###autoload
(defconst X-XC-clock 26)
;;;###autoload
(defconst X-XC-coffee_mug 28)
;;;###autoload
(defconst X-XC-cross 30)
;;;###autoload
(defconst X-XC-cross_reverse 32)
;;;###autoload
(defconst X-XC-crosshair 34)
;;;###autoload
(defconst X-XC-diamond_cross 36)
;;;###autoload
(defconst X-XC-dot 38)
;;;###autoload
(defconst X-XC-dotbox 40)
;;;###autoload
(defconst X-XC-double_arrow 42)
;;;###autoload
(defconst X-XC-draft_large 44)
;;;###autoload
(defconst X-XC-draft_small 46)
;;;###autoload
(defconst X-XC-draped_box 48)
;;;###autoload
(defconst X-XC-exchange 50)
;;;###autoload
(defconst X-XC-fleur 52)
;;;###autoload
(defconst X-XC-gobbler 54)
;;;###autoload
(defconst X-XC-gumby 56)
;;;###autoload
(defconst X-XC-hand1 58)
;;;###autoload
(defconst X-XC-hand2 60)
;;;###autoload
(defconst X-XC-heart 62)
;;;###autoload
(defconst X-XC-icon 64)
;;;###autoload
(defconst X-XC-iron_cross 66)
;;;###autoload
(defconst X-XC-left_ptr 68)
;;;###autoload
(defconst X-XC-left_side 70)
;;;###autoload
(defconst X-XC-left_tee 72)
;;;###autoload
(defconst X-XC-leftbutton 74)
;;;###autoload
(defconst X-XC-ll_angle 76)
;;;###autoload
(defconst X-XC-lr_angle 78)
;;;###autoload
(defconst X-XC-man 80)
;;;###autoload
(defconst X-XC-middlebutton 82)
;;;###autoload
(defconst X-XC-mouse 84)
;;;###autoload
(defconst X-XC-pencil 86)
;;;###autoload
(defconst X-XC-pirate 88)
;;;###autoload
(defconst X-XC-plus 90)
;;;###autoload
(defconst X-XC-question_arrow 92)
;;;###autoload
(defconst X-XC-right_ptr 94)
;;;###autoload
(defconst X-XC-right_side 96)
;;;###autoload
(defconst X-XC-right_tee 98)
;;;###autoload
(defconst X-XC-rightbutton 100)
;;;###autoload
(defconst X-XC-rtl_logo 102)
;;;###autoload
(defconst X-XC-sailboat 104)
;;;###autoload
(defconst X-XC-sb_down_arrow 106)
;;;###autoload
(defconst X-XC-sb_h_double_arrow 108)
;;;###autoload
(defconst X-XC-sb_left_arrow 110)
;;;###autoload
(defconst X-XC-sb_right_arrow 112)
;;;###autoload
(defconst X-XC-sb_up_arrow 114)
;;;###autoload
(defconst X-XC-sb_v_double_arrow 116)
;;;###autoload
(defconst X-XC-shuttle 118)
;;;###autoload
(defconst X-XC-sizing 120)
;;;###autoload
(defconst X-XC-spider 122)
;;;###autoload
(defconst X-XC-spraycan 124)
;;;###autoload
(defconst X-XC-star 126)
;;;###autoload
(defconst X-XC-target 128)
;;;###autoload
(defconst X-XC-tcross 130)
;;;###autoload
(defconst X-XC-top_left_arrow 132)
;;;###autoload
(defconst X-XC-top_left_corner 134)
;;;###autoload
(defconst X-XC-top_right_corner 136)
;;;###autoload
(defconst X-XC-top_side 138)
;;;###autoload
(defconst X-XC-top_tee 140)
;;;###autoload
(defconst X-XC-trek 142)
;;;###autoload
(defconst X-XC-ul_angle 144)
;;;###autoload
(defconst X-XC-umbrella 146)
;;;###autoload
(defconst X-XC-ur_angle 148)
;;;###autoload
(defconst X-XC-watch 150)
;;;###autoload
(defconst X-XC-xterm 152)

;; Some keys
;;;###autoload
(defconst XK-Shift-L 65505)
;;;###autoload
(defconst XK-Shift-R 65506)
;;;###autoload
(defconst XK-Control-L 65507)
;;;###autoload
(defconst XK-Control-R 65508)
;;;###autoload
(defconst XK-Caps-Lock 65509)
;;;###autoload
(defconst XK-Shift-Lock 65510)

;;;###autoload
(defconst XK-Meta-L 65511)
;;;###autoload
(defconst XK-Meta-R 65512)
;;;###autoload
(defconst XK-Alt-L 65513)
;;;###autoload
(defconst XK-Alt-R 65514)
;;;###autoload
(defconst XK-Super-L 65515)
;;;###autoload
(defconst XK-Super-R 65516)
;;;###autoload
(defconst XK-Hyper-L 65517)
;;;###autoload
(defconst XK-Hyper-R 65518)

;;;###autoload
(defconst XK-BackSpace 65288)
;;;###autoload
(defconst XK-Tab 65289)
;;;###autoload
(defconst XK-Linefeed 65290)
;;;###autoload
(defconst XK-Clear 65291)
;;;###autoload
(defconst XK-Return 65293)
;;;###autoload
(defconst XK-Pause 65299)
;;;###autoload
(defconst XK-Scroll-Lock 65300)
;;;###autoload
(defconst XK-Sys-Req 65301)
;;;###autoload
(defconst XK-Escape 65307)
;;;###autoload
(defconst XK-Delete 65535)

;;;###autoload
(defconst XK-Select #xFF60 "Select, mark")
;;;###autoload
(defconst XK-Print #xFF61)
;;;###autoload
(defconst XK-Execute #xFF62 "Execute, run, do")
;;;###autoload
(defconst XK-Insert #xFF63 "Insert, insert here")
;;;###autoload
(defconst XK-Undo #xFF65 "Undo, oops")
;;;###autoload
(defconst XK-Redo #xFF66 "redo, again")
;;;###autoload
(defconst XK-Menu #xFF67)
;;;###autoload
(defconst XK-Find #xFF68 "Find, search")
;;;###autoload
(defconst XK-Cancel #xFF69 "Cancel, stop, abort, exit")
;;;###autoload
(defconst XK-Help #xFF6A "Help")
;;;###autoload
(defconst XK-Break #xFF6B)
;;;###autoload
(defconst XK-ModeSwitch #xFF7E "Character set switch")
;;;###autoload
(defconst XK-ScriptSwitch #xFF7E "Alias for mode_switch")
;;;###autoload
(defconst XK-NumLock #xFF7F)

;;;###autoload
(defconst XK-F1			#xFFBE)
;;;###autoload
(defconst XK-F2			#xFFBF)
;;;###autoload
(defconst XK-F3			#xFFC0)
;;;###autoload
(defconst XK-F4			#xFFC1)
;;;###autoload
(defconst XK-F5			#xFFC2)
;;;###autoload
(defconst XK-F6			#xFFC3)
;;;###autoload
(defconst XK-F7			#xFFC4)
;;;###autoload
(defconst XK-F8			#xFFC5)
;;;###autoload
(defconst XK-F9			#xFFC6)
;;;###autoload
(defconst XK-F10		#xFFC7)
;;;###autoload
(defconst XK-F11		#xFFC8)
;;;###autoload
(defconst XK-L1			#xFFC8)
;;;###autoload
(defconst XK-F12		#xFFC9)
;;;###autoload
(defconst XK-L2			#xFFC9)
;;;###autoload
(defconst XK-F13		#xFFCA)
;;;###autoload
(defconst XK-L3			#xFFCA)
;;;###autoload
(defconst XK-F14		#xFFCB)
;;;###autoload
(defconst XK-L4			#xFFCB)
;;;###autoload
(defconst XK-F15		#xFFCC)
;;;###autoload
(defconst XK-L5			#xFFCC)
;;;###autoload
(defconst XK-F16		#xFFCD)
;;;###autoload
(defconst XK-L6			#xFFCD)
;;;###autoload
(defconst XK-F17		#xFFCE)
;;;###autoload
(defconst XK-L7			#xFFCE)
;;;###autoload
(defconst XK-F18		#xFFCF)
;;;###autoload
(defconst XK-L8			#xFFCF)
;;;###autoload
(defconst XK-F19		#xFFD0)
;;;###autoload
(defconst XK-L9			#xFFD0)
;;;###autoload
(defconst XK-F20		#xFFD1)
;;;###autoload
(defconst XK-L10		#xFFD1)
;;;###autoload
(defconst XK-F21		#xFFD2)
;;;###autoload
(defconst XK-R1			#xFFD2)
;;;###autoload
(defconst XK-F22		#xFFD3)
;;;###autoload
(defconst XK-R2			#xFFD3)
;;;###autoload
(defconst XK-F23		#xFFD4)
;;;###autoload
(defconst XK-R3			#xFFD4)
;;;###autoload
(defconst XK-F24		#xFFD5)
;;;###autoload
(defconst XK-R4			#xFFD5)
;;;###autoload
(defconst XK-F25		#xFFD6)
;;;###autoload
(defconst XK-R5			#xFFD6)
;;;###autoload
(defconst XK-F26		#xFFD7)
;;;###autoload
(defconst XK-R6			#xFFD7)
;;;###autoload
(defconst XK-F27		#xFFD8)
;;;###autoload
(defconst XK-R7			#xFFD8)
;;;###autoload
(defconst XK-F28		#xFFD9)
;;;###autoload
(defconst XK-R8			#xFFD9)
;;;###autoload
(defconst XK-F29		#xFFDA)
;;;###autoload
(defconst XK-R9			#xFFDA)
;;;###autoload
(defconst XK-F30		#xFFDB)
;;;###autoload
(defconst XK-R10		#xFFDB)
;;;###autoload
(defconst XK-F31		#xFFDC)
;;;###autoload
(defconst XK-R11		#xFFDC)
;;;###autoload
(defconst XK-F32		#xFFDD)
;;;###autoload
(defconst XK-R12		#xFFDD)
;;;###autoload
(defconst XK-F33		#xFFDE)
;;;###autoload
(defconst XK-R13		#xFFDE)
;;;###autoload
(defconst XK-F34		#xFFDF)
;;;###autoload
(defconst XK-R14		#xFFDF)
;;;###autoload
(defconst XK-F35		#xFFE0)
;;;###autoload
(defconst XK-R15		#xFFE0)

;;;###autoload
(defconst XK-Space		#x0020)

;; Cursors
;;;###autoload
(defconst XK-Home		#xFF50)
;;;###autoload
(defconst XK-Left		#xFF51)	; Move left, left arrow
;;;###autoload
(defconst XK-Up			#xFF52)	; Move up, up arrow
;;;###autoload
(defconst XK-Right		#xFF53)	; Move right, right arrow
;;;###autoload
(defconst XK-Down		#xFF54)	; Move down, down arrow
;;;###autoload
(defconst XK-Prior		#xFF55)	; Prior, previous
;;;###autoload
(defconst XK-PageUp		#xFF55)
;;;###autoload
(defconst XK-Next		#xFF56)	; Next
;;;###autoload
(defconst XK-PageDown		#xFF56) ;
;;;###autoload
(defconst XK-End		#xFF57)	; EOL
;;;###autoload
(defconst XK-Begin		#xFF58)	; BOL

;; Window states
;;;###autoload
(defconst X-WithdrawnState 0.0)
;;;###autoload
(defconst X-NormalState 1.0)
;;;###autoload
(defconst X-IconicState 3.0)

;; Notify mode
;;;###autoload
(defconst X-NotifyNormal 0)
;;;###autoload
(defconst X-NotifyGrab 1)
;;;###autoload
(defconst X-NotifyUngrab 2)
;;;###autoload
(defconst X-NotifyWhileGrabbed 3)

;;;###autoload
(defconst X-NotifyHint 1)		; for MotionNotify
		       
;; Notify detail
;;;###autoload
(defconst X-NotifyAncestor 0)
;;;###autoload
(defconst X-NotifyVirtual 1)
;;;###autoload
(defconst X-NotifyInferior 2)
;;;###autoload
(defconst X-NotifyNonlinear 3)
;;;###autoload
(defconst X-NotifyNonlinearVirtual 4)
;;;###autoload
(defconst X-NotifyPointer 5)
;;;###autoload
(defconst X-NotifyPointerRoot 6)
;;;###autoload
(defconst X-NotifyDetailNone 7)

;; Used in GetWindowAttributes reply
;;;###autoload
(defconst X-Unmapped 0)
;;;###autoload
(defconst X-Unviewable 1)
;;;###autoload
(defconst X-Viewable 2)

;; Byte order
;;;###autoload
(defconst X-LSBFirst 0)
;;;###autoload
(defconst X-MSBFirst 1)


(provide 'xlib-const)

;;; xlib-const.el ends here
