/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.DebuggeeProcess;
import jde.debugger.JDE;
import jde.debugger.Protocol;

public class ObjectStore
implements Protocol {
    final DebuggeeProcess proc;
    final Integer procID;
    JDE jde = JDE.getJDE();
    private Map objectMap;
    private long maximumLimit = 8L;
    private boolean requestPending = false;

    public ObjectStore(DebuggeeProcess proc) {
        this.proc = proc;
        this.procID = proc.getId();
        this.objectMap = new HashMap();
    }

    public void put(ObjectReference ref) {
        long size;
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            this.objectMap.put(new Long(ref.uniqueID()), ref);
            size = this.objectMap.size();
        }
        if (size > this.maximumLimit && !this.requestPending) {
            this.jde.signal(this.procID, "report-ids-in-use", null);
            this.requestPending = true;
        }
    }

    public void trim(List objectIDs) {
        HashMap newMap = new HashMap();
        Iterator it = objectIDs.iterator();
        while (it.hasNext()) {
            Long id = (Long)it.next();
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                if (this.objectMap.containsKey(id)) {
                    newMap.put(id, this.objectMap.get(id));
                }
            }
        }
        this.maximumLimit = 2 * newMap.size();
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            this.objectMap = newMap;
        }
        this.requestPending = false;
    }

    public ObjectReference get(Object id) {
        ObjectStore objectStore = this;
        synchronized (objectStore) {
            ObjectReference objectReference = (ObjectReference)this.objectMap.get(id);
            return objectReference;
        }
    }
}

