/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: browser.c,v 1.14 1997/08/19 02:05:08 timj Exp $")


#define		__browser_c__

#include	"browser.h"
#include	"gsi.h"
#include	"treelist.h"
#include	"editor.h"
#include	"widgets.h"
#include	"windows.h"
#include	"widdata.h"
#include	"ufunc.h"
#include	"misc.h"
#include	"defines.h"
#include	"config.h"



/* --- structures --- */
typedef	struct	listwid_widget_list_S	listwid_widget_list_S;
struct	listwid_widget_list_S {
	gb_wdat_base_S	*widget_data;
	GtkWidget	*Label_symbol_name;
	GtkWidget	*Label_parent_name;
	GtkWidget	*Box_selected;
	GtkWidget	*ScrolledWindow;
	GtkWidget	*List;
};



/* --- variables --- */
static	add_type_E	Add_Type;



/* --- prototypes --- */
static	void	sigh_browser_List_selection_changed	(GtkList	*widget,
							 gpointer	func_data);
static	void	sigh_delete_widget_data_real		(GtkWidget	*widget,
						 gpointer	 func_data);



/* --- variables --- */
static	gboolean	ignore_selection_events=FALSE;



/* --- functions --- */
void
browser_create_window	(gb_wdat_base_S	*widget_data)
{
	if (!GUBI_DATA(widget_data)->browser) {
		register listwid_widget_list_S	*widget_list;
		

		/* clone window
		*/
		gb_widget_data_clone(GB_wCAST(base, Browser_Window));
		
		
		/* initialize widgets
		*/
		GB_wCAST(label, Browser_Label_symbol_name->clone)->label=
			(gchar*)widget_data_get_symbol_name(widget_data);
		
		
		/* build & connect window
		*/
		gb_window_build(GB_wCAST(window, Browser_Window->clone),
				gb_accelerator_hash_table,
				gb_accelerator_hash_table);
		gb_window_connect(GB_wCAST(window, Browser_Window->clone));
		
		
		/* set GtkWindow* in the browser field and reset to NULL
		 * if the window is destroyed
		*/
		GUBI_DATA(widget_data)->browser=Browser_Window->clone->widget;
		GB_NULLIFY_ON_DESTROY(Browser_Window->clone->widget,
				      &GUBI_DATA(widget_data)->browser);
		
		
		/* we set user_data of the browser window to our widget_list
		 * structure, which will be freed if the window is destroyed.
		*/
		widget_list=g_new(listwid_widget_list_S, 1);
		widget_list->widget_data=widget_data;
		widget_list->Label_symbol_name=Browser_Label_symbol_name->clone->widget;
		widget_list->Label_parent_name=Browser_Label_parent_name->clone->widget;
		widget_list->Box_selected=Browser_Box_Selected->clone->widget;
		widget_list->ScrolledWindow=Browser_ScrolledWin->clone->widget;
		widget_list->List=Browser_List->clone->widget;
		GB_GFREE_ON_DESTROY(Browser_Window->clone->widget, widget_list);
		gtk_object_set_user_data(GTK_OBJECT(Browser_Window->clone->widget),
					 widget_list);
		
		
		/* track selection_changed on single lists
		 * and connect signal handler to buttons
		*/
		gtk_signal_connect(GTK_OBJECT(widget_list->List),
				   "selection_changed",
				   GTK_SIGNAL_FUNC(sigh_browser_List_selection_changed),
				   NULL);
		gtk_signal_connect_object(GTK_OBJECT(Browser_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(Browser_Window->clone->widget));
	
	
		/* show window
		*/
		gtk_widget_show(Browser_Window->clone->widget);
		
		
		/* build up contents
		*/
		browser_refresh_window(widget_data, FALSE);
	} else
		_gtk_widget_raise(GUBI_DATA(widget_data)->browser);
}


void
browser_refresh_window	(gb_wdat_base_S	*widget_data,
			 guint		selection_only)
{
	register listwid_widget_list_S	*widget_list;
	register GtkList		*List;
	register GtkScrolledWindow	*ScrolledWindow;
	register tree_S			*tree;
	register gboolean		reposition;
	         gchar			*old_label;
	
	g_assert(GB_IS_WIDDAT(widget_data));
	
	g_assert(GUBI_DATA(widget_data)->browser);
	widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(widget_data)->browser));
	g_assert(widget_list);
	
	List=GTK_LIST(widget_list->List);
	ScrolledWindow=GTK_SCROLLED_WINDOW(widget_list->ScrolledWindow);
		
	g_assert((tree=GUBI_DATA(widget_data)->tree));
	
	reposition=FALSE;
	
	ignore_selection_events=TRUE;

	if (!selection_only) {
		register GList			*list;
		register GList			*last;
		register GList			*item_list;
		register guint			parent_level;
		register GtkAdjustment		*Adjustment;
		register gfloat			old_hvalue;
		register gfloat			value;
		
		Adjustment=gtk_scrolled_window_get_hadjustment(ScrolledWindow);
		old_hvalue=Adjustment->value;
		
		gtk_list_clear_items(List, 0, -1);
		reposition=TRUE;
		
		list=g_list_find(tree->widget_data_list, widget_data);
		last=g_list_find(tree->widget_data_list, widget_data_last_child(widget_data));
		
		parent_level=widget_data_parent_level(widget_data);
		
		item_list=NULL;
		
		while (list) {
			register GtkWidget	*item;
			
			item=widget_data_new_item(list->data,
						  2 * ( widget_data_parent_level(list->data) -
						        parent_level ),
						  NULL, 0);
			gtk_object_set_data(GTK_OBJECT(item), "button_1_clicked_2", (gpointer)GB_LA_BROWSER);
			gtk_object_set_data(GTK_OBJECT(item), "button_2_clicked_1", (gpointer)GB_LA_WIDGET_DUMP);
			gtk_object_set_data(GTK_OBJECT(item), "button_3_clicked_1", (gpointer)GB_LA_EDITOR);
			gtk_signal_connect(GTK_OBJECT(item),
					   "button_press_event",
					   GTK_SIGNAL_FUNC(sigh_widget_data_item_clicked),
					   NULL);
			gtk_signal_connect(GTK_OBJECT(item),
					   "button_release_event",
					   GTK_SIGNAL_FUNC(sigh_widget_data_item_clicked),
					   NULL);
			item_list=g_list_append(item_list, item);
			
			if (list!=last)
				list=list->next;
			else
				list=NULL;
		}
		gtk_list_append_items(List, item_list);

		Adjustment=gtk_scrolled_window_get_hadjustment(ScrolledWindow);
		value=CLAMP(old_hvalue,
			    Adjustment->lower,
			    Adjustment->upper-Adjustment->page_size);
		_gtk_adjustment_set_value(Adjustment, value);
	}
	
	if (List->selection &&
	    tree->current!=gtk_object_get_user_data(List->selection->data) ) {
		gtk_list_unselect_child(List, List->selection->data);
	}

	if (!List->selection && tree->current) {
		register GList	*list;
		
		list=List->children;
		while (list) {
			if (gtk_object_get_user_data(GTK_OBJECT(list->data))==tree->current)
				break;
			list=list->next;
		}
		if (list) {
			gtk_list_select_child(List, list->data);
			reposition=TRUE;
		}
	}
	
	ignore_selection_events=FALSE;
	
	
	/* reposition the scrolled window
	 * to show the selected widget
	*/
	if (reposition) {
		register GtkAdjustment		*Adjustment;
		register gfloat			pos;
		register gfloat			range;
		register gfloat			value;
		
		
		if (List->selection)
			pos=gtk_list_child_position(List,
						    List->selection->data) /
			    (g_list_length(List->children) - 1.0);
		else
			pos=0;
		
		Adjustment=gtk_scrolled_window_get_vadjustment(ScrolledWindow);
		range=Adjustment->upper-Adjustment->lower;
		value=Adjustment->lower-Adjustment->page_size/2;
		value+=range*pos;
		value=CLAMP(value,
			    Adjustment->lower,
			    Adjustment->upper-Adjustment->page_size);
		_gtk_adjustment_set_value(Adjustment, value);
	}

	gtk_label_get(GTK_LABEL(widget_list->Label_symbol_name), &old_label);
	if (!old_label || strcmp(old_label, widget_data_get_symbol_name(widget_data))!=0)
		gtk_label_set(GTK_LABEL(widget_list->Label_symbol_name),
			      (gchar*)widget_data_get_symbol_name(widget_data));
	gtk_label_set(GTK_LABEL(widget_list->Label_parent_name),
			List->selection && tree->current->parent ?
			  (gchar*)widget_data_get_symbol_name(tree->current->parent) : "");
	
	
	/* what should the window be raised for,
	 * if we only do a refresh?
	*/
	/* if (widget_data==tree->current &&
	 *    GUBI_DATA(widget_data)->browser)
	 *    	_gtk_widget_raise(GUBI_DATA(widget_data)->browser);
	*/
}


void	browser_select_current_tree	(tree_S		*tree,
					 gboolean	selected)
{
	register GList	*list;
	
	g_assert(tree);
	g_assert((list=tree->widget_data_list));
	
	while (list) {
		register gb_wdat_base_S	*widget_data=list->data;
		
		if (GUBI_DATA(widget_data)->browser) {
			register listwid_widget_list_S	*widget_list;
			
			widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(widget_data)->browser));
			g_assert(widget_list);
			
			if (GTK_WIDGET_IS_SENSITIVE(widget_list->Box_selected)!=selected)
				gtk_widget_set_sensitive(widget_list->Box_selected, selected);
		}
		list=list->next;
	}

}


void
sigh_browser_List_selection_changed	(GtkList	*gtklist,
					 gpointer	func_data)
{
	register gb_wdat_base_S		*widget_data;
	register tree_S			*tree;
	
	
	/* just return if a list refresh is done
	*/
	if (ignore_selection_events)
		return;
	
	
	/* we get the widget from the current item
	 * and our tree from the widget
	*/
	if (gtklist->selection) {
		widget_data=gtk_object_get_user_data(gtklist->selection->data);
		g_assert(GB_IS_WIDDAT(widget_data));
		g_assert((tree=GUBI_DATA(widget_data)->tree));
	} else {
		widget_data=NULL;
		tree=NULL;
	}
	
	
	
	/* check current selection for the tree
	*/
	if (tree && tree->current!=widget_data) {
		register GList	*list;
		
		tree_set_current_widget_data(tree, widget_data);
		
		/* reflect new selection on the whole tree
		*/
		g_assert((list=tree->widget_data_list));
		
		while (list) {
			register gb_wdat_base_S	*widget_data;
			
			widget_data=list->data;
			if (GUBI_DATA(widget_data)->browser)
				browser_refresh_window(widget_data, TRUE);
			
			list=list->next;
		}
	}
}


void
sigh_browser_Widgets_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	if (!TypeList_Window->widget) {
		register GtkWidget	*item;
		register GList		*list, *free_list;
		
		Add_Type=ADD_AS_CHILD;
		
		
		/* initialize widgets
		*/
		
		
		/* build & connect window
		*/
		gb_window_build(TypeList_Window,
				gb_accelerator_hash_table,
				gb_accelerator_hash_table);
		gb_window_connect(TypeList_Window);
		
		
		/* fill list with widget types,
		 * we use user_data of the GtkListItem for the widget index
		*/
		free_list=list=gsi_struct_info_list(GSI_SORT_BY_TYPE);
		while (list) {
			register gchar				*name;
			register const gsi_struct_info_S	*struct_info;
			
			struct_info=list->data;
			
			if ( (!gsi_struct_info_is_a(struct_info, GB_WIDGET_BASE)) ||
			     gsi_struct_info_is_a(struct_info, GB_WIDGET_WINDOW) ||
			     GSI_STRUCT_FLAGS(struct_info, GB_FLAG_HIDDEN) ) {
				list=list->next;
				continue;
			}
			
			name=g_strdup((gchar*)to_UpCase(struct_info->struct_name));
			if ( TRUE /* configurable? */ ) {
				register gchar	*free_name;
				register guint	indent, l;
				
				indent=gsi_struct_info_n_parents(struct_info);
				indent=2*(MAX(1, indent)-1);
				
				free_name=name;
				l=strlen(name);
				
				name=g_new(gchar, l+2+1+indent);
				memcpy(&name[indent], free_name, l);
				
				if (GSI_STRUCT_FLAGS(struct_info, GB_FLAG_BASE_TYPE)) {
					name[l+indent]=':';
					name[l+indent+1]=':';
					name[l+indent+2]=0;
				} else
					name[l+indent]=0;
				
				for (l=0; l<indent; l++)
					name[l]=' ';
				
				g_free(free_name);
			}
			item=gtk_list_item_new_with_label(name);
			if (GSI_STRUCT_FLAGS(struct_info, GB_FLAG_BASE_TYPE))
				gtk_widget_set_sensitive(item, FALSE);
			gtk_object_set_user_data(GTK_OBJECT(item), (gpointer)struct_info->struct_type);
			gtk_container_add(GTK_CONTAINER(TypeList_List->widget), item);
			gtk_widget_show(item);
			g_free(name);
			
			list=list->next;
		}
		g_list_free(free_list);
		
		
		/* show window
		*/
		gtk_widget_show(TypeList_Window->widget);
	} else {
		_gtk_widget_raise(TypeList_Window->widget);
	}
}


void
sigh_browser_List_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*widget_data;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	widget_data=tree->current;
	if (!GUBI_DATA(widget_data)->browser) {
		if (g_list_length(GUBI_DATA(widget_data)->children)>0)
			browser_create_window(widget_data);
	} else
		_gtk_widget_raise(GUBI_DATA(widget_data)->browser);
}


void
sigh_browser_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	static	 GtkWidget	*gb_delete_dialog=NULL;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (tree && tree->current && GB_TYPE_IS_WIDDAT_WINDOW(tree->current->type)) {
		sigh_treelist_Delete_clicked(widget, func_data);
		return;
	}

	if (tree && tree->current) {
		register gb_wdat_base_S	*widget_data;
		
		widget_data=tree->current;
		
		if (!gb_delete_dialog)
			gb_delete_dialog=
				dialog_create_window	(GTK_OBJECT(widget),
							&gb_delete_dialog,
							"Delete",
							GTK_SIGNAL_FUNC(sigh_delete_widget_data_real),
							widget_data,
							"Delete  <%s> %s ?",
							widget_data_get_symbol_name(widget_data),
							g_list_length(GUBI_DATA(widget_data)->children)>0 ?
							  " recursively" : "");
	}
}


void
sigh_browser_Edit_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*widget_data;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	widget_data=tree->current;
	if (!GUBI_DATA(widget_data)->editor)
		editor_create_window(widget_data);
	else
		_gtk_widget_raise(GUBI_DATA(widget_data)->editor);
}


void
sigh_delete_widget_data_real	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*widget_data;
	register gb_wdat_base_S		*parent_data;
	register gb_wdat_base_S		*current_data;
	register gboolean		need_destroy;
	
	widget_data=func_data;
		
	g_assert(GB_IS_WIDDAT(widget_data));
	
	g_assert((tree=GUBI_DATA(widget_data)->tree));
	

	need_destroy=FALSE;
	
	current_data=tree->current;
	
	tree_set_current_widget_data(tree, NULL);
	
	
	/* refresh widget lists of all parents
	*/
	parent_data=widget_data->parent;
	while (parent_data) {
		if (GUBI_DATA(parent_data)->browser)
			browser_refresh_window(parent_data, TRUE);
		parent_data=parent_data->parent;
	}
	
	
	/* because of the `un-tree-ish` behaviour of the
	 * option menu we need the following HACK
	*/
	parent_data=widget_data;
	while (!need_destroy && parent_data) {
		if (parent_data->type==GB_WIDGET_OPTION_MENU)
			need_destroy=TRUE;
		parent_data=parent_data->parent;
	}
	if (need_destroy)
		tree_destroy(tree);
	
	parent_data=widget_data->parent;
	
	tree_unlink_widget_data_R(tree, widget_data);
	widget_data_delete_R(widget_data);
	widget_data=NULL;
	
	
	/* refresh widget lists of all parents
	 * with old current widget
	*/
	if (!g_list_find(tree->widget_data_list, current_data))
		current_data=parent_data;
	tree_set_current_widget_data(tree, current_data);
	while (parent_data) {
		if (GUBI_DATA(parent_data)->browser)
			browser_refresh_window(parent_data, TRUE);
		parent_data=parent_data->parent;
	}
	
	
	/* show tree (might involve rebuilding)
	*/
	tree_show(tree);
}


void
sigh_typelist_AddType_changed	(GtkWidget	*widget,
				 add_type_E	add_type)
{
	Add_Type=add_type;
}


gint
sigh_typelist_event		(GtkWidget	*widget,
				 GdkEventButton	*event)
{
	if (event->type==GDK_2BUTTON_PRESS && event->button==1) {
		sigh_typelist_Add_clicked(widget, NULL);
	}
	
	return FALSE;
}


void
sigh_typelist_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*parent_data;
	register gb_wdat_base_S		*widget_data;
	register gb_struct_type_E	struct_type;
	register gboolean		need_rebuild;
	register const gchar		*err_string;
	register gint			child_count_tweak;
	
	tree=tree_get_current();
	
	
	/* check for error conditions
	*/
	if (!tree || !tree->current) {
		message_create_window(GTK_OBJECT(widget), "No widget selected for adding.");
		return;
	}
	if (!GTK_LIST(TypeList_List->widget)->selection)
		struct_type=GB_STRUCT_NONE;
	else
		struct_type=(gb_struct_type_E)gtk_object_get_user_data(
			GTK_OBJECT(GTK_LIST(TypeList_List->widget)->selection->data));
	
	if (!GB_TYPE_IS_WIDDAT(struct_type) ||
	    GB_TYPE_IS_ABSTRACT(struct_type) ||
	    GB_TYPE_IS_WIDDAT_WINDOW(struct_type)) {
		message_create_window(GTK_OBJECT(widget), "No widget type selected for adding.");
		return;
	}
	
	
	/* fetch parent and child and
	 * check for validity
	*/
	parent_data=tree->current;
	widget_data=NULL;
	child_count_tweak=0;
	switch (Add_Type) {
	
	case	ADD_AS_CHILD:
		break;
	
	case	ADD_AS_PARENT:
		child_count_tweak=-1;
	case	ADD_AS_SIB_BEFORE:
	case	ADD_AS_SIB_AFTER:
		widget_data=parent_data;
		parent_data=parent_data->parent;
		if (!parent_data) {
			message_create_window	(GTK_OBJECT(widget),
						 "Widget  <%s>\nhas no parent.",
						 widget_data_get_symbol_name(widget_data));
			return;
		}
		break;
	
	default:
		g_assert_not_reached();
		break;
	}
	err_string=widget_data_check_add_type(parent_data, struct_type, child_count_tweak);
	if (err_string) {
		message_create_window(GTK_OBJECT(widget), err_string);
		return;
	}
	
	
	/* add widget
	*/
	need_rebuild=FALSE;
	switch (Add_Type) {
		register GList		*list;
		register gb_wdat_base_S	*temp_data;
		register guint		position;
	
	case	ADD_AS_CHILD:
		widget_data=widget_data_new(struct_type, NULL, FALSE);
		tree_insert_widget_data_R(tree, parent_data, widget_data, ~0);
		break;
	
	case	ADD_AS_PARENT:
		list=g_list_find(GUBI_DATA(parent_data)->children, widget_data);
		position=0;
		if (list) 
			list=list->prev;
		while (list) {
			position++;
			list=list->prev;
		}
		temp_data=widget_data_new(struct_type, NULL, FALSE);
		err_string=widget_data_check_add_type(temp_data, widget_data->type, 0);
		if (err_string) {
			message_create_window(GTK_OBJECT(widget), err_string);
			widget_data_delete_R(temp_data);
			return;
		}
		tree_unlink_widget_data_R(tree, widget_data);
		g_assert(!temp_data->linkage);
		temp_data->linkage=widget_data->linkage;
		widget_data->linkage=NULL;
		tree_insert_widget_data_R(tree, parent_data, temp_data, position);
		tree_insert_widget_data_R(tree, temp_data, widget_data, 1);
		need_rebuild=TRUE;
		break;
	
	case	ADD_AS_SIB_BEFORE:
	case	ADD_AS_SIB_AFTER:
		list=g_list_find(GUBI_DATA(parent_data)->children, widget_data);
		position=0;
		if (list && Add_Type==ADD_AS_SIB_BEFORE) 
			list=list->prev;
		while (list) {
			position++;
			list=list->prev;
		}
		widget_data=widget_data_new(struct_type, NULL, FALSE),
		tree_insert_widget_data_R(tree, parent_data, widget_data, position);
		need_rebuild=TRUE;
		break;
	
	default:
		g_assert_not_reached();
		break;
	}
	
	
	/* refresh widget lists of all parents
	*/
	while (widget_data) {
		if (GUBI_DATA(widget_data)->browser)
			browser_refresh_window(widget_data, FALSE);
		widget_data=widget_data->parent;
	}
	
	
	/* rebuilg tree if neccessary
	*/
	if (need_rebuild) {
		tree_rebuild(tree);
		tree_show(tree);
	}
}
